SELECT iddebito                                 AS iddebito,
       exercicio                                AS exercicio,
       tipocadastro                             AS tipocadastro,
       cadastrogeral                            AS cadastrogeral,
       tipodivida                               AS tipodivida,
       subdivida                                AS subdivida ,
       SUM(valorArquivo)                        AS valorArquivo,
       SUM(valorIntegrado)                      AS valorIntegrado,
       SUM(valorArquivo) - SUM(valorIntegrado)  AS valorDiferenca
FROM (
--Integracao patrimonial
  SELECT td.exercicio                 AS exercicio,
         tc.descricao                 AS tipocadastro,
         td.cadastrogeral             AS cadastrogeral,
         tgr.descricao                AS tipodivida,
         td.subdivida                 AS subdivida,
         SUM(COALESCE(iip.valor, 0))  AS valorIntegrado,
         0                            AS valorArquivo,
         td.iddebito                  AS iddebito
  FROM integracaopatrimonial ip
       JOIN itemintegracaopatrimonial iip ON iip.idintegracaopatrimonial  = ip.id
       JOIN tribreceita                tr ON tr.receita = iip.tributo AND tr.exercicio = ip.exercicio
                                             AND tr.entidade = ip.entidade
       JOIN tribreceitatipo           trt ON trt.tiporeceita = tr.tiporeceita
       JOIN tribdebito                 td ON td.iddebito = iip.iddebito
       JOIN tribtipocadastro           tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento      tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                             AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE ip.datamovimento  BETWEEN :dataInicial AND :dataFinal
          AND ip.situacaointegracaopatrimonial <> 'ESTORNADO_CONTABILIDADE'
          AND iip.tipomovimento IN ('CANCELAMENTO', 'DACAO_PAGAMENTO', 'DESCONTO_PARCELAMENTO')
          AND iip.situacaolegal = 0
          AND trt.classificacaoreceitatipo IN (1,2,3,4,5,7)
  GROUP BY td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao, td.subdivida, td.iddebito
  UNION ALL
  --Integracao contábil (financeira)
  SELECT td.exercicio                          AS exercicio,
         tc.descricao                          AS tipocadastro,
         td.cadastrogeral                      AS cadastrogeral,
         tgr.descricao                         AS tipodivida,
         td.subdivida                          AS subdivida,
         SUM(COALESCE(liic.valordeducao , 0))  AS valorIntegrado,
         0                                     AS valorArquivo,
         td.iddebito                           AS iddebito
  FROM loteintegracaocontabil lic
       JOIN loteitemintegracaocontabil liic ON liic.idlote = lic.id
       JOIN tribreceita                  tr ON tr.id = liic.idtributo
       JOIN tribreceitatipo             trt ON trt.tiporeceita = tr.tiporeceita
       JOIN tribdebito                   td ON td.iddebito = liic.iddebito
       JOIN tribtipocadastro             tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento        tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio                                               AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE lic.datalote BETWEEN :dataInicial AND :dataFinal
        AND lic.tipoLote ='PAGAMENTO'
        AND lic.situacaointegracaocontabil <> 'ESTORNADO_CONTABILIDADE'
        AND liic.situacaolegal = 0
        AND liic.valordeducao > 0
        AND trt.classificacaoreceitatipo IN (1,2,3,4,5,7)
  GROUP BY td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao, td.subdivida, td.iddebito
  UNION ALL
  -- Dedução de pagamentos
  SELECT     tdpr.exercicio                 AS exercicio,
             tc.descricao                   AS tipocadastro,
             tdpr.cadastrogeral             AS cadastrogeral,
             tgr.descricao                  AS tipodivida,
             tdpr.subdivida                 AS subdivida,
             0                              AS valorIntegrado,
             SUM(COALESCE(tdpag.valor, 0))  AS valorArquivo,
             td.iddebito                    AS iddebito
  FROM tceDeducaoCredito        tdc
       JOIN tceDeducaoPagamento      tdpag ON tdpag.idtcededucaocredito = tdc.idtcededucaocredito
       JOIN tribpagamentodebito      tpd   ON tpd.iddebitoparcelareceita = tdpag.iddebitoparcelareceita 
                                              AND tpd.idpagamentobloqueto = tdpag.idpagamentobloqueto
       JOIN tribpagamentobloqueto    tpb   ON tpb.idpagamentobloqueto  = tpd.idpagamentobloqueto
       JOIN tribdebitoparcelareceita tdpr  ON tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
       JOIN tribdebito                  td ON td.exercicio = tdpr.exercicio  AND td.cadastrogeral = tdpr.cadastrogeral
                                              AND td.tipocadastro = tdpr.tipocadastro AND td.guiarecolhimento = tdpr.guiarecolhimento
                                              AND td.subdivida = tdpr.subdivida AND td.entidade = tdpr.entidade
       JOIN tribtipocadastro            tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento       tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                              AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal
  GROUP BY tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
  UNION ALL
  -- Cancelamentos
  SELECT     tdpr.exercicio                 AS exercicio,
             tc.descricao                   AS tipocadastro,
             tdpr.cadastrogeral             AS cadastrogeral,
             tgr.descricao                  AS tipodivida,
             tdpr.subdivida                 AS subdivida,
             0                              AS valorIntegrado,
             SUM(COALESCE(tdcan.valor, 0))  AS valorArquivo,
             td.iddebito                    AS iddebito
  FROM tceDeducaoCredito               tdc
       JOIN tceDeducaoCancelamento     tdcan ON tdcan.idtcededucaocredito = tdc.idtcededucaocredito
       JOIN tribcancelamentodebitoitem tcdi  ON tcdi.entidade = tdcan.entidade AND tcdi.exercicio = tdcan.exercicio
                                                AND tcdi.idcancelamento = tdcan.idcancelamento 
                                                AND tcdi.iddebitoparcelareceita = tdcan.iddebitoparcelareceita
       JOIN tribdebitoparcelareceita   tdpr  ON tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
       JOIN tribdebito                    td ON td.exercicio = tdpr.exercicio  AND td.cadastrogeral = tdpr.cadastrogeral
                                                AND td.tipocadastro = tdpr.tipocadastro AND td.guiarecolhimento = tdpr.guiarecolhimento
                                                AND td.subdivida = tdpr.subdivida AND td.entidade = tdpr.entidade
       JOIN tribtipocadastro              tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento         tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                                AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal
  GROUP BY tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
  UNION ALL
  --Isenção
  SELECT     tdpr.exercicio                 AS exercicio,
             tc.descricao                   AS tipocadastro,
             tdpr.cadastrogeral             AS cadastrogeral,
             tgr.descricao                  AS tipodivida,
             tdpr.subdivida                 AS subdivida,
             0                              AS valorIntegrado,
             SUM(COALESCE(tdise.valor, 0))  AS valorArquivo,
             td.iddebito                    AS iddebito
  FROM tceDeducaoCredito             tdc
       JOIN tceDeducaoIsencao           tdise ON tdise.idtcededucaocredito = tdc.idtcededucaocredito
       JOIN tribdebitoreceita           tdr   ON tdr.iddebitoreceita = tdise.iddebitoreceita
       JOIN tribdebitoreceitaisencao    tdri  ON tdri.entidade = tdr.entidade AND tdri.exercicio = tdr.exercicio
                                                 AND tdri.tipocadastro = tdr.tipocadastro AND tdri.cadastrogeral = tdr.cadastrogeral
                                                 AND tdri.guiarecolhimento = tdr.guiarecolhimento AND tdri.subdivida = tdr.subdivida
                                                 AND tdri.receita = tdr.receita
       JOIN tribdebitoparcelareceita    tdpr  ON tdpr.entidade = tdri.entidade AND tdpr.exercicio = tdri.exercicio 
                                                 AND tdpr.tipocadastro = tdri.tipocadastro AND tdpr.cadastrogeral = tdri.cadastrogeral 
                                                 AND tdpr.guiarecolhimento = tdri.guiarecolhimento AND tdpr.subdivida = tdri.subdivida 
                                                 AND tdpr.receita = tdri.receita
       JOIN tribdebito                     td ON td.exercicio = tdpr.exercicio  AND td.cadastrogeral = tdpr.cadastrogeral
                                                 AND td.tipocadastro = tdpr.tipocadastro AND td.guiarecolhimento = tdpr.guiarecolhimento
                                                 AND td.subdivida = tdpr.subdivida AND td.entidade = tdpr.entidade
       JOIN tribtipocadastro               tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento          tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                                 AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal
    		AND not exists(
		      SELECT 1
		      FROM TRIBDEBITORECEITAISENCAO  x
		           LEFT OUTER JOIN tribisencao ti ON ti.isencao = x.isencao
		      WHERE tdri.entidade = x.entidade AND tdri.EXERCICIO  = x.exercicio
		            AND tdri.TIPOCADASTRO  = x.tipocadastro AND tdri.CADASTROGERAL  = x.cadastrogeral
          		    AND tdri.GUIARECOLHIMENTO  = x.guiarecolhimento AND tdri.SUBDIVIDA  = x.subdivida
		            AND tdri.receita = x.receita AND tdri.ISENCAO = x.ISENCAO
		            AND COALESCE(ti.CONTABILIZA, 'N') = ' N'
                    AND COALESCE(ti.CONTABILIZATAXA, ' N') = ' N'
                    AND COALESCE(ti.CONTABILIZACONTRIBUICAO, ' N') = ' N')
  GROUP BY tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
  UNION ALL
  --Dedução credito contribuinte
  SELECT     tdpr.exercicio                 AS exercicio,
             tc.descricao                   AS tipocadastro,
             tdpr.cadastrogeral             AS cadastrogeral,
             tgr.descricao                  AS tipodivida,
             tdpr.subdivida                 AS subdivida,
             0                              AS valorIntegrado,
             SUM(COALESCE(tcred.valor, 0))  AS valorArquivo,
             td.iddebito                    AS iddebito
  FROM tceDeducaoCredito                 tdc
       JOIN tceDeducaoCreditoCredito     tcred ON tcred.idTceDeducaoCredito = tdc.idTceDeducaoCredito
       JOIN tribcreditocontribuinteitem  tcci  ON tcci.idcreditocontribuinteitem = tcred.idcreditocontribuinteitem AND tcci.iddebitoparcelareceita = tcred.iddebitoparcelareceita
       JOIN tribdebitoparcelareceita     tdpr  ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
       JOIN tribdebito                      td ON td.exercicio = tdpr.exercicio  AND td.cadastrogeral = tdpr.cadastrogeral
                                                  AND td.tipocadastro = tdpr.tipocadastro AND td.guiarecolhimento = tdpr.guiarecolhimento
                                                  AND td.subdivida = tdpr.subdivida AND td.entidade = tdpr.entidade
       JOIN tribtipocadastro                tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento           tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                                  AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal
  GROUP BY tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
  UNION ALL
  --Dedução parcelamento
  SELECT     tdpr.exercicio               AS exercicio,
             tc.descricao                 AS tipocadastro,
             tdpr.cadastrogeral           AS cadastrogeral,
             tgr.descricao                AS tipodivida,
             tdpr.subdivida               AS subdivida,
             0                            AS valorIntegrado,
             SUM(COALESCE(tdp.valor, 0))  AS valorArquivo,
             td.iddebito                  AS iddebito
  FROM tceDeducaoCredito             tdc
       JOIN tcededucaoparc                tdp ON tdp.idTceDeducaoCredito = tdc.idTceDeducaoCredito
       JOIN tribdebitoParcelaReceita     tdpr ON tdpr.iddebitoParcelaReceita = tdp.idDebitoParcelaReceita
       JOIN tribdebito                     td ON td.exercicio = tdpr.exercicio  AND td.cadastrogeral = tdpr.cadastrogeral
                                                 AND td.tipocadastro = tdpr.tipocadastro AND td.guiarecolhimento = tdpr.guiarecolhimento
                                                 AND td.subdivida = tdpr.subdivida AND td.entidade = tdpr.entidade
       JOIN tribtipocadastro           tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento      tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                                   AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal
  GROUP BY tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
      ) filtro
WHERE :whereParam
GROUP BY exercicio, tipocadastro, cadastrogeral, tipodivida, subdivida, iddebito
HAVING :comDiferencaParam
ORDER BY :sortParam