select 11                                      as codigoArquivo,
       'Deduções dos Créditos em Dívida Ativa' as arquivo,
       'DEBITO'                                as tipoArquivo,
       arquivo.valor                           as valorArquivo,
       integracao.valor                        as valorIntegracao,
       0                                       as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tcededucaocreditoda tdc
        join triberrosimportacaosimam teis on
        teis.idregistro = tdc.idtcededucaocreditoda
        and teis.identificadorarquivo = 'DEDUCAO_CREDITO_DIVIDA_ATIVA'
        where tdc.dtdeducao between :dataInicial and :dataFinal) as temerroimportacao,
       (select case when count(tdc.idtcededucaocreditoda) > 0 then 'true' else 'false' end
        from tcededucaocreditoda tdc
        where tdc.dtdeducao between :dataInicial and :dataFinal
        and (tdc.nrdivida is null or tdc.nranodivida is null)) as temerronrcreditodivida
from (
         select sum(filtro.vlDeducao) as valor
         from (
                  select coalesce(tdc.vlDeducao, 0) as vlDeducao
                  from tceDeducaoCreditoDA tdc
                  where tdc.dtdeducao between :dataInicial and :dataFinal
                  ) filtro
     ) as arquivo
         cross join (select sum(valor) as valor
                     from (
                              select iip.valor as valor
                              from integracaopatrimonial ip
                                       left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                                       left join tribreceita r
                                                 on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                                    r.entidade = ip.entidade
                                       JOIN tribreceitatipo trt
                                            ON trt.tiporeceita = r.tiporeceita
                              where ip.entidade = :entidade
                                and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                                and ip.datamovimento between :dataInicial and :dataFinal
                                and iip.tipomovimento in ('CANCELAMENTO', 'DACAO_PAGAMENTO','DESCONTO_PARCELAMENTO')
                                and iip.situacaolegal in (1, 2)
                                and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE'
                              union all
                              select liic.valordeducao
                              from loteintegracaocontabil lic
                                  left join loteitemintegracaocontabil liic
                              on lic.id = liic.idlote
                                  left join tribreceita tr on liic.idtributo = tr.id
                                  left JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                              where lic.datalote between :dataInicial
                                and :dataFinal
                                and liic.situacaolegal in (1, 2)
                                and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                                and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
                                and lic.tipolote in ('PAGAMENTO','REABILITACAO_PAGAMENTO')
                                and liic.valordeducao > 0) as dados
) as integracao