SELECT TRIBCADASTROGERAL.IDKEY AS idCadastro,
       TRIBCADASTROGERAL.TIPOCADASTRO AS tipocadastro,
       TRIBCADASTROGERAL.CADASTROGERAL AS cadastrogeral,
       CASE WHEN PESSOAIMOBILIARIO.PESSOA IS NOT NULL THEN PESSOAIMOBILIARIO.PESSOA  ELSE TRIBVIEWPROPRIETARIO.PESSOA END AS codigoPessoa,
       CASE WHEN PESSOAIMOBILIARIO.NOME IS NOT NULL THEN PESSOAIMOBILIARIO.NOME ELSE TRIBVIEWPROPRIETARIO.NOME END AS nomePessoa
FROM TRIBROCADA TRIBROCADA
    INNER JOIN TRIBROCADACADASTRO TRIBROCADACADASTRO ON TRIBROCADA.ENTIDADE = TRIBROCADACADASTRO.ENTIDADE
								   AND TRIBROCADA.EXERCICIO = TRIBROCADACADASTRO.EXERCICIO
								   AND TRIBROCADA.ROCADA = TRIBROCADACADASTRO.ROCADA
    INNER JOIN TRIBBLOQUETO TRIBBLOQUETO ON TRIBROCADACADASTRO.ENTIDADE = TRIBBLOQUETO.ENTIDADE
								   AND TRIBROCADACADASTRO.EXERCICIOBLOQUETO = TRIBBLOQUETO.EXERCICIOBLOQUETO
								   AND TRIBROCADACADASTRO.BLOQUETO = TRIBBLOQUETO.BLOQUETO
    INNER JOIN TRIBCADASTROGERAL TRIBCADASTROGERAL ON TRIBROCADACADASTRO.TIPOCADASTRO = TRIBCADASTROGERAL.TIPOCADASTRO
								   AND TRIBROCADACADASTRO.CADASTROGERAL = TRIBCADASTROGERAL.CADASTROGERAL
    LEFT OUTER JOIN TRIBPROPRIETARIO TRIBPROPRIETARIO ON TRIBPROPRIETARIO.TIPOCADASTRO = TRIBCADASTROGERAL.TIPOCADASTRO
								   AND TRIBPROPRIETARIO.CADASTROGERAL = TRIBCADASTROGERAL.CADASTROGERAL
								   AND TRIBPROPRIETARIO.CORESPONSAVELPRINCIPAL = 'S'
								   AND TRIBPROPRIETARIO.VINCULO = :VINCULO
    LEFT JOIN PESSOA PESSOAIMOBILIARIO ON TRIBPROPRIETARIO.PESSOA = PESSOAIMOBILIARIO.PESSOA
    LEFT OUTER JOIN TRIBVIEWPROPRIETARIO TRIBVIEWPROPRIETARIO ON TRIBVIEWPROPRIETARIO.TIPOCADASTRO = TRIBCADASTROGERAL.TIPOCADASTRO
								   AND TRIBVIEWPROPRIETARIO.CADASTROGERAL = TRIBCADASTROGERAL.CADASTROGERAL
								   AND TRIBPROPRIETARIO.PESSOA IS NULL
								   AND TRIBVIEWPROPRIETARIO.PRINCIPAL = 'S'
								   AND TRIBVIEWPROPRIETARIO.TIPOVINCULO = 1
WHERE TRIBCADASTROGERAL.EXCLUSAOLOGICA = 'N'
%s