SELECT TRIBDEBITO.IDDEBITO,
	   TRIBDEBITO.EXERCICIO,
       TRIBDEBITO.GUIARECOLHIMENTO AS divida,
	   MIN(TRIBDEBITOPARCELA.DATAVENCIMENTO) AS dataVencimento,
	   SUM(TRIBDEBITOPARCELARECEITA.VALOR) AS valor
FROM TRIBDEBITOPARCELARECEITA TRIBDEBITOPARCELARECEITA
INNER JOIN TRIBDEBITO TRIBDEBITO ON TRIBDEBITOPARCELARECEITA.ENTIDADE = TRIBDEBITO.ENTIDADE
                                AND TRIBDEBITOPARCELARECEITA.EXERCICIO = TRIBDEBITO.EXERCICIO
                                AND TRIBDEBITOPARCELARECEITA.TIPOCADASTRO = TRIBDEBITO.TIPOCADASTRO
                                AND TRIBDEBITOPARCELARECEITA.CADASTROGERAL = TRIBDEBITO.CADASTROGERAL
                                AND TRIBDEBITOPARCELARECEITA.GUIARECOLHIMENTO = TRIBDEBITO.GUIARECOLHIMENTO
                                AND TRIBDEBITOPARCELARECEITA.SUBDIVIDA = TRIBDEBITO.SUBDIVIDA
LEFT OUTER JOIN PARAMETROENTIDADEEXERCICIO PEX ON PEX.ENTIDADE = TRIBDEBITO.ENTIDADE
                                              AND PEX.EXERCICIO = TRIBDEBITO.EXERCICIO
                                              AND PEX.MODULO = '05'
                                              AND PEX.PARAMETRO = 'FORMACORRECAOPADRAO'
LEFT OUTER JOIN TRIBDEBITOPARCELA TRIBDEBITOPARCELA ON TRIBDEBITOPARCELARECEITA.ENTIDADE = TRIBDEBITOPARCELA.ENTIDADE
                                                   AND TRIBDEBITOPARCELARECEITA.EXERCICIO = TRIBDEBITOPARCELA.EXERCICIO
                                                   AND TRIBDEBITOPARCELARECEITA.TIPOCADASTRO = TRIBDEBITOPARCELA.TIPOCADASTRO
                                                   AND TRIBDEBITOPARCELARECEITA.CADASTROGERAL = TRIBDEBITOPARCELA.CADASTROGERAL
                                                   AND TRIBDEBITOPARCELARECEITA.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
                                                   AND TRIBDEBITOPARCELARECEITA.SUBDIVIDA = TRIBDEBITOPARCELA.SUBDIVIDA
                                                   AND TRIBDEBITOPARCELARECEITA.PARCELA = TRIBDEBITOPARCELA.PARCELA
LEFT OUTER JOIN TRIBDEBITORECEITA TRIBDEBITORECEITA ON TRIBDEBITORECEITA.ENTIDADE = TRIBDEBITOPARCELARECEITA.ENTIDADE
                                                   AND TRIBDEBITORECEITA.EXERCICIO = TRIBDEBITOPARCELARECEITA.EXERCICIO
                                                   AND TRIBDEBITORECEITA.TIPOCADASTRO = TRIBDEBITOPARCELARECEITA.TIPOCADASTRO
                                                   AND TRIBDEBITORECEITA.CADASTROGERAL = TRIBDEBITOPARCELARECEITA.CADASTROGERAL
                                                   AND TRIBDEBITORECEITA.GUIARECOLHIMENTO = TRIBDEBITOPARCELARECEITA.GUIARECOLHIMENTO
                                                   AND TRIBDEBITORECEITA.SUBDIVIDA = TRIBDEBITOPARCELARECEITA.SUBDIVIDA
                                                   AND TRIBDEBITORECEITA.RECEITA = TRIBDEBITOPARCELARECEITA.RECEITA
LEFT OUTER JOIN TRIBRECEITA TRIBRECEITA ON TRIBDEBITORECEITA.ENTIDADE = TRIBRECEITA.ENTIDADE
                                       AND TRIBDEBITORECEITA.EXERCICIO = TRIBRECEITA.EXERCICIO
                                       AND TRIBDEBITORECEITA.RECEITA = TRIBRECEITA.RECEITA
LEFT OUTER JOIN TRIBRECEITATIPO TRIBRECEITATIPO ON TRIBRECEITA.TIPORECEITA = TRIBRECEITATIPO.TIPORECEITA
LEFT OUTER JOIN TRIBCADASTROGERAL TRIBCADASTROGERAL ON TRIBCADASTROGERAL.TIPOCADASTRO = TRIBDEBITO.TIPOCADASTRO
                                                   AND TRIBCADASTROGERAL.CADASTROGERAL = TRIBDEBITO.CADASTROGERAL
LEFT OUTER JOIN TRIBSITUACAOPARCELA TRIBSITUACAOPARCELA ON TRIBSITUACAOPARCELA.SITUACAOPARCELA = TRIBDEBITOPARCELA.SITUACAODEBITO
LEFT OUTER JOIN TRIBTIPOSITUACAOPARCELA TRIBTIPOSITUACAOPARCELA ON TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA = TRIBSITUACAOPARCELA.TIPOSITUACAOPARCELA
LEFT OUTER JOIN PESSOA PESSOA ON TRIBCADASTROGERAL.PESSOA = PESSOA.PESSOA
LEFT OUTER JOIN TRIBGUIARECOLHIMENTO TRIBGUIARECOLHIMENTO ON TRIBGUIARECOLHIMENTO.ENTIDADE = TRIBDEBITO.ENTIDADE
                                                         AND TRIBGUIARECOLHIMENTO.EXERCICIO = TRIBDEBITO.EXERCICIO
                                                         AND TRIBGUIARECOLHIMENTO.GUIARECOLHIMENTO = TRIBDEBITO.GUIARECOLHIMENTO
LEFT OUTER JOIN TRIBPARCELAMENTO TRIBPARCELAMENTO ON TRIBDEBITO.IDPARCELAMENTO = TRIBPARCELAMENTO.IDPARCELAMENTO
WHERE ${FILTRO}
  AND TRIBDEBITO.TIPOCADASTRO = ?
  AND TRIBDEBITO.CADASTROGERAL = ?
  AND TRIBDEBITOPARCELARECEITA.valor > 0
  AND TRIBTIPOSITUACAOPARCELA.TIPO = 'A'
  AND TRIBCADASTROGERAL.EXCLUSAOLOGICA = 'N'
GROUP BY TRIBDEBITO.IDDEBITO,
         TRIBDEBITO.EXERCICIO,
         TRIBDEBITO.GUIARECOLHIMENTO
ORDER BY TRIBDEBITO.IDDEBITO
