Select 'Débito Vencido' as resultado
     from tribDebito td
     left outer join tribDebitoParcela tdp on td.Entidade = tdp.Entidade
                                           and td.Exercicio = tdp.Exercicio
                                           and td.TipoCadastro = tdp.TipoCadastro
                                           and td.CadastroGeral = tdp.CadastroGeral
                                           and td.GuiaRecolhimento = tdp.GuiaRecolhimento
                                           and td.SubDivida = tdp.SubDivida
     left outer join tribsituacaoparcela tsp on tdp.situacaodebito = tsp.situacaoparcela
     left outer join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela
     left outer join tribGuiaRecolhimento guia on td.entidade = guia.entidade
                                               and td.exercicio = guia.exercicio
                                               and td.guiarecolhimento = guia.guiarecolhimento
     where td.Entidade = :entidade
        and td.tipoCadastro = :tipoCadastro
        and td.CadastroGeral = :cadastroGeral
        and tdp.datavencimento < :dataVencimento
        and ttsp.tipoSituacaoParcela = 1
        %s
        and td.Constituido = 'S'
        and (Select sum(a.valor)
                from tribdebitoparcelareceita a
                Where a.Entidade = tdp.Entidade
                and a.TipoCadastro = tdp.TipoCadastro
                and a.CadastroGeral = tdp.CadastroGeral
                and a.Exercicio = tdp.Exercicio
                and a.GuiaREcolhimento = tdp.GuiaRecolhimento
                and a.SubDivida = tdp.SubDivida
                and a.Parcela = tdp.Parcela) > 0
union all
select 'Cadastro Inválido'
    from tribMobiliarioSituacao a
    left outer join tribsituacaoMobiliario b on a.SituacaoMobiliario = b.SituacaoMobiliario
    left outer join tribTiposituacaoMobiliario c on b.TipoSituacaoMobiliario = c.TipoSituacaoMobiliario
    left outer join tribcadastromobiliario d on a.tipocadastro = d.tipocadastro
                                             and a.cadastrogeral = d.cadastrogeral
    where a.TipoCadastro = :tipoCadastro
        and a.CadastroGeral = :cadastroGeral
        and a.Atual = 'S'
        and c.tiposituacaomobiliario in (5, 6)
        or (d.dataalvara > :dataVencimento)