SELECT TPI.CATEGORIA as categoria,
	   TPI.DESTINACAO as destinacao,
	   TPI.TIPOOBRA as tipoObra,
       TPI.TIPOCONSTRUCAO as tipoConstrucao,
	   SUM(TPI.AREA) as area,
	   MIN(TPI.SEQUENCIAAREA) as sequenciaArea,
	   TPI.QTDETOTALUNIDADE as qtdeTotalUnidade
FROM TRIBPROJETO TP
JOIN TRIBPROJETOITEM TPI ON TPI.ENTIDADE = TP.ENTIDADE AND TPI.EXERCICIO = TP.EXERCICIO AND TPI.PROJETO = TP.PROJETO
WHERE TP.ENTIDADE = :entidade
  AND TP.EXERCICIO = :exercicio
  AND TP.PROJETO = :projeto
GROUP BY TPI.CATEGORIA,
         TPI.DESTINACAO,
         TPI.TIPOOBRA,
         TPI.TIPOCONSTRUCAO,
         TPI.QTDETOTALUNIDADE
ORDER BY MIN(TPI.SEQUENCIAAREA)