SELECT DOC.ENTIDADE, DOC.EXERCICIO, DOC.TIPODOCUMENTO,
       case when (doc.tipoDocumento = 14 ) then 'Alvará' when (doc.tipoDocumento = 15 ) then 'Habitese' end as TIPODOCUMENTODESC,
       DOC.DOCUMENTO, DOC.DATACANCELAMENTO, DOC.USUARIOCANCELAMENTO,
       CASE WHEN DOC.TIPODOCUMENTO IN (15,52) THEN
         2
            WHEN DOC.TIPODOCUMENTO IN (11,14,49,50,51,53) THEN
         1
       END AS TIPODOCUMENTOALTERACAO,
       1 AS SITUACAOALTERACAO,
       CASE WHEN DOC.TIPODOCUMENTO IN (15,52) THEN
         SOH.NUMEROPROTOCOLO
       ELSE NULL END AS NUMEROPROTOCOLOHABITESE,
       CASE WHEN DOC.TIPODOCUMENTO IN (11,14,49,50,51,53) THEN
         SOA.NUMEROPROTOCOLO
       ELSE NULL END AS NUMEROPROTOCOLOALVARA,
       CASE WHEN DOC.TIPODOCUMENTO IN (11,14,49,50,51,53) THEN
         SOA.DATAALVARA
       ELSE
         SOH.DATAHABITESE
       END AS DATADOCUMENTO,
       CASE
         WHEN SOA.NUMEROALVARA IS NOT NULL THEN EXTRACT(MONTH FROM SOA.dataalvara)
         WHEN SOH.Numerohabitese IS NOT NULL THEN EXTRACT(MONTH FROM SOH.DATAHABITESE)
       END AS mesdocumento,
       CASE
         WHEN SOA.NUMEROALVARA IS NOT NULL THEN EXTRACT(YEAR FROM SOA.dataalvara)
         WHEN SOH.Numerohabitese IS NOT NULL THEN EXTRACT(YEAR FROM SOH.DATAHABITESE)
       END AS anodocumento,
       CASE WHEN COALESCE(SAS.ENVIADO,'N') = 'S' THEN TRUE ELSE FALSE END AS ENVIADO,
       CASE WHEN COALESCE(SAS.ENVIADOCOMSUCESSO,'N') = 'S' THEN TRUE ELSE FALSE END AS ENVIADOCOMSUCESSO,
       coalesce(SAS.ID,0) as idAlteraSituacao
FROM TRIBDOCUMENTO DOC
LEFT OUTER JOIN SISOBRAALVARA SOA ON cast(SOA.NUMEROALVARA as numeric(10)) = DOC.DOCUMENTO AND SOA.DATAALVARA = DOC.DATAEMISSAO
LEFT OUTER JOIN SISOBRAHABITESE SOH ON cast(SOH.NUMEROHABITESE as numeric(10)) = DOC.DOCUMENTO AND SOH.DATAHABITESE = DOC.DATAEMISSAO
LEFT OUTER JOIN SISOBRAALTERACAOSITUACAO SAS ON SAS.ANO  = DOC.EXERCICIO AND SAS.TIPODOCUMENTOORIGINAL = DOC.TIPODOCUMENTO AND CAST( SAS.NUMERODOCUMENTO AS NUMERIC(10)) = DOC.DOCUMENTO
WHERE DOC.CANCELADO = 'S'
AND DOC.TIPODOCUMENTO IN (11,14,15,49,50,51,52,53)
AND NOT (DOC.TIPODOCUMENTO = 14 AND DOC.SUBTIPO IN ('3','5','7'))
AND NOT ((DOC.TIPODOCUMENTO IN (50,51)) AND DOC.SUBTIPO = '1')
AND ((DOC.DATACANCELAMENTO >= :dataInicial) AND  (DOC.DATACANCELAMENTO <= :dataFinal))
limit :limit
offset :offset