select a.TipoCadastro,
       a.CadastroGeral,
       a.idKey as idCadastro,
       b.cnpj_cpf as cpfCnpj,
       case when b.tipopessoa = 'J' 
            then 'Jurídica'
            else 'Física'
       end as tipoPessoa,
       b.nome,
       b.pessoa,
       tl.descricao as tipoLogradouro,
       lg.descricao as logradouro,
       a.numero as numero,
       ba.descricao as bairro,
       ci.descricao as cidade,
       ci.unidadefederacao as unidadeFederacao,
       tv.tipovinculo,
       tv.descricao as VinculoDescricao,
       cast(0 as numeric) as principal,
       'OK' as situacao
  from tribcadastrogeral a
  left outer join tribproprietario prop on (prop.tipocadastro = a.tipocadastro and
                                        prop.cadastrogeral = a.cadastrogeral)
  left outer join pessoa b on (prop.pessoa = b.pessoa)
  left outer join tribvinculo tv on (prop.vinculo = tv.vinculo)
  left outer join logradouro lg on lg.cidade = a.cidade
                                and lg.logradouro = a.logradouro
  left outer join tipologradouro tl on tl.tipologradouro = lg.tipologradouro
  left outer join bairro ba on ba.cidade = a.cidade
                            and ba.bairro = a.bairro
  left outer join cidade ci on ci.cidade = a.cidade
 Where tv.tipovinculo = 5
 and a.exclusaologica = 'N'