SELECT
   parcelamentoDebitoOrigem.iddebito,
   parcelamentoDebitoOrigem.idparcelamento,
   debitoParcela.entidade,
   debitoParcela.tipoCadastro,
   debitoParcela.cadastroGeral,
   debitoparcela.parcela,
   debitoparcela.datavencimento,
   situacaoparcela.descricao AS situacao,
   tiposituacaoparcela.tiposituacaoparcela,
   CASE WHEN (tiposituacaoparcela.tipo = 'A') THEN 1 ELSE 0 END AS aberto,
   SUM(debitoParcelareceita.valor) AS valor,
   SUM(debitoParcelareceita.valorJuros) AS valorJuros,
   SUM(debitoParcelareceita.valorMulta) AS valorMulta,
   SUM(debitoParcelareceita.valorCorrecao) AS valorCorrecao,
   SUM(debitoParcelareceita.valorDesconto) AS valordesconto
FROM
	Tribparcelamentodebitoorigem parcelamentoDebitoOrigem
INNER JOIN tribdebito debito
    ON parcelamentoDebitoOrigem.iddebitonovo = debito.iddebito
INNER JOIN tribDebitoParcela debitoParcela
    ON debito.ENTIDADE = debitoParcela.ENTIDADE
	AND debito.EXERCICIO = debitoParcela.EXERCICIO
	AND debito.TIPOCADASTRO = debitoParcela.TIPOCADASTRO
	AND debito.CADASTROGERAL = debitoParcela.CADASTROGERAL
	AND debito.GUIARECOLHIMENTO = debitoParcela.GUIARECOLHIMENTO
	and debito.subdivida = debitoparcela.subdivida
LEFT JOIN TRIBDOCUMENTOITEMDIVIDAATIVA tda
	ON tda.entidade = debito.entidade
	AND tda.exercicioDebito = debito.exercicio
	AND tda.tipocadastro = debito.tipocadastro
	AND tda.cadastrogeral = debito.cadastrogeral
	AND tda.guiarecolhimento = debito.guiarecolhimento
	and TDA.subdivida = debito.subdivida
LEFT JOIN TribDebitoParcelaReceita debitoparcelareceita
    ON debito.entidade = debitoParcelaReceita.entidade
    AND debito.exercicio = debitoParcelaReceita.exercicio
    AND debito.tipoCadastro = debitoParcelaReceita.tipoCadastro
    AND debito.cadastroGeral = debitoParcelaReceita.cadastroGeral
    AND debito.guiaRecolhimento = debitoParcelaReceita.guiaRecolhimento
    AND debito.subDivida = debitoParcelaReceita.subDivida
LEFT JOIN TRIBSITUACAOPARCELA situacaoParcela ON
	debitoParcela.SITUACAODEBITO = situacaoParcela.SITUACAOPARCELA
LEFT JOIN TRIBTIPOSITUACAOPARCELA tipoSituacaoParcela ON
	tipoSituacaoParcela.TIPOSITUACAOPARCELA = situacaoParcela.TIPOSITUACAOPARCELA
LEFT JOIN tribparcelamento parcelamento
	ON parcelamento.idparcelamento = debito.idparcelamento
WHERE (debito.parcelado = 'S' OR debito.reparcelado = 'S')
    AND parcelamentoDebitoOrigem.iddebito IN (:ids)
GROUP BY parcelamentoDebitoOrigem.iddebito,
    parcelamentoDebitoOrigem.idparcelamento,
    debitoparcela.entidade,
    debito.exercicio,
    debitoparcela.tipoCadastro, 
    debitoparcela.cadastroGeral, 
    debito.guiaRecolhimento,
    debito.subDivida,
    debitoparcela.parcela,
    debitoparcela.datavencimento,
    debito.dataLancamento,
    situacaoparcela.descricao,
    tiposituacaoparcela.tiposituacaoparcela
ORDER BY
    debito.exercicio DESC,
    debito.guiaRecolhimento,
    debito.subdivida