with projeto as
(
SELECT  P.entidade,
        P.exercicio exercicioProjeto,
        P.projeto,
        P.tipoCadastro,
        P.cadastroGeral,
        P.tipoProjeto,
        P.data,
        P.situacao,
        P.aprovado,
        P.exercicioProtocolo,
        P.idProcesso,
        p.projetoSubstituido,
        p.exercicioProjetoSubstituido,
        p.idProcessoIsencao,
        p.exercicioProtocoloIsencao,
        p.isencao,
        PESRP.TIPOPESSOA tipoPessoaConstrutor,
        PESRP.PESSOA construtor,
        PESRP.NOME nomeConstrutor,
        PESRP.CNPJ_CPF cnpjCpf,
        TLOG.sigla,
        LOGRP.DESCRICAO descrLogradouro,
        ENDRP.numero,
        endrp.complemento,
        BAIRP.DESCRICAO bairroDescr,
        ENDRP.cep,
        cid.descricao cidade,
        endrp.unidadeFederacao,
        CONT.telefoneResidencial
 FROM TRIBPROJETO P
 LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON P.ENTIDADE = TPR.ENTIDADE
                                            AND P.EXERCICIO = TPR.EXERCICIO
                                            AND P.PROJETO = TPR.PROJETO
                                            AND TPR.SEQUENCIA=1
 LEFT OUTER JOIN PESSOA PESRP ON TPR.PESSOA = PESRP.PESSOA
 LEFT OUTER JOIN ENDERECOPESSOA ENDRP ON PESRP.PESSOA = ENDRP.PESSOA
                                      AND PESRP.SEQUENCIAENDERECO = ENDRP.SEQUENCIA
 left outer join cidade cid on cid.cidade = endrp.cidade
 LEFT OUTER JOIN LOGRADOURO LOGRP ON ENDRP.LOGRADOURO = LOGRP.LOGRADOURO
                                  AND ENDRP.CIDADE = LOGRP.CIDADE
 LEFT OUTER JOIN TIPOLOGRADOURO TLOG ON LOGRP.TIPOLOGRADOURO = TLOG.TIPOLOGRADOURO
 LEFT OUTER JOIN BAIRRO BAIRP ON ENDRP.BAIRRO = BAIRP.BAIRRO
                              AND ENDRP.CIDADE = BAIRP.CIDADE
 LEFT OUTER JOIN CONTATOPESSOA CONT ON CONT.PESSOA = PESRP.PESSOA
                                    AND CONT.SEQUENCIA = 1
 LEFT OUTER JOIN TRIBDOCUMENTO DOC ON DOC.ENTIDADE = P.ENTIDADE
                                      AND DOC.EXERCICIOPROJETO = P.EXERCICIO
                                      AND DOC.TIPODOCUMENTO IN (11,14,15)
                                      AND DOC.PROJETO = P.PROJETO
:filtromain
)
select projeto.ENTIDADE,
       projeto.EXERCICIOPROJETO,
       projeto.PROJETO,
       projeto.TIPOCADASTRO,
       projeto.CADASTROGERAL,
       projeto.TIPOPROJETO,
       projeto.DATA,
       projeto.SITUACAO,
       projeto.APROVADO,
       projeto.EXERCICIOPROTOCOLO,
       projeto.IDPROCESSO,
       projeto.projetosubstituido,
       projeto.exercicioprojetosubstituido,
       projeto.idprocessoisencao,
       projeto.exercicioprotocoloisencao,
       projeto.isencao,
       projeto.tipoPessoaConstrutor,
       projeto.construtor,
       projeto.nomeConstrutor,
       projeto.cnpjCpf,
       projeto.SIGLA,
       projeto.descrLogradouro,
       projeto.numero,
       projeto.complemento,
       projeto.bairroDescr,
       projeto.cep,
       projeto.cidade,
       projeto.unidadefederacao,
       projeto.telefoneresidencial,
       ARRAY_AGG(itens.*) as itens,
       ARRAY_AGG(debitos.*) as debitos,
       ARRAY_AGG(documentos.*) as documentos
from projeto
  left join (
  SELECT  PI.ENTIDADE,
        PI.EXERCICIO AS EXERCICIOPROJETO,
        PI.PROJETO,
        P.TIPOCADASTRO,
        P.CADASTROGERAL,
        P.TIPOPROJETO,
        P.DATA,
        PI.PROJETOITEM,
        PI.ITEMCONSTRUCAOCIVIL,
        PI.UTILIZACAO,
        PI.TIPOCONSTRUCAO,
       (PI.AREA) AS AREA
 FROM TRIBPROJETO P
     LEFT OUTER JOIN TRIBDOCUMENTO DOC ON DOC.ENTIDADE = P.ENTIDADE
                                      AND DOC.EXERCICIOPROJETO = P.EXERCICIO
                                      AND DOC.TIPODOCUMENTO IN (11,14,15)
                                      AND DOC.PROJETO = P.PROJETO
 LEFT OUTER JOIN TRIBPROJETOITEM PI ON P.ENTIDADE = P.ENTIDADE
                             AND PI.EXERCICIO = P.EXERCICIO
                             AND PI.PROJETO = P.PROJETO
:filtro
) itens
   on itens.entidade = projeto.entidade
   and itens.exercicioprojeto = projeto.exercicioprojeto
   and itens.projeto = projeto.projeto
left join (
Select dp.entidade,
       PD.EXERCICIOPROJETO,
       PD.PROJETO,
       dp.Exercicio,
       dp.GuiaRecolhimento,
       dp.Subdivida,
       dp.Parcela,
       dp.DataVencimento,
       (Select Sum(Valor)
          from tribDebitoParcelaReceita tdpr
         Where dp.Entidade = tdpr.Entidade
           and dp.Exercicio = tdpr.Exercicio
           and dp.TipoCadastro = tdpr.TipoCadastro
           and dp.CadastroGeral = tdpr.CadastroGeral
           and dp.GuiaRecolhimento = tdpr.GuiaRecolhimento
           and dp.SubDivida = tdpr.SubDivida
           and dp.Parcela = tdpr.Parcela) as Valor,
       sp.Sigla,
       dp.situacaodebito,
       d.Parcelado,
       d.Reparcelado,
       dp.mesreferencia,
       tsp.Tipo
  From TribProjetoDebito pd
    LEFT OUTER JOIN TRIBDOCUMENTO DOC ON DOC.ENTIDADE = PD.ENTIDADE
                                      AND DOC.EXERCICIOPROJETO = PD.EXERCICIOPROJETO
                                      AND DOC.TIPODOCUMENTO IN (11,14,15)
                                      AND DOC.PROJETO = PD.PROJETO
    LEFT OUTER JOIN TRIBPROJETO P ON DOC.ENTIDADE = P.ENTIDADE
                                      AND DOC.EXERCICIOPROJETO = P.EXERCICIO
                                      AND DOC.TIPODOCUMENTO IN (11,14,15)
                                      AND DOC.PROJETO = P.PROJETO
 Inner Join TribDebito d ON d.Entidade = pd.Entidade
                                And d.Exercicio = pd.ExercicioDebito
                                And d.TipoCadastro = pd.TipoCadastro
                                And d.CadastroGeral = pd.CadastroGeral
                                And d.GuiaRecolhimento = pd.GuiaRecolhimento
                                And d.Subdivida = pd.Subdivida
 Inner Join TribDebitoParcela dp On dp.Entidade = pd.Entidade
                                And dp.Exercicio = pd.ExercicioDebito
                                And dp.TipoCadastro = pd.TipoCadastro
                                And dp.CadastroGeral = pd.CadastroGeral
                                And dp.GuiaRecolhimento = pd.GuiaRecolhimento
                                And dp.Subdivida = pd.Subdivida
 Inner Join tribSituacaoParcela sp on dp.SituacaoDebito = sp.SituacaoParcela
 Inner Join tribTipoSituacaoParcela tsp on tsp.TipoSituacaoParcela = sp.TipoSituacaoParcela
 :filtro
 Order By dp.Exercicio Desc, dp.GuiaRecolhimento, dp.Subdivida, dp.Parcela
) debitos
   on debitos.entidade = projeto.entidade
   and debitos.exercicioprojeto = projeto.exercicioprojeto
   and debitos.projeto = projeto.projeto
 left join (
 select         DOC.ENTIDADE,
                DOC.TIPODOCUMENTO,
                DOC.DOCUMENTO,
                DOC.EXERCICIO AS EXERCICIO_DOCUMENTO,
                DOC.DATAEMISSAO AS DATAEMISSAO_DOC,
        doc.EXERCICIO as EXERCICIOPROJETO,
        doc.PROJETO,
        doc.cancelado
from tribdocumento doc
    LEFT OUTER JOIN TRIBPROJETO P ON DOC.ENTIDADE = P.ENTIDADE
                                      AND DOC.EXERCICIOPROJETO = P.EXERCICIO
                                      AND DOC.TIPODOCUMENTO IN (11,14,15)
                                      AND DOC.PROJETO = P.PROJETO
:filtro
) documentos
   on documentos.entidade = projeto.entidade
   and documentos.exercicioprojeto = projeto.exercicioprojeto
   and documentos.projeto = projeto.projeto
group by projeto.ENTIDADE,
         projeto.EXERCICIOPROJETO,
         projeto.PROJETO,
         projeto.TIPOCADASTRO,
         projeto.CADASTROGERAL,
         projeto.TIPOPROJETO,
         projeto.DATA,
         projeto.SITUACAO,
         projeto.APROVADO,
         projeto.EXERCICIOPROTOCOLO,
         projeto.IDPROCESSO,
         projeto.projetosubstituido,
         projeto.exercicioprojetosubstituido,
         projeto.idprocessoisencao,
         projeto.exercicioprotocoloisencao,
         projeto.isencao,
         projeto.tipoPessoaConstrutor,
         projeto.construtor,
         projeto.nomeConstrutor,
         projeto.cnpjCpf,
         projeto.SIGLA,
         projeto.descrLogradouro,
         projeto.numero,
         projeto.complemento,
         projeto.bairroDescr,
         projeto.cep,
         projeto.cidade,
         projeto.unidadefederacao,
         projeto.telefoneresidencial