with pes as
(select p.Pessoa, p.Nome, p.NomeFantasia, p.TipoPessoa, p.CNPJ_CPF, p.RG,
       p.OrgaoEmissor, p.EstadoEmissor,p.DataEmissao, p.InscricaoEstadual,
       p.DataAlteracao, p.DataInclusao, p.Observacao, p.UsuarioInclusao,
       p.inativo, p.SequenciaEndereco, p.SequenciaContato
from pessoa p
%s
)select pes.Pessoa, pes.Nome, pes.NomeFantasia, pes.TipoPessoa, pes.CNPJ_CPF, pes.RG,
       pes.OrgaoEmissor, pes.EstadoEmissor,pes.DataEmissao, pes.InscricaoEstadual,
       pes.DataAlteracao, pes.DataInclusao, pes.Observacao, pes.UsuarioInclusao,
       pes.inativo, pes.SequenciaEndereco, pes.SequenciaContato,
       ARRAY_AGG(ep) as enderecopessoa,
       ARRAY_AGG(cp) as contatopessoa
from pes
  left join (selecT ep.Pessoa, ep.Sequencia,
                     Case When ep.TipoEndereco = '1' then 'Residencial'
                          When ep.TipoEndereco = '2' then 'Comercial'
                          When ep.TipoEndereco = '3' then 'Correspondência'
                     Else 'Nenhum' end as TipoEndereco,
                     ep.Logradouro, l.descricao  as Logradouro_Descr,
                     b.Bairro, b.Descricao as Bairro_Descr, c.Cidade, c.Descricao as Cidade_Descr,
                     ep.Numero, ep.Complemento, ep.CEP, ep.Unidadefederacao,
                     l.TipoLogradouro, tl.Sigla TipoLogradouro_Descr,
                     Case When (p.sequenciaendereco = ep.Sequencia) then 'S' else 'N' end as Principal,
                     c.CodigoIBGE
              from enderecopessoa ep
                left outer join pessoa p on p.pessoa = ep.pessoa
                left outer join Logradouro l on ep.cidade = l.cidade
                   and ep.logradouro = l.logradouro
                left outer join bairro b on b.cidade = ep.cidade
                   and b.bairro = ep.bairro
                left outer join cidade c on c.cidade = ep.cidade
                left outer join TipoLogradouro tl on tl.tipologradouro = l.tipologradouro
              order by ep.pessoa, ep.sequencia) ep
    on pes.pessoa = ep.pessoa
  left outer join (selecT cp.Pessoa, cp.Sequencia, cp.Nome, cp.telefoneResidencial, cp.TelefoneComercial,
                     cp.TelefoneFax, cp.TelefoneCelular, cp.Email, cp.HomePage, cp.RepresentanteLegal,
                     Case When p.SequenciaContato = cp.Sequencia then 'S' else 'N' end as Principal
              from ContatoPessoa cp
                left outer join Pessoa p on p.Pessoa = cp.Pessoa
              order by cp.pessoa, cp.Sequencia) cp
  on pes.pessoa = cp.pessoa
group by pes.Pessoa, pes.Nome, pes.NomeFantasia, pes.TipoPessoa, pes.CNPJ_CPF, pes.RG,
       pes.OrgaoEmissor, pes.EstadoEmissor,pes.DataEmissao, pes.InscricaoEstadual,
       pes.DataAlteracao, pes.DataInclusao, pes.Observacao, pes.UsuarioInclusao,
       pes.inativo, pes.SequenciaEndereco, pes.SequenciaContato
order by pes.pessoa

