with mobiliario as
(SELECT TCM.DATAALVARA,
       TCM.SUPERSIMPLES,
       CASE
         WHEN TCM.SUBSTITUICAOTRIBUTARIA = 'N' OR
              TCM.SUBSTITUICAOTRIBUTARIA IS NULL THEN
          'N'
         ELSE
          'S'
       END AS SUBSTITUICAOTRIBUTARIA,
        CASE
          WHEN TCM.DISPENSANOTAFISCAL = 'S'  THEN
           'S'
        ELSE
           'N'
      END AS DISPENSANOTAFISCAL,
       CASE
         WHEN TCG.EXCLUSAOLOGICA = 'S' THEN
          'E'
         ELSE
          'I'
       END AS TIPOOPERACAO,
       TCM.IDNOTIFICACAOFISCALIZACAO,
       TCM.TipoCadastro,
       TCM.CadastroGeral,
       TCM.PESSOAMOBILIARIO,
       P.cnpj_Cpf cnpjCpf,
       P.NOME,
       CASE
         WHEN TS.BASECALCULO = 'E' THEN
          'S'
         ELSE
          'N'
       END AS ESTIMADO,
       (SELECT CASE WHEN COUNT(*) > 0 THEN 'S' ELSE 'N' END FROM TRIBMOBILIARIOATIVIDADE AT WHERE
                              AT.TIPOCADASTRO = TCM.TIPOCADASTRO
                              AND AT.CADASTROGERAL = TCM.CADASTROGERAL
                              AND AT.ATIVIDADEPRINCIPAL = 'S'
                              AND AT.ATIVIDADE = 9999) AS MUNICIPIO,
       TVBM2.DESCRICAORESPOSTA AS ARBIT,
       TVBM3.DESCRICAORESPOSTA AS ARBIT2,
       TVBM4.DESCRICAORESPOSTA AS ARBIT3,
       TLOG.SIGLA AS TIPOLOGRADOURO,
       L.DESCRICAO AS LOGRADOURO,
       TCG.NUMERO,
       TCG.COMPLEMENTO AS COMPLEMENTOCADGERAL,
       BAI.DESCRICAO AS BAIRRO,
       C.DESCRICAO AS CIDADE,
       C.UNIDADEFEDERACAO AS UF,
       TCG.CEP,
       P.PESSOA AS CODIGOCGCM,
       TCI.CADASTROGERAL AS INSCRICAOCADASTRAL,
       TCI.SETOR_DESCR AS ZONAINSC,
       TCI.QUADRA_DESCR AS QUADRAINSC,
       TCI.LOTE_DESCR AS DATAINSC,
       TVBM.MODELORESPOSTA AS TAXALOCALIZACAO,
       TCM.AREAUTILIZADA,
       TVBMBOMB.DESCRICAORESPOSTA AS CODIGOBOMBEIRO,
       TCM.AREABOMBEIRO,
       TVBMAPTOS.DESCRICAORESPOSTA AS QTDAPTOS,
      (CAST(COALESCE(TVBMQLFICA_SUP.DESCRICAORESPOSTA, '0') AS NUMERIC) + CAST(COALESCE(TVBMQLFICA_TEC.DESCRICAORESPOSTA, '0') AS NUMERIC)) AS NUMEMPREGADOS,
       TVBMQLFICA_SUP.DESCRICAORESPOSTA AS QUALISUPER,
       TVBMQLFICA_TEC.DESCRICAORESPOSTA AS QUALITEC,
       TVBMCOM_AMB.MODELORESPOSTA AS COMAMB,
       TVBMQTD_COM_AMB.DESCRICAORESPOSTA AS QTDCOMAMB,
       TVBMOCUP_SOLO.MODELORESPOSTA AS OCUPSOLO,
       TVBMQTD_OCUP_SOLO.DESCRICAORESPOSTA AS QTDOCUPSOLO,
       TVBMNUM_SOCIOS.DESCRICAORESPOSTA AS NUMSOCIOS,
       TMSSIT.SITUACAOMOBILIARIO AS SITUACAOESTABELECIMENTO,
       TCM.NUMEROALVARA,
       TCM.DATAVALIDADEALVARA,
       TCM.DATAABERTURA,
       TCM.DATAENCERRAMENTO,
       PTC.PROCESSO AS PROTOCOLOABERTURA,
       trunc(PTC.DATAPROCESSO) AS DATAPROTOCOLOABERTURA,
       TCM.DATAAUDITORIAINICIO,
       TCM.DATAAUDITORIAFIM,
       TCM.DATAHOMOLOGACAO,
       TNF.FISCAL AS CODIGOFISCAL,
       TF.NOME as NOMEFISCAL,
       TNF.NOTIFICACAO,
       TNF.EXERCICIO AS ANONOTIFICACAO,
       (SELECT MIN(TAIF.IDAUTOINFRACAOFISCAL)
          FROM TRIBAUTOINFRACAOFISCAL TAIF
         WHERE TAIF.IDNOTIFICACAOFISCALIZACAO =
               TNF.IDNOTIFICACAOFISCALIZACAO) AS IDAUTOINFRACAOFISCAL,
       CASE
         WHEN TCM.DISPENSANOTAFISCAL = 'S' THEN
          'N'
         ELSE
          'S'
       END AS EMITENOTAFISCAL,
       TCM.CMCRESPONSAVEL,
       CP.EMAIL,
       TCM.TELEFONE,
       TCG.DATAALTERACAO,
       coalesce((Select Min(a.Atividade) as Atividade
             from TribMobiliarioAtividade a
            Where a.TipoCadastro = TCM.Tipocadastro
              and a.cadastrogeral = tcm.CadastroGeral
              and a.atividadeprincipal = 'S'),
           0) as Atividade1,
       coalesce((Select Min(a.Atividade) as Atividade
             from TribMobiliarioAtividade a
            Where a.TipoCadastro = TCM.Tipocadastro
              and a.cadastrogeral = tcm.CadastroGeral
              and a.atividadeprincipal <> 'S'
              and a.Atividade in (Select b.Atividade
                                    from TribMobiliarioAtividade b
                                   Where b.TipoCadastro = TCM.Tipocadastro
                                     and b.cadastrogeral = tcm.CadastroGeral
                                     and b.atividadeprincipal <> 'S'
                                   limit 1)),
           0) as Atividade2,
       coalesce((Select Min(a.Atividade) as Atividade
             from TribMobiliarioAtividade a
            Where a.TipoCadastro = TCM.Tipocadastro
              and a.cadastrogeral = tcm.CadastroGeral
              and a.atividadeprincipal <> 'S'
              and a.Atividade not in
                  (Select b.Atividade
                     from TribMobiliarioAtividade b
                    Where b.TipoCadastro = TCM.Tipocadastro
                      and b.cadastrogeral = tcm.CadastroGeral
                      and b.atividadeprincipal <> 'S'
                      limit 1)
              limit 1),
           0) as Atividade3,
       coalesce((Select Min(a.Atividade) as Atividade
             from TribMobiliarioAtividade a
            Where a.TipoCadastro = TCM.Tipocadastro
              and a.cadastrogeral = tcm.CadastroGeral
              and a.atividadeprincipal <> 'S'
              and a.Atividade not in
                  (Select b.Atividade
                     from TribMobiliarioAtividade b
                    Where b.TipoCadastro = TCM.Tipocadastro
                      and b.cadastrogeral = tcm.CadastroGeral
                      and b.atividadeprincipal <> 'S'
                      limit 2)),
           0) as Atividade4,
       coalesce((Select Min(a.Servico) as Servico
             from TribMobiliarioServico a
            Where a.tipocadastro = tcm.tipocadastro
              and a.cadastrogeral = tcm.CadastroGeral
              and a.entidade = :entidade
              and a.exercicio = :exercicio
              and a.Principal = 'S'),
           0) as CodigoISS1,
       coalesce((Select a.Servico as Servico
             from TribMobiliarioServico a
            Where a.tipocadastro = tcm.tipocadastro
              and a.cadastrogeral = tcm.CadastroGeral
              and a.entidade = :entidade
              and a.exercicio = :exercicio
              and a.Principal <> 'S'
              and a.Servico in (Select b.Servico
                                  from TribMobiliarioServico b
                                 Where b.tipocadastro = tcm.tipocadastro
                                   and b.cadastrogeral = tcm.CadastroGeral
                                   and b.entidade = a.entidade
                                   and b.exercicio = a.exercicio
                                   and b.Principal <> 'S'
                                   limit 1)
              limit 1),
           0) as CodigoISS2,
       coalesce((Select Max(a.Servico) as Servico
             from TribMobiliarioServico a
            Where a.tipocadastro = tcm.tipocadastro
              and a.cadastrogeral = tcm.CadastroGeral
              and a.entidade = :entidade
              and a.exercicio = :exercicio
              and a.Principal <> 'S'
              and a.Servico not in
                  (Select b.Servico
                     from TribMobiliarioServico b
                    Where b.tipocadastro = tcm.tipocadastro
                      and b.cadastrogeral = tcm.CadastroGeral
                      and b.entidade = a.entidade
                      and b.exercicio = a.exercicio
                      and b.Principal <> 'S'
                      limit 1)),
           0) as CodigoISS3,
         TCG.EXCLUSAOLOGICA,
         replace(replace(TCM.ATIVIDADEPRINCIPAL, chr(13), ''),chr(10), '') as ATIVIDADEPRINCIPAL,
         replace(replace(TCM.OBSERVACAOALVARA, chr(13), ''),chr(10), '') as OBSERVACAOALVARA
  FROM TRIBCADASTROMOBILIARIO TCM
  LEFT OUTER JOIN TRIBCADASTROGERAL TCG ON TCG.TIPOCADASTRO =
                                           TCM.TIPOCADASTRO
                                       AND TCG.CADASTROGERAL =
                                           TCM.CADASTROGERAL
  LEFT OUTER JOIN PESSOA P ON P.PESSOA = TCG.PESSOA
  LEFT OUTER JOIN LOGRADOURO L ON L.CIDADE = TCG.CIDADE
                              AND L.LOGRADOURO = TCG.LOGRADOURO
  LEFT OUTER JOIN TIPOLOGRADOURO TLOG ON TLOG.TIPOLOGRADOURO =
                                         L.TIPOLOGRADOURO
  LEFT OUTER JOIN CIDADE C ON C.CIDADE = TCG.CIDADE
  LEFT OUTER JOIN CONTATOPESSOA CP ON CP.PESSOA = P.PESSOA
                                  AND CP.SEQUENCIA = P.SEQUENCIACONTATO
  LEFT OUTER JOIN TRIBMOBILIARIOSERVICO TMS ON TMS.TIPOCADASTRO =
                                               TCM.TIPOCADASTRO
                                           AND TMS.CADASTROGERAL =
                                               TCM.CADASTROGERAL
                                           AND TMS.PRINCIPAL = 'S'
                                           AND TMS.entidade = :entidade
                                           AND TMS.exercicio = :exercicio
  LEFT OUTER JOIN TRIBSERVICO TS ON TS.ENTIDADE = TMS.ENTIDADE
                                AND TS.EXERCICIO = TMS.EXERCICIO
                                AND TS.SERVICO = TMS.SERVICO
  LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO TCI ON TCI.TIPOCADASTRO =
                                                 TCM.TIPOCADASTROIMOBILIARIO
                                             AND TCI.CADASTROGERAL =
                                                 TCM.CADASTROGERALIMOBILIARIO
  LEFT OUTER JOIN TRIBNOTIFICACAOFISCALIZACAO TNF ON TCM.IDNOTIFICACAOFISCALIZACAO =
                                                     TNF.IDNOTIFICACAOFISCALIZACAO
  LEFT OUTER JOIN TRIBFISCAL TF ON TF.TIPOFISCAL = TNF.TIPOFISCAL
                               AND TF.FISCAL = TNF.FISCAL
  LEFT OUTER JOIN TRIBLOTEAMENTO TLOTE ON TLOTE.DISTRITO =
                                          TCI.DISTRITO_INSCRICAOCADASTRAL
                                      AND TLOTE.SETOR =
                                          TCI.SETOR_INSCRICAOCADASTRAL
                                      AND TLOTE.LOTEAMENTO = TCI.LOTEAMENTO
  LEFT OUTER JOIN BAIRRO BAI
                          ON BAI.CIDADE = TCG.CIDADE
                        AND BAI.BAIRRO = TCG.BAIRRO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMI ON TMI.IDENTIFICACAO =
                                                 'TAXALOCALIZACAO'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBM ON TVBM.TIPOCADASTRO =
                                                TCM.TIPOCADASTRO
                                            AND TVBM.CADASTROGERAL =
                                                TCM.CADASTROGERAL
                                            AND TVBM.MODELO = TMI.MODELO
                                            AND TVBM.MODELOGRUPO =
                                                TMI.MODELOGRUPO
                                            AND TVBM.MODELOCAMPO =
                                                TMI.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMI2 ON TMI2.IDENTIFICACAO =
                                                  'ISSARBITRADO'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBM2 ON TVBM2.TIPOCADASTRO =
                                                 TCM.TIPOCADASTRO
                                             AND TVBM2.CADASTROGERAL =
                                                 TCM.CADASTROGERAL
                                             AND TVBM2.MODELO = TMI2.MODELO
                                             AND TVBM2.MODELOGRUPO =
                                                 TMI2.MODELOGRUPO
                                             AND TVBM2.MODELOCAMPO =
                                                 TMI2.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMI3 ON TMI3.IDENTIFICACAO =
                                                  'ISSARBITRADO2'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBM3 ON TVBM3.TIPOCADASTRO =
                                                 TCM.TIPOCADASTRO
                                             AND TVBM3.CADASTROGERAL =
                                                 TCM.CADASTROGERAL
                                             AND TVBM3.MODELO = TMI3.MODELO
                                             AND TVBM3.MODELOGRUPO =
                                                 TMI3.MODELOGRUPO
                                             AND TVBM3.MODELOCAMPO =
                                                 TMI3.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMI4 ON TMI4.IDENTIFICACAO =
                                                  'ISSARBITRADO3'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBM4 ON TVBM4.TIPOCADASTRO =
                                                 TCM.TIPOCADASTRO
                                             AND TVBM4.CADASTROGERAL =
                                                 TCM.CADASTROGERAL
                                             AND TVBM4.MODELO = TMI4.MODELO
                                             AND TVBM4.MODELOGRUPO =
                                                 TMI4.MODELOGRUPO
                                             AND TVBM4.MODELOCAMPO =
                                                 TMI4.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMIBOMB ON TMIBOMB.IDENTIFICACAO =
                                                     'CODIGOBOMBEIRO'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMBOMB ON TVBMBOMB.TIPOCADASTRO =
                                                    TCM.TIPOCADASTRO
                                                AND TVBMBOMB.CADASTROGERAL =
                                                    TCM.CADASTROGERAL
                                                AND TVBMBOMB.MODELO =
                                                    TMIBOMB.MODELO
                                                AND TVBMBOMB.MODELOGRUPO =
                                                    TMIBOMB.MODELOGRUPO
                                                AND TVBMBOMB.MODELOCAMPO =
                                                    TMIBOMB.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMIAPTOS ON TMIAPTOS.IDENTIFICACAO =
                                                      'QTDAPTOS'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMAPTOS ON TVBMAPTOS.TIPOCADASTRO =
                                                     TCM.TIPOCADASTRO
                                                 AND TVBMAPTOS.CADASTROGERAL =
                                                     TCM.CADASTROGERAL
                                                 AND TVBMAPTOS.MODELO =
                                                     TMIAPTOS.MODELO
                                                 AND TVBMAPTOS.MODELOGRUPO =
                                                     TMIAPTOS.MODELOGRUPO
                                                 AND TVBMAPTOS.MODELOCAMPO =
                                                     TMIAPTOS.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMIQLFICA_SUP ON TMIQLFICA_SUP.IDENTIFICACAO =
                                                           'QLFICA_SUP'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMQLFICA_SUP ON TVBMQLFICA_SUP.TIPOCADASTRO =
                                                          TCM.TIPOCADASTRO
                                                      AND TVBMQLFICA_SUP.CADASTROGERAL =
                                                          TCM.CADASTROGERAL
                                                      AND TVBMQLFICA_SUP.MODELO =
                                                          TMIQLFICA_SUP.MODELO
                                                      AND TVBMQLFICA_SUP.MODELOGRUPO =
                                                          TMIQLFICA_SUP.MODELOGRUPO
                                                      AND TVBMQLFICA_SUP.MODELOCAMPO =
                                                          TMIQLFICA_SUP.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMIQLFICA_TEC ON TMIQLFICA_TEC.IDENTIFICACAO =
                                                           'QLFICA_TEC'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMQLFICA_TEC ON TVBMQLFICA_TEC.TIPOCADASTRO =
                                                          TCM.TIPOCADASTRO
                                                      AND TVBMQLFICA_TEC.CADASTROGERAL =
                                                          TCM.CADASTROGERAL
                                                      AND TVBMQLFICA_TEC.MODELO =
                                                          TMIQLFICA_TEC.MODELO
                                                      AND TVBMQLFICA_TEC.MODELOGRUPO =
                                                          TMIQLFICA_TEC.MODELOGRUPO
                                                      AND TVBMQLFICA_TEC.MODELOCAMPO =
                                                          TMIQLFICA_TEC.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMICOM_AMB ON TMICOM_AMB.IDENTIFICACAO =
                                                        'COM_AMB'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMCOM_AMB ON TVBMCOM_AMB.TIPOCADASTRO =
                                                       TCM.TIPOCADASTRO
                                                   AND TVBMCOM_AMB.CADASTROGERAL =
                                                       TCM.CADASTROGERAL
                                                   AND TVBMCOM_AMB.MODELO =
                                                       TMICOM_AMB.MODELO
                                                   AND TVBMCOM_AMB.MODELOGRUPO =
                                                       TMICOM_AMB.MODELOGRUPO
                                                   AND TVBMCOM_AMB.MODELOCAMPO =
                                                       TMICOM_AMB.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMIQTD_COM_AMB ON TMIQTD_COM_AMB.IDENTIFICACAO =
                                                            'QTD_COM_AMB'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMQTD_COM_AMB ON TVBMQTD_COM_AMB.TIPOCADASTRO =
                                                           TCM.TIPOCADASTRO
                                                       AND TVBMQTD_COM_AMB.CADASTROGERAL =
                                                           TCM.CADASTROGERAL
                                                       AND TVBMQTD_COM_AMB.MODELO =
                                                           TMIQTD_COM_AMB.MODELO
                                                       AND TVBMQTD_COM_AMB.MODELOGRUPO =
                                                           TMIQTD_COM_AMB.MODELOGRUPO
                                                       AND TVBMQTD_COM_AMB.MODELOCAMPO =
                                                           TMIQTD_COM_AMB.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMIOCUP_SOLO ON TMIOCUP_SOLO.IDENTIFICACAO =
                                                          'OCUP_SOLO'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMOCUP_SOLO ON TVBMOCUP_SOLO.TIPOCADASTRO =
                                                         TCM.TIPOCADASTRO
                                                     AND TVBMOCUP_SOLO.CADASTROGERAL =
                                                         TCM.CADASTROGERAL
                                                     AND TVBMOCUP_SOLO.MODELO =
                                                         TMIOCUP_SOLO.MODELO
                                                     AND TVBMOCUP_SOLO.MODELOGRUPO =
                                                         TMIOCUP_SOLO.MODELOGRUPO
                                                     AND TVBMOCUP_SOLO.MODELOCAMPO =
                                                         TMIOCUP_SOLO.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMIQTD_OCUP_SOLO ON TMIQTD_OCUP_SOLO.IDENTIFICACAO =
                                                              'QTD_OCUP_SOLO'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMQTD_OCUP_SOLO ON TVBMQTD_OCUP_SOLO.TIPOCADASTRO =
                                                             TCM.TIPOCADASTRO
                                                         AND TVBMQTD_OCUP_SOLO.CADASTROGERAL =
                                                             TCM.CADASTROGERAL
                                                         AND TVBMQTD_OCUP_SOLO.MODELO =
                                                             TMIQTD_OCUP_SOLO.MODELO
                                                         AND TVBMQTD_OCUP_SOLO.MODELOGRUPO =
                                                             TMIQTD_OCUP_SOLO.MODELOGRUPO
                                                         AND TVBMQTD_OCUP_SOLO.MODELOCAMPO =
                                                             TMIQTD_OCUP_SOLO.MODELOCAMPO
  LEFT OUTER JOIN TRIBMODELOIDENTIFICACAO TMINUM_SOCIOS ON TMINUM_SOCIOS.IDENTIFICACAO =
                                                           'NUM_SOCIOS'
  LEFT OUTER JOIN TRIBBOLETIMMOBILIARIO TVBMNUM_SOCIOS ON TVBMNUM_SOCIOS.TIPOCADASTRO =
                                                          TCM.TIPOCADASTRO
                                                      AND TVBMNUM_SOCIOS.CADASTROGERAL =
                                                          TCM.CADASTROGERAL
                                                      AND TVBMNUM_SOCIOS.MODELO =
                                                          TMINUM_SOCIOS.MODELO
                                                      AND TVBMNUM_SOCIOS.MODELOGRUPO =
                                                          TMINUM_SOCIOS.MODELOGRUPO
                                                      AND TVBMNUM_SOCIOS.MODELOCAMPO =
                                                          TMINUM_SOCIOS.MODELOCAMPO
  LEFT OUTER JOIN TRIBMOBILIARIOSITUACAO TMSSIT ON TMSSIT.TIPOCADASTRO =
                                                   tcm.tipocadastro
                                               AND TMSSIT.CADASTROGERAL =
                                                   TCM.CADASTROGERAL
                                               AND TMSSIT.ATUAL = 'S'
  LEFT OUTER JOIN PTCPROCESSO PTC ON PTC.ENTIDADE = TCM.ENTIDADE
                                 AND PTC.EXERCICIO =
                                     TCM.EXERCPROCESSOABERTURA
                                 AND PTC.IDPROCESSO =
                                     TCM.IDPROCESSOABERTURA
  WHERE TCG.TIPOCADASTRO = 2
%s
)
select mobiliario.DATAALVARA,
mobiliario.SUPERSIMPLES,
mobiliario.SUBSTITUICAOTRIBUTARIA,
mobiliario.DISPENSANOTAFISCAL,
mobiliario.TIPOOPERACAO,
mobiliario.IDNOTIFICACAOFISCALIZACAO,
mobiliario.TipoCadastro,
mobiliario.CadastroGeral,
mobiliario.PESSOAMOBILIARIO,
mobiliario.cnpjCpf,
mobiliario.NOME,
mobiliario.ESTIMADO,
mobiliario.MUNICIPIO,
mobiliario.ARBIT,
mobiliario.ARBIT2,
mobiliario.ARBIT3,
mobiliario.TIPOLOGRADOURO,
mobiliario.LOGRADOURO,
mobiliario.NUMERO,
mobiliario.COMPLEMENTOCADGERAL,
mobiliario.BAIRRO,
mobiliario.CIDADE,
mobiliario.UF,
mobiliario.CEP,
mobiliario.CODIGOCGCM,
mobiliario.INSCRICAOCADASTRAL,
mobiliario.ZONAINSC,
mobiliario.QUADRAINSC,
mobiliario.DATAINSC,
mobiliario.TAXALOCALIZACAO,
mobiliario.AREAUTILIZADA,
mobiliario.CODIGOBOMBEIRO,
mobiliario.AREABOMBEIRO,
mobiliario.QTDAPTOS,
mobiliario.NUMEMPREGADOS,
mobiliario.QUALISUPER,
mobiliario.QUALITEC,
mobiliario.COMAMB,
mobiliario.QTDCOMAMB,
mobiliario.OCUPSOLO,
mobiliario.QTDOCUPSOLO,
mobiliario.NUMSOCIOS,
mobiliario.SITUACAOESTABELECIMENTO,
mobiliario.NUMEROALVARA,
mobiliario.DATAVALIDADEALVARA,
mobiliario.DATAABERTURA,
mobiliario.DATAENCERRAMENTO,
mobiliario.PROTOCOLOABERTURA,
mobiliario.DATAPROTOCOLOABERTURA,
mobiliario.DATAAUDITORIAINICIO,
mobiliario.DATAAUDITORIAFIM,
mobiliario.DATAHOMOLOGACAO,
mobiliario.CODIGOFISCAL,
mobiliario.NOMEFISCAL,
mobiliario.NOTIFICACAO,
mobiliario.ANONOTIFICACAO,
mobiliario.IDAUTOINFRACAOFISCAL,
mobiliario.EMITENOTAFISCAL,
mobiliario.CMCRESPONSAVEL,
mobiliario.EMAIL,
mobiliario.TELEFONE,
mobiliario.DATAALTERACAO,
mobiliario.Atividade1,
mobiliario.Atividade2,
mobiliario.Atividade3,
mobiliario.Atividade4,
mobiliario.CodigoISS1,
mobiliario.CodigoISS2,
mobiliario.CodigoISS3,
mobiliario.EXCLUSAOLOGICA,
mobiliario.ATIVIDADEPRINCIPAL,
mobiliario.OBSERVACAOALVARA,
ARRAY_AGG(atividades.*) as atividades,
ARRAY_AGG(cnaes.*) as cnaes
from mobiliario
  left join (
  select tcg.tipocadastro,
       tcg.cadastrogeral,
       tma.atividade,
       ativ.descricao as desc_atividade,
       tma.atividadeprincipal
from tribmobiliarioatividade tma
left outer join tribcadastrogeral tcg
    on tcg.tipocadastro = tma.tipocadastro
  and tcg.cadastrogeral = tma.cadastrogeral
left outer join tribatividade ativ
    on ativ.atividade = tma.atividade
where tcg.tipocadastro = 2
) atividades
   on atividades.tipocadastro = mobiliario.tipocadastro
   and atividades.cadastrogeral = mobiliario.cadastrogeral
left join (
select tcg.tipocadastro,
       tcg.cadastrogeral,
       cnae.codigo,
       cnae.descricao as desc_cnae,
       tmc.cnaeprincipal,
       cnae.inativo
from tribmobiliariocnae tmc
left outer join tribcadastrogeral tcg
    on tcg.tipocadastro = tmc.tipocadastro
  and tcg.cadastrogeral = tmc.cadastrogeral
left outer join cnae cnae
   on cnae.cnae = tmc.cnae
where tcg.tipocadastro = 2
) cnaes
   on cnaes.tipocadastro = mobiliario.tipocadastro
   and cnaes.cadastrogeral = mobiliario.cadastrogeral
group by  mobiliario.DATAALVARA,
mobiliario.SUPERSIMPLES,
mobiliario.SUBSTITUICAOTRIBUTARIA,
mobiliario.DISPENSANOTAFISCAL,
mobiliario.TIPOOPERACAO,
mobiliario.IDNOTIFICACAOFISCALIZACAO,
mobiliario.TipoCadastro,
mobiliario.CadastroGeral,
mobiliario.PESSOAMOBILIARIO,
mobiliario.cnpjCpf,
mobiliario.NOME,
mobiliario.ESTIMADO,
mobiliario.MUNICIPIO,
mobiliario.ARBIT,
mobiliario.ARBIT2,
mobiliario.ARBIT3,
mobiliario.TIPOLOGRADOURO,
mobiliario.LOGRADOURO,
mobiliario.NUMERO,
mobiliario.COMPLEMENTOCADGERAL,
mobiliario.BAIRRO,
mobiliario.CIDADE,
mobiliario.UF,
mobiliario.CEP,
mobiliario.CODIGOCGCM,
mobiliario.INSCRICAOCADASTRAL,
mobiliario.ZONAINSC,
mobiliario.QUADRAINSC,
mobiliario.DATAINSC,
mobiliario.TAXALOCALIZACAO,
mobiliario.AREAUTILIZADA,
mobiliario.CODIGOBOMBEIRO,
mobiliario.AREABOMBEIRO,
mobiliario.QTDAPTOS,
mobiliario.NUMEMPREGADOS,
mobiliario.QUALISUPER,
mobiliario.QUALITEC,
mobiliario.COMAMB,
mobiliario.QTDCOMAMB,
mobiliario.OCUPSOLO,
mobiliario.QTDOCUPSOLO,
mobiliario.NUMSOCIOS,
mobiliario.SITUACAOESTABELECIMENTO,
mobiliario.NUMEROALVARA,
mobiliario.DATAVALIDADEALVARA,
mobiliario.DATAABERTURA,
mobiliario.DATAENCERRAMENTO,
mobiliario.PROTOCOLOABERTURA,
mobiliario.DATAPROTOCOLOABERTURA,
mobiliario.DATAAUDITORIAINICIO,
mobiliario.DATAAUDITORIAFIM,
mobiliario.DATAHOMOLOGACAO,
mobiliario.CODIGOFISCAL,
mobiliario.NOMEFISCAL,
mobiliario.NOTIFICACAO,
mobiliario.ANONOTIFICACAO,
mobiliario.IDAUTOINFRACAOFISCAL,
mobiliario.EMITENOTAFISCAL,
mobiliario.CMCRESPONSAVEL,
mobiliario.EMAIL,
mobiliario.TELEFONE,
mobiliario.DATAALTERACAO,
mobiliario.Atividade1,
mobiliario.Atividade2,
mobiliario.Atividade3,
mobiliario.Atividade4,
mobiliario.CodigoISS1,
mobiliario.CodigoISS2,
mobiliario.CodigoISS3,
mobiliario.EXCLUSAOLOGICA,
mobiliario.ATIVIDADEPRINCIPAL,
mobiliario.OBSERVACAOALVARA
