with cadastroavulso as 
(select tcg.TipoCadastro,
       ttc.Descricao TipoCadastro_Descr,
       tcg.Pessoa,
       tcg.CadastroGeral,
       pes.Nome Proprietario_Descr,
       pes.CNPJ_CPF,
       tcg.Logradouro,
       tl.sigla,
       lgr.Descricao Logradouro_Descr,
       tcg.Numero,
       tcg.Complemento,
       tcg.Bairro,
       bai.Descricao Bairro_Descr,
       tcg.Cidade,
       cid.Descricao Cidade_Descr,
       cid.UnidadeFederacao,
       cid.Descricao UF_Descr,
       tcg.ExclusaoLogica,
       tcg.Usuario,
       TCG.DATAINCLUSAO,
       TCG.DATAALTERACAO,
       cpes.email,
       cpes.telefoneresidencial,
       endp.cep,
       pes.tipopessoa
  from tribCadastroGeral tcg
left outer join Pessoa pes
        on tcg.Pessoa = pes.Pessoa
left outer join contatopessoa cpes
        on cpes.pessoa = pes.pessoa
        and cpes.sequencia = 1
left outer join enderecopessoa endp on
       endp.pessoa = pes.pessoa
       and pes.sequenciaendereco = endp.sequencia
      and endp.sequencia = 1
left outer join Logradouro lgr
        on tcg.Cidade = lgr.Cidade
       and tcg.Logradouro = lgr.Logradouro
left outer join tipologradouro tl
        on lgr.tipologradouro = tl.tipologradouro
left outer join Cidade cid
        on tcg.Cidade = cid.Cidade
left outer join Bairro bai
        on tcg.Cidade = bai.Cidade
       and tcg.Bairro = bai.Bairro
left outer join UnidadeFederacao uf
        on cid.UnidadeFederacao = uf.UnidadeFederacao
left outer join tribTipoCadastro ttc
        on tcg.TipoCadastro = ttc.TipoCadastro
where tcg.TipoCadastro = 9
%s
)
select * from cadastroavulso
order by cadastroavulso.tipocadastro, cadastroavulso.cadastrogeral