SELECT
    consultadebito.dataCriacao,
    consultadebito.id as idConsultaDebito,
    1 AS idTipoControleDado,
    3 AS tpDocContribuinte,
    pessoa.cnpj_cpf AS nrDocContribuinte,
    classificacaoreceitatipo.classificacaoreceitatipo AS idTipoCredito,
    CASE
        WHEN debitoparcela.situacaoLegal = 0 THEN 1
        WHEN debitoparcela.situacaoLegal IN (1,2) THEN 2
        ELSE 99
    END AS idTipoOrigemReceita,
    debitoparcela.datalancamento AS dtLancamento,
    CASE
        WHEN debitoparcela.situacaolegal = 2 THEN 'S' ELSE 'N'
    END AS flExecucaoJudicial,
    debito.cadastrogeral AS cdCadastro,
    coalesce(debito.reparcelado, debito.parcelado) AS flParcelado,
    tp.dataparcelamento as dtParcelamento,
    CASE WHEN tp.dataparcelamento IS NOT NULL THEN upg.datavencimento END AS dtVencUltimaParcPaga,
    debitoparcela.processojudicial AS nrProcessoJudicial,
    cg.idtce as cdControleLeiAto,
    extract(month from debitoparcela.datalancamento) AS nrMesBase,
    extract(year from debitoparcela.datalancamento) AS nrAnoBase,
    consultadebito.datareferencia AS dtSaldo,
    SUM(consultadebitoitem.valorliquido) AS vlSaldo
FROM consultadebito
JOIN consultadebitoitem
  ON consultadebito.id = consultadebitoitem.idconsultadebito
JOIN tribdebitoparcelareceita debitoparcelareceita
  ON debitoparcelareceita.iddebitoparcelareceita = consultadebitoitem.iddebitotributo
JOIN tribdebitoparcela debitoparcela
  ON debitoparcela.entidade = debitoparcelareceita.entidade
 AND debitoparcela.exercicio = debitoparcelareceita.exercicio
 AND debitoparcela.tipocadastro = debitoparcelareceita.tipocadastro
 AND debitoparcela.cadastrogeral = debitoparcelareceita.cadastrogeral
 AND debitoparcela.guiarecolhimento =debitoparcelareceita.guiarecolhimento
 AND debitoparcela.subdivida = debitoparcelareceita.subdivida
 AND debitoparcela.parcela = debitoparcelareceita.parcela
JOIN tribdebito debito
  ON debito.entidade = debitoparcela.entidade
 AND debito.exercicio = debitoparcela.exercicio
 AND debito.tipocadastro = debitoparcela.tipocadastro
 AND debito.cadastrogeral = debitoparcela.cadastrogeral
 AND debito.guiarecolhimento = debitoparcela.guiarecolhimento
 AND debito.subdivida = debitoparcela.subdivida
JOIN tribreceita receita
  ON receita.entidade = debitoparcelareceita.entidade
 AND receita.exercicio = debitoparcelareceita.exercicio
 AND receita.receita = debitoparcelareceita.receita
JOIN tribreceitatipo receitatipo
  ON receitatipo.tiporeceita = receita.tiporeceita
JOIN tribclassificacaoreceitatipo classificacaoreceitatipo
  ON classificacaoreceitatipo.classificacaoreceitatipo = receitatipo.classificacaoreceitatipo
JOIN pessoa
  ON pessoa.pessoa = consultadebitoitem.pessoa
LEFT OUTER JOIN tribguiarecolhimento tg
  ON debito.entidade = tg.entidade
 AND debito.exercicio = tg.exercicio
 AND debito.guiarecolhimento = tg.guiarecolhimento
LEFT OUTER JOIN cgato cg
  ON tg.entidade = cg.entidade
 AND tg.fundamentolegal = cg.idato
LEFT OUTER JOIN tribparcelamento tp
  ON tp.idparcelamento = coalesce(debito.idreparcelamento, debito.idparcelamento)
LEFT JOIN (select tdp.entidade, tdp.exercicio, tdp.tipocadastro, tdp.cadastrogeral, tdp.guiarecolhimento, tdp.subdivida,
                  max(tdp.datavencimento) as dataVencimento
           from tribdebitoparcela tdp
           join tribsituacaoparcela tsp
           on tdp.situacaodebito = tsp.situacaoparcela
           where tsp.tiposituacaoparcela = 2 /* Pago */
           group by tdp.entidade, tdp.exercicio, tdp.tipocadastro, tdp.cadastrogeral, tdp.guiarecolhimento, tdp.subdivida
) upg
  ON debito.entidade = upg.entidade
 AND debito.exercicio = upg.exercicio
 AND debito.tipocadastro = upg.tipocadastro
 AND debito.cadastrogeral = upg.cadastrogeral
 AND debito.guiarecolhimento = upg.guiarecolhimento
 AND debito.subdivida = upg.subdivida
WHERE consultadebito.id = (SELECT MAX(cs.id) from consultadebito cs
                           JOIN trib_job_execution execution
                             ON execution.job_execution_id = cs.idjob
                           WHERE cs.tipoagrupamento = 'SALDO_ANALITICO_CONTRIBUINTE_PRIMEIRA_CARGA'
                             AND cs.datareferencia = :datareferencia
                             AND execution.status = 'COMPLETED')
  AND classificacaoreceitatipo.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
GROUP BY
    consultadebito.id,
    pessoa.cnpj_cpf,
    classificacaoreceitatipo.classificacaoreceitatipo,
    debitoparcela.situacaoLegal,
    debitoparcela.datalancamento,
    debito.cadastrogeral,
    debito.parcelado,
    debito.reparcelado,
    tp.dataparcelamento,
    upg.datavencimento,
    debitoparcela.processojudicial,
    cg.idtce,
    debitoparcela.mesreferencia,
    debitoparcela.anoreferencia,
    consultadebito.datareferencia