SELECT DEBITOPARCELARECEITA.RECEITA                    AS tributo,
       SUM(DEVOLUCAOCREDITODEBITO.VALORPRINCIPAL) * -1 AS valorPrincipal,
       SUM(DEVOLUCAOCREDITODEBITO.VALORJUROS) * -1     AS valorJuros,
       SUM(DEVOLUCAOCREDITODEBITO.VALORMULTA) * -1     AS valorMulta,
       SUM(DEVOLUCAOCREDITODEBITO.VALORCORRECAO)* -1   AS valorCorrecao,
       CASE
           WHEN SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOJUROS, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOMULTA, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOCORRECAO, 0)) > 0
           THEN SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOJUROS, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOMULTA, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOCORRECAO, 0)) * -1
           ELSE SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTO, 0)) * -1
           END                                    AS valorDesconto
FROM TRIBDEVOLUCAOCREDITO DEVOLUCAOCREDITO
         LEFT JOIN TRIBDEVOLUCAOCREDITOITEM DEVOLUCAOCREDITOITEM
                   ON DEVOLUCAOCREDITOITEM.IDDEVOLUCAOCREDITO = DEVOLUCAOCREDITO.IDDEVOLUCAOCREDITO AND
                      DEVOLUCAOCREDITOITEM.GERAMOVIMENTACAO = 'S'
         LEFT JOIN TRIBDEVOLUCAOCREDITODEBITO DEVOLUCAOCREDITODEBITO
                   ON DEVOLUCAOCREDITODEBITO.IDDEVOLUCAOCREDITO = DEVOLUCAOCREDITOITEM.IDDEVOLUCAOCREDITO AND
                      DEVOLUCAOCREDITODEBITO.SEQUENCIAITEM = DEVOLUCAOCREDITOITEM.SEQUENCIAITEM
		 LEFT JOIN CONTABANCARIA
		 		   ON CONTABANCARIA.ENTIDADE = DEVOLUCAOCREDITO.ENTIDADE AND
					  CONTABANCARIA.CONTABANCARIA = DEVOLUCAOCREDITO.CONTABANCARIA
         LEFT JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
                   ON DEVOLUCAOCREDITODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT JOIN TRIBRECEITA RECEITA
                   ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                      RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                      RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
WHERE DEVOLUCAOCREDITO.DATA = :dataLancamento
%s
GROUP BY DEBITOPARCELARECEITA.RECEITA