SELECT
	debito.IDDEBITO AS id,
	debitoReceita.IDDEBITORECEITA as idDebitoTributo,
	debitoReceita.ENTIDADE,
	debitoReceita.EXERCICIO,
	debitoReceita.TIPOCADASTRO,
	debitoReceita.CADASTROGERAL,
	debitoReceita.GUIARECOLHIMENTO AS DIVIDA,
	debitoReceita.SUBDIVIDA,
	debitoReceita.RECEITA AS TRIBUTO,
	guiaRecolhimentoReceita.ORDEM,
	debitoReceita.VALORRECEITA AS valorTributo,
	debitoReceita.VALORDESCONTO,
	debitoReceita.VALORBASECALCULO,
	debitoReceita.VALORRENUNCIA,
	receita.Descricao AS descTributo
FROM tribdebito debito
LEFT OUTER JOIN tribDebitoReceita debitoReceita ON
	debito.ENTIDADE = debitoReceita.ENTIDADE
	AND debito.EXERCICIO = debitoReceita.EXERCICIO
	AND debito.TIPOCADASTRO = debitoReceita.TIPOCADASTRO
	AND debito.CADASTROGERAL = debitoReceita.CADASTROGERAL
	AND debito.GUIARECOLHIMENTO = debitoReceita.GUIARECOLHIMENTO
	AND debito.SUBDIVIDA = debitoReceita.SUBDIVIDA
LEFT OUTER JOIN tribReceita receita ON
	debitoReceita.Entidade = receita.Entidade
	AND debitoReceita.Exercicio = receita.Exercicio
	AND debitoReceita.Receita = receita.Receita
LEFT OUTER JOIN tribGuiaRecolhimentoReceita guiaRecolhimentoReceita ON
	guiaRecolhimentoReceita.entidade = debitoReceita.entidade
	AND guiaRecolhimentoReceita.exercicio = debitoReceita.exercicio
	AND guiaRecolhimentoReceita.receita = debitoReceita.receita
	AND guiaRecolhimentoReceita.guiarecolhimento = debitoReceita.guiarecolhimento
WHERE debito.IDDEBITO = :id
ORDER BY guiaRecolhimentoReceita.Ordem,
	debitoReceita.ORDEM,
	debitoReceita.RECEITA