SELECT debito.iddebito AS id,
	debitoParcela.ENTIDADE,
	debitoParcela.EXERCICIO,
	debitoParcela.TIPOCADASTRO,
	debitoParcela.CADASTROGERAL,
	debitoParcela.GUIARECOLHIMENTO AS DIVIDA,
	debitoParcela.SUBDIVIDA,
	debitoParcela.PARCELA,
	debitoParcela.SITUACAOLEGAL,
	case
	    when debito.PARCELADO = 'S' then 1
        else 0
	end parcelado,
    case
        when debito.REPARCELADO = 'S' then 1
        else 0
    end reparcelado,
	debitoParcela.LIVRO,
	debitoParcela.EXERCICIOLIVRO,
	debitoParcela.NUMEROFOLHA,
	debitoParcela.NUMEROINSCRICAO,
	debitoParcela.DATADIVIDAATIVA,
	debitoParcela.DATADISTRIBUICAO,
	debitoParcela.NUMERODISTRIBUICAO,
	debitoParcela.IDCARTORIO,
	cartorio.CARTORIO,
	cartorio.DESCRICAO Cartorio_Descr,
	debitoParcela.SITUACAODEBITO,
	situacaoParcela.DESCRICAO SituacaoDebitoDescricao,
	debitoParcela.DATAVENCIMENTO,
	debitoParcela.DATASITUACAO,
	situacaoParcela.TIPOSITUACAOPARCELA,
	situacaoParcela.SIGLA AS SiglaSituacaoParcela,
	tipoSituacaoParcela.TIPO AS TipoSituacaoParcelaDesc,
	debitoParcela.MESREFERENCIA,
	debitoParcela.ANOREFERENCIA,
	debitoParcela.DataAjuizamento,
	debitoParcela.ProcessoJudicial,
	SUM(debitoParcelaReceita.VALOR) AS VALORPARCELA,
	debitoParcela.IDProtesto,
    debitoParcela.datalancamento AS datalancamento
FROM TRIBDEBITO debito
LEFT OUTER JOIN tribDebitoParcela debitoParcela ON
	debito.ENTIDADE = debitoParcela.ENTIDADE
	AND debito.EXERCICIO = debitoParcela.EXERCICIO
	AND debito.TIPOCADASTRO = debitoParcela.TIPOCADASTRO
	AND debito.CADASTROGERAL = debitoParcela.CADASTROGERAL
	AND debito.GUIARECOLHIMENTO = debitoParcela.GUIARECOLHIMENTO
	AND debito.SUBDIVIDA = debitoParcela.SUBDIVIDA
LEFT OUTER JOIN tribDebitoParcelaReceita debitoParcelaReceita ON
	debitoParcela.ENTIDADE = debitoParcelaReceita.ENTIDADE
	AND debitoParcela.EXERCICIO = debitoParcelaReceita.EXERCICIO
	AND debitoParcela.TIPOCADASTRO = debitoParcelaReceita.TIPOCADASTRO
	AND debitoParcela.CADASTROGERAL = debitoParcelaReceita.CADASTROGERAL
	AND debitoParcela.GUIARECOLHIMENTO = debitoParcelaReceita.GUIARECOLHIMENTO
	AND debitoParcela.SUBDIVIDA = debitoParcelaReceita.SUBDIVIDA
	AND debitoParcela.PARCELA = debitoParcelaReceita.PARCELA
LEFT OUTER JOIN tribSituacaoParcela situacaoParcela ON
	debitoParcela.SITUACAODEBITO = situacaoParcela.SITUACAOPARCELA
LEFT OUTER JOIN tribTipoSituacaoParcela tipoSituacaoParcela ON
	tipoSituacaoParcela.TIPOSITUACAOPARCELA = situacaoParcela.TIPOSITUACAOPARCELA
LEFT OUTER JOIN Cartorio cartorio ON
	debitoParcela.IDCARTORIO = cartorio.IDCARTORIO
LEFT OUTER JOIN tribParcelamento parcelamento ON
	debito.IDPARCELAMENTO = parcelamento.IDPARCELAMENTO
LEFT OUTER JOIN usuario ON
	debito.usuario = usuario.usuario
LEFT OUTER JOIN pessoa pessoaUsuario ON
	usuario.pessoa = pessoaUsuario.pessoa
WHERE
	debito.IDDEBITO = :id
GROUP BY debito.iddebito,
	debitoParcela.ENTIDADE,
	debitoParcela.EXERCICIO,
	debitoParcela.TIPOCADASTRO,
	debitoParcela.CADASTROGERAL,
	debitoParcela.GUIARECOLHIMENTO,
	debitoParcela.SUBDIVIDA,
	debitoParcela.PARCELA,
	debitoParcela.SITUACAOLEGAL,
	debito.DATACORRECAO,
	debito.DATACORRECAOIGPM,
	debito.PERCENTUALISS,
	debito.DESCONTOIMPOSTO,
	debito.DESCONTOLEI2004,
	debito.NUMEROPARCELA,
	debito.PARCELADO,
	debito.REPARCELADO,
	parcelamento.NUMEROCONTRATO,
	pessoaUsuario.nome,
	usuario.nome,
	debito.PROGRAMA,
	debitoParcela.LIVRO,
	debitoParcela.EXERCICIOLIVRO,
	debitoParcela.NUMEROFOLHA,
	debitoParcela.NUMEROINSCRICAO,
	debitoParcela.DATADIVIDAATIVA,
	debitoParcela.DATADISTRIBUICAO,
	debitoParcela.NUMERODISTRIBUICAO,
	debitoParcela.IDCARTORIO,
	cartorio.CARTORIO,
	cartorio.DESCRICAO,
	debitoParcela.SITUACAODEBITO,
	situacaoParcela.DESCRICAO,
	debitoParcela.DATAVENCIMENTO,
	debitoParcela.DATASITUACAO,
	situacaoParcela.TIPOSITUACAOPARCELA,
	situacaoParcela.SIGLA,
	tipoSituacaoParcela.TIPO,
	debitoParcela.MESREFERENCIA,
	debitoParcela.ANOREFERENCIA,
	debitoParcela.DataAjuizamento,
	debitoParcela.ProcessoJudicial,
	debitoParcela.IDProtesto,
    debito.datacontabilizacao,
	debito.datainclusao
ORDER BY debitoParcela.entidade,
    debitoParcela.exercicio,
    debitoParcela.guiarecolhimento,
    debitoParcela.subdivida,
    debitoParcela.parcela