Select distinct a.Entidade,
                a.Exercicio,
                a.TipoCadastro,
                a.CadastroGeral,
                a.GuiaRecolhimento,
                a.SubDivida,
                a.idDebito,
                tdp.parcela,
                tdp.ExercicioLivro,
                tdp.Livro,
                tsp.situacaoparcela,
                tsp.descricao,
                tdp.situacaolegal,
                tsp.tiposituacaoparcela,
                tdp.situacaodebito,
                sum(rec.valor + rec.valorjuros + rec.valormulta + rec.valorcorrecao) as valor
from TribDebito a
         left outer join TribDebitoParcelaReceita rec on a.Entidade = rec.Entidade and a.Exercicio = rec.Exercicio and
                                                         a.TipoCadastro = rec.TipoCadastro and
                                                         a.CadastroGeral = rec.CadastroGeral and
                                                         a.GuiaRecolhimento = rec.GuiaRecolhimento and
                                                         a.SubDivida = rec.SubDivida
         left outer join Tribdebitoparcela tdp on a.Entidade = tdp.Entidade and a.Exercicio = tdp.Exercicio and
                                                  a.TipoCadastro = tdp.TipoCadastro and
                                                  a.CadastroGeral = tdp.CadastroGeral and
                                                  a.GuiaRecolhimento = tdp.GuiaRecolhimento and
                                                  a.SubDivida = tdp.SubDivida and rec.parcela = tdp.parcela
         left outer join TribSituacaoParcela tsp on tsp.SituacaoParcela = tdp.SituacaoDebito
Where a.Entidade = 1
  and tdp.situacaolegal in (1, 2)
  and tsp.TipoSituacaoparcela = 1
  $[FILTROS]
group by a.Entidade, a.Exercicio, a.TipoCadastro, a.CadastroGeral, a.GuiaRecolhimento, a.SubDivida, tdp.parcela,
         tdp.ExercicioLivro, tdp.Livro, tsp.situacaoparcela, tsp.descricao, tdp.situacaolegal, tsp.tiposituacaoparcela,
         tdp.situacaodebito
Order by a.exercicio, a.TipoCadastro, a.CadastroGeral, a.GuiaRecolhimento, a.SubDivida, tdp.parcela