select TRIBCADASTROGERAL.TIPOCADASTRO                                                                     	   AS TIPOCADASTRO,
       TRIBCADASTROGERAL.CADASTROGERAL                                                                    	   AS CADASTROGERAL,
       TRIBCADASTROGERAL.PESSOA                                                                           	   AS PESSOA,
       TRIBDEBITO.ENTIDADE																				  	   AS ENTIDADE,
       TRIBDEBITO.EXERCICIO                                                                               	   AS EXERCICIO,
       TRIBDEBITO.GUIARECOLHIMENTO 																		  	   AS DIVIDA,
       TRIBDEBITO.SUBDIVIDA 																			  	   AS SUBDIVIDA,
       TRIBDEBITOPARCELARECEITA.RECEITA 																  	   AS TRIBUTO,
       TRIBDEBITOPARCELA.DATALANCAMENTO 																  	   AS DATALANCAMENTO,
       TRIBDEBITOPARCELA.DATAVENCIMENTO 																  	   AS DATAVENCIMENTO,
       TRIBDEBITO.DATAPRIMEIRAPARCELA 																	  	   AS DATAPRIMEIRAPARCELA,
       TRIBDEBITOPARCELA.SITUACAOLEGAL 																	  	   AS SITUACAOLEGAL,
       TRIBDEBITOPARCELARECEITA.VALOR 																	  	   AS VALORPRINCIPAL,
       TRIBDEBITO.FORMACORRECAO 																		  	   AS FORMACORRECAO,
       CASE WHEN TRIBDEBITO.CONSTITUIDO  = 'S' THEN 1 ELSE 0 END 										  	   AS CONSTITUIDO,
       CASE WHEN TRIBDEBITO.PARCELADO = 'S' THEN 1 ELSE 0 END 											  	   AS PARCELADO,
       CASE WHEN TRIBDEBITO.REPARCELADO = 'S' THEN 1 ELSE 0 END 										  	   AS REPARCELADO,
       TRIBDEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA  									 			  	   AS IDDEBITOPARCELARECEITA,
       TRIBDEBITO.IDDEBITO 																				  	   AS IDDEBITO,
       TRIBDEBITOPARCELARECEITA.PARCELA 																  	   AS PARCELA,
       CASE WHEN TRIBGUIARECOLHIMENTO.EMITEBLOQUETO = 'S' THEN 1 ELSE 0 END 							  	   AS EMITEBOLETO,
       TRIBGUIARECOLHIMENTO.DESCRICAO 																	  	   AS DESCRICAODIVIDA,
       TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA 														  	   AS TIPOSITUACAOPARCELA,
       TRIBDEBITOPARCELA.IDPROTESTO 																	  	   AS IDPROTESTO,
       TRIBSITUACAOPARCELA.DESCRICAO 																	  	   AS SITUACAODEBITODESCRICAO,
       TRIBSITUACAOPARCELA.SIGLA 																		  	   AS SITUACAODEBITOSIGLA,
       COALESCE(TRIBDEBITO.NOPROCESSOCOMUMUNICA, CAST(TRIBDEBITOPARCELA.PROCESSOJUDICIAL AS VARCHAR(30))) 	   AS NOPROCESSOCOMUMUNICA,
       TRIBPARCELAMENTO.IDPARCELAMENTO 																	  	   AS IDPARCELAMENTO,
       COALESCE(TRIBPARCELAMENTO.PORCONTRIBUINTE,'N') 														   AS PORCONTRIBUINTE,
       TRIBPARCELAMENTO.NUMEROCONTRATO 																	  	   AS NUMEROPARCELAMENTO,
       TRIBPARCELAMENTO.ANOCONTRATO  																		   AS EXERCICIOPARCELAMENTO,
       TRT.CLASSIFICACAORECEITATIPO                                                                            as CLASSIFICACAOTIPOTRIBUTO,
       (SELECT CASE ESTORNADO WHEN 'N' THEN 1 ELSE 0 END
       	FROM TRIBESTORNOPARCELAMENTO ESTORNOPARC
       	WHERE ESTORNOPARC.IDESTORNOPARCELAMENTO = ( SELECT MAX(IDESTORNOPARCELAMENTO)
       											  FROM TRIBESTORNOPARCELAMENTODEBITO ESTORNOPARCDEB
       											  WHERE ESTORNOPARCDEB.IDDEBITODESTINO = TRIBDEBITO.IDDEBITO)) AS  ORIUNDOESTORNOCONTRATO,
        TRIBPROTESTOREMESSAITEM.CARTORIO                                                                       AS CARTORIO,
        min(cda.idcertidao)        						  	  												   AS IDCERTIDAO,
        min(cda.numerocertidao)  																			   AS NUMEROCERTIDAO,
        min(cda.exerciciocertidao)  									   									   AS EXERCICIOCERTIDAO
FROM TRIBDEBITO TRIBDEBITO
    INNER JOIN TRIBDEBITOPARCELA TRIBDEBITOPARCELA ON TRIBDEBITO.ENTIDADE         = TRIBDEBITOPARCELA.ENTIDADE
												  AND TRIBDEBITO.EXERCICIO        = TRIBDEBITOPARCELA.EXERCICIO
												  AND TRIBDEBITO.TIPOCADASTRO     = TRIBDEBITOPARCELA.TIPOCADASTRO
												  AND TRIBDEBITO.CADASTROGERAL    = TRIBDEBITOPARCELA.CADASTROGERAL
												  AND TRIBDEBITO.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
												  AND TRIBDEBITO.SUBDIVIDA        = TRIBDEBITOPARCELA.SUBDIVIDA
	INNER JOIN TRIBDEBITOPARCELARECEITA TRIBDEBITOPARCELARECEITA ON TRIBDEBITOPARCELARECEITA.ENTIDADE         = TRIBDEBITOPARCELA.ENTIDADE
															    AND TRIBDEBITOPARCELARECEITA.EXERCICIO        = TRIBDEBITOPARCELA.EXERCICIO
															    AND TRIBDEBITOPARCELARECEITA.TIPOCADASTRO     = TRIBDEBITOPARCELA.TIPOCADASTRO
															    AND TRIBDEBITOPARCELARECEITA.CADASTROGERAL    = TRIBDEBITOPARCELA.CADASTROGERAL
															    AND TRIBDEBITOPARCELARECEITA.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
															    AND TRIBDEBITOPARCELARECEITA.SUBDIVIDA        = TRIBDEBITOPARCELA.SUBDIVIDA
															    AND TRIBDEBITOPARCELARECEITA.PARCELA          = TRIBDEBITOPARCELA.PARCELA
	INNER JOIN TRIBCADASTROGERAL TRIBCADASTROGERAL ON TRIBDEBITO.TIPOCADASTRO  = TRIBCADASTROGERAL.TIPOCADASTRO
    											  AND TRIBDEBITO.CADASTROGERAL = TRIBCADASTROGERAL.CADASTROGERAL
	INNER JOIN TRIBSITUACAOPARCELA TRIBSITUACAOPARCELA ON TRIBDEBITOPARCELA.SITUACAODEBITO = TRIBSITUACAOPARCELA.SITUACAOPARCELA
	INNER JOIN TRIBTIPOSITUACAOPARCELA TRIBTIPOSITUACAOPARCELA ON TRIBSITUACAOPARCELA.TIPOSITUACAOPARCELA = TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA
	LEFT JOIN TRIBGUIARECOLHIMENTO TRIBGUIARECOLHIMENTO ON TRIBGUIARECOLHIMENTO.ENTIDADE         = TRIBDEBITO.ENTIDADE
													   AND TRIBGUIARECOLHIMENTO.EXERCICIO        = TRIBDEBITO.EXERCICIO
													   AND TRIBGUIARECOLHIMENTO.GUIARECOLHIMENTO = TRIBDEBITO.GUIARECOLHIMENTO
	LEFT JOIN TRIBPROTESTO TRIBPROTESTO ON TRIBDEBITOPARCELA.IDPROTESTO = TRIBPROTESTO.IDPROTESTO
	LEFT JOIN TRIBPARCELAMENTODEBITO TRIBPARCELAMENTODEBITO ON TRIBPARCELAMENTODEBITO.IDDEBITO = TRIBDEBITO.IDDEBITO
	LEFT JOIN TRIBPARCELAMENTO TRIBPARCELAMENTO ON TRIBPARCELAMENTO.IDPARCELAMENTO = TRIBPARCELAMENTODEBITO.IDPARCELAMENTO
    LEFT JOIN TRIBRECEITA TR ON TRIBDEBITOPARCELARECEITA.ENTIDADE = TR.ENTIDADE AND TRIBDEBITOPARCELARECEITA.EXERCICIO = TR.EXERCICIO AND TRIBDEBITOPARCELARECEITA.RECEITA = TR.RECEITA
    LEFT JOIN TRIBRECEITATIPO TRT ON TRT.TIPORECEITA = TR.TIPORECEITA
	LEFT OUTER join (select tdpr.entidade,
	   tdpr.exercicio as exerciciodebito,
	   tdpr.tipocadastro as tipocadastro,
	   tdpr.cadastrogeral as cadastrogeral,
	   tdpr.guiarecolhimento as guiarecolhimento,
	   tdpr.subdivida as subdivida,
	   tdpr.receita as receita,
	   tdpr.parcela as parcela,
	   td.iddebito iddebitoatual,
	   tdorigem.iddebito as iddebitoorigem,
	   case
		   when cda_atual.idcertidao is not null then 'ATUAL'
	   	   when cda_origem.idcertidao is not null then 'ORIGEM'
		   else null
	   end as debitoemcda,
	   coalesce(cda_atual.idcertidao,cda_origem.idcertidao) as idcertidao,
	   coalesce(cda_atual.numerocertidao,cda_origem.numerocertidao) as numerocertidao,
	   coalesce(cda_atual.exerciciocertidao,cda_origem.exerciciocertidao) as exerciciocertidao
from tribdebitoparcelareceita tdpr
	join tribdebito td on tdpr.entidade = td.entidade and tdpr.exercicio = td.exercicio
						and tdpr.tipocadastro  = td.tipocadastro and tdpr.cadastrogeral  = td.cadastrogeral
						and tdpr.guiarecolhimento  = td.guiarecolhimento and tdpr.subdivida  = td.subdivida
    left join ( SELECT     tdidajoin.entidade           as entidade,
				           tdidajoin.exerciciodebito 	as exerciciodebito,
				           tdidajoin.tipocadastro 		as tipocadastro,
				           tdidajoin.cadastrogeral 		as cadastrogeral,
				           tdidajoin.guiarecolhimento   as guiarecolhimento,
				           tdidajoin.subdivida          as subdivida,
				           tdidajoin.receita 			as receita,
				           tdidajoin.parcela            as parcela,
				           doc.idkey 					AS idcertidao,
				           doc.documento 				AS numerocertidao,
				           doc.EXERCICIO 				AS exerciciocertidao,
				           doc.cancelado
				FROM  tribdocumentoitemdividaativa tdidajoin
				    INNER JOIN tribdocumento doc ON tdidajoin.entidade      = doc.entidade
				                                AND tdidajoin.exercicio     = doc.exercicio
				                                AND tdidajoin.tipodocumento = doc.tipodocumento
				                                AND tdidajoin.documento     = doc.documento
				WHERE tdidajoin.tipodocumento = 26
				    AND doc.cancelado = 'N'
					AND (tdidajoin.exercicio, tdidajoin.documento) IN (SELECT MAX(tdidamax.exercicio), MAX(tdidamax.documento) AS ultimodocumento
					                                                   FROM tribdocumentoitemdividaativa tdidamax
					                                                       JOIN tribdocumento docmax ON  docmax.entidade      = tdidamax.entidade
					                                                                                AND  docmax.exercicio     = tdidamax.exercicio
					                                                                                AND  docmax.tipodocumento = tdidamax.tipodocumento
					                                                                                AND  docmax.documento     = tdidamax.documento
					                                                                                AND  docmax.cancelado     = 'N'
					                                                   WHERE   tdidamax.entidade         = tdidajoin.entidade
					                                                       AND tdidamax.exerciciodebito  = tdidajoin.exerciciodebito
					                                                       AND tdidamax.tipocadastro     = tdidajoin.tipocadastro
					                                                       AND tdidamax.cadastrogeral    = tdidajoin.cadastrogeral
					                                                       AND tdidamax.guiarecolhimento = tdidajoin.guiarecolhimento
					                                                       AND tdidamax.subdivida        = tdidajoin.subdivida
					                                                       AND tdidamax.parcela          = tdidajoin.parcela
					                                                       AND tdidamax.receita          = tdidajoin.receita
					                                                       AND tdidamax.tipodocumento    = tdidajoin.tipodocumento
					                                                       AND tdidamax.exercicio = ( SELECT MAX(tdidaexercicio.exercicio)
					                                                                                  FROM tribdocumentoitemdividaativa tdidaexercicio
					                                                                                      JOIN tribdocumento docexercicio ON  docexercicio.entidade = tdidaexercicio.entidade
					                                                                                                                     AND  docexercicio.exercicio = tdidaexercicio.exercicio
					                                                                                                                     AND  docexercicio.tipodocumento = tdidaexercicio.tipodocumento
					                                                                                                                     AND  docexercicio.documento     = tdidaexercicio.documento
					                                                                                                                     AND  docexercicio.cancelado     = 'N'
					                                                                                                                 WHERE tdidaexercicio.entidade       = tdidajoin.entidade
					                                                                                                                   AND tdidaexercicio.exerciciodebito  = tdidajoin.exerciciodebito
					                                                                                                                   AND tdidaexercicio.tipocadastro     = tdidajoin.tipocadastro
					                                                                                                                   AND tdidaexercicio.cadastrogeral    = tdidajoin.cadastrogeral
					                                                                                                                   AND tdidaexercicio.guiarecolhimento = tdidajoin.guiarecolhimento
					                                                                                                                   AND tdidaexercicio.subdivida        = tdidajoin.subdivida
					                                                                                                                   AND tdidaexercicio.parcela          = tdidajoin.parcela
					                                                                                                                   AND tdidaexercicio.receita          = tdidajoin.receita
					                                                                                                                   AND tdidaexercicio.tipodocumento    = tdidajoin.tipodocumento)))
               as cda_atual on cda_atual.entidade = tdpr.entidade
				            and cda_atual.exerciciodebito  = tdpr.exercicio
				            and cda_atual.tipocadastro  = tdpr.tipocadastro
				            and cda_atual.cadastrogeral  = tdpr.cadastrogeral
				            and cda_atual.guiarecolhimento  = tdpr.guiarecolhimento
				            and cda_atual.subdivida  = tdpr.subdivida
        left join tribparcelamentodebitoorigem tpdo on tpdo.iddebitonovo = td.iddebito
        left join tribparcelamento tp on tp.idparcelamento  = tpdo.idparcelamento
        left join tribdebito tdorigem on tdorigem.iddebito = tpdo.iddebito
        left join  ( SELECT     tdidajoin.entidade           as entidade,
				           tdidajoin.exerciciodebito 	as exerciciodebito,
				           tdidajoin.tipocadastro 		as tipocadastro,
				           tdidajoin.cadastrogeral 		as cadastrogeral,
				           tdidajoin.guiarecolhimento   as guiarecolhimento,
				           tdidajoin.subdivida          as subdivida,
				           tdidajoin.receita 			as receita,
				           tdidajoin.parcela            as parcela,
				           doc.idkey 					AS idcertidao,
				           doc.documento 				AS numerocertidao,
				           doc.EXERCICIO 				AS exerciciocertidao,
				           doc.cancelado
				FROM  tribdocumentoitemdividaativa tdidajoin
				    INNER JOIN tribdocumento doc ON tdidajoin.entidade      = doc.entidade
				                                AND tdidajoin.exercicio     = doc.exercicio
				                                AND tdidajoin.tipodocumento = doc.tipodocumento
				                                AND tdidajoin.documento     = doc.documento
				WHERE tdidajoin.tipodocumento = 26
				    AND doc.cancelado = 'N'
					AND (tdidajoin.exercicio, tdidajoin.documento) IN (SELECT MAX(tdidamax.exercicio), MAX(tdidamax.documento) AS ultimodocumento
					                                                   FROM tribdocumentoitemdividaativa tdidamax
					                                                       JOIN tribdocumento docmax ON  docmax.entidade      = tdidamax.entidade
					                                                                                AND  docmax.exercicio     = tdidamax.exercicio
					                                                                                AND  docmax.tipodocumento = tdidamax.tipodocumento
					                                                                                AND  docmax.documento     = tdidamax.documento
					                                                                                AND  docmax.cancelado     = 'N'
					                                                   WHERE   tdidamax.entidade         = tdidajoin.entidade
					                                                       AND tdidamax.exerciciodebito  = tdidajoin.exerciciodebito
					                                                       AND tdidamax.tipocadastro     = tdidajoin.tipocadastro
					                                                       AND tdidamax.cadastrogeral    = tdidajoin.cadastrogeral
					                                                       AND tdidamax.guiarecolhimento = tdidajoin.guiarecolhimento
					                                                       AND tdidamax.subdivida        = tdidajoin.subdivida
					                                                       AND tdidamax.parcela          = tdidajoin.parcela
					                                                       AND tdidamax.receita          = tdidajoin.receita
					                                                       AND tdidamax.tipodocumento    = tdidajoin.tipodocumento
					                                                       AND tdidamax.exercicio = ( SELECT MAX(tdidaexercicio.exercicio)
					                                                                                  FROM tribdocumentoitemdividaativa tdidaexercicio
					                                                                                      JOIN tribdocumento docexercicio ON  docexercicio.entidade = tdidaexercicio.entidade
					                                                                                                                     AND  docexercicio.exercicio = tdidaexercicio.exercicio
					                                                                                                                     AND  docexercicio.tipodocumento = tdidaexercicio.tipodocumento
					                                                                                                                     AND  docexercicio.documento     = tdidaexercicio.documento
					                                                                                                                     AND  docexercicio.cancelado     = 'N'
					                                                                                                                 WHERE tdidaexercicio.entidade       = tdidajoin.entidade
					                                                                                                                   AND tdidaexercicio.exerciciodebito  = tdidajoin.exerciciodebito
					                                                                                                                   AND tdidaexercicio.tipocadastro     = tdidajoin.tipocadastro
					                                                                                                                   AND tdidaexercicio.cadastrogeral    = tdidajoin.cadastrogeral
					                                                                                                                   AND tdidaexercicio.guiarecolhimento = tdidajoin.guiarecolhimento
					                                                                                                                   AND tdidaexercicio.subdivida        = tdidajoin.subdivida
					                                                                                                                   AND tdidaexercicio.parcela          = tdidajoin.parcela
					                                                                                                                   AND tdidaexercicio.receita          = tdidajoin.receita
					                                                                                                                   AND tdidaexercicio.tipodocumento    = tdidajoin.tipodocumento)))
               as cda_origem on cda_origem.entidade = tdorigem.entidade
				            and cda_origem.exerciciodebito  = tdorigem.exercicio
				            and cda_origem.tipocadastro  = tdorigem.tipocadastro
				            and cda_origem.cadastrogeral  = tdorigem.cadastrogeral
				            and cda_origem.guiarecolhimento  = tdorigem.guiarecolhimento
				            and cda_origem.subdivida  = tdorigem.subdivida
            left join tribdebitoparcelareceita tdpro on tdpro.entidade = cda_origem.entidade and tdpro.entidade = tdorigem.entidade
            										and tdpro.exercicio = cda_origem.exerciciodebito and tdpro.exercicio  = tdorigem.exercicio
            										and tdpro.tipocadastro = cda_origem.tipocadastro and tdpro.tipocadastro = tdorigem.tipocadastro
            										and tdpro.cadastrogeral = cda_origem.cadastrogeral and tdpro.cadastrogeral = tdorigem.cadastrogeral
            										and tdpro.guiarecolhimento= cda_origem.guiarecolhimento and tdpro.guiarecolhimento = tdorigem.guiarecolhimento
            										and tdpro.subdivida = cda_origem.subdivida and tdpro.subdivida = tdorigem.subdivida
            										and tdpro.parcela = cda_origem.parcela and tdpro.receita = cda_origem.receita
  ) cda ON cda.entidade = TRIBDEBITOPARCELARECEITA.entidade
                                                                             and cda.exerciciodebito = TRIBDEBITOPARCELARECEITA.exercicio
                                                                             and cda.cadastrogeral= TRIBDEBITOPARCELARECEITA.cadastrogeral
                                                                             and cda.tipocadastro= TRIBDEBITOPARCELARECEITA.tipocadastro
                                                                             and cda.guiarecolhimento = TRIBDEBITOPARCELARECEITA.guiarecolhimento
                                                                             and cda.subdivida = TRIBDEBITOPARCELARECEITA.subdivida
                                                                             and cda.parcela =TRIBDEBITOPARCELARECEITA.parcela
                                                                             and cda.receita = TRIBDEBITOPARCELARECEITA.receita
	LEFT OUTER JOIN TRIBPROTESTOREMESSAITEM TRIBPROTESTOREMESSAITEM ON TRIBPROTESTOREMESSAITEM.idprotesto = TRIBDEBITOPARCELA.idprotesto
																   AND TRIBPROTESTOREMESSAITEM.entidade = TRIBPROTESTO.entidade
																   AND TRIBPROTESTOREMESSAITEM.exercicio = TRIBPROTESTO.exercicio
																   AND TRIBPROTESTOREMESSAITEM.remessa = (SELECT MAX(tprimax.remessa)
																									      FROM tribprotestoremessaitem tprimax
																									      WHERE tprimax.idprotesto = TRIBDEBITOPARCELA.idprotesto)
																   AND TRIBPROTESTOREMESSAITEM.sequencia = (SELECT MAX(tprimax.sequencia)
																									    	FROM tribprotestoremessaitem tprimax
																									    	WHERE tprimax.idprotesto = TRIBDEBITOPARCELA.idprotesto
																									    	AND tprimax.remessa = TRIBPROTESTOREMESSAITEM.remessa)
WHERE TRIBDEBITO.ENTIDADE = 1
  AND TRIBTIPOSITUACAOPARCELA.TIPO = 'A'
  AND TRIBDEBITOPARCELARECEITA.VALOR > 0
  AND TRIBCADASTROGERAL.EXCLUSAOLOGICA = 'N'
  [FILTER]
group by TRIBCADASTROGERAL.TIPOCADASTRO,
         TRIBCADASTROGERAL.CADASTROGERAL,
         TRIBCADASTROGERAL.PESSOA,
         TRIBDEBITO.ENTIDADE,
         TRIBDEBITO.EXERCICIO,
         TRIBDEBITO.GUIARECOLHIMENTO,
         TRIBDEBITO.SUBDIVIDA,
         TRIBDEBITOPARCELARECEITA.RECEITA,
         TRIBDEBITOPARCELA.DATALANCAMENTO,
         TRIBDEBITOPARCELA.DATAVENCIMENTO,
         TRIBDEBITO.DATAPRIMEIRAPARCELA,
         TRIBDEBITOPARCELA.SITUACAOLEGAL,
         TRIBDEBITOPARCELARECEITA.VALOR,
         TRIBDEBITO.FORMACORRECAO,
         15,
         16,
         17,
         TRIBDEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA,
         TRIBDEBITO.IDDEBITO,
         TRIBDEBITOPARCELARECEITA.PARCELA,
         21,
         TRIBGUIARECOLHIMENTO.DESCRICAO,
         TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA,
         TRIBDEBITOPARCELA.IDPROTESTO,
         TRIBSITUACAOPARCELA.DESCRICAO,
         TRIBSITUACAOPARCELA.SIGLA,
         27,
         TRIBPARCELAMENTO.IDPARCELAMENTO,
         TRIBPARCELAMENTO.PORCONTRIBUINTE,
         TRIBPARCELAMENTO.NUMEROCONTRATO,
         TRIBPARCELAMENTO.ANOCONTRATO,
         TRT.CLASSIFICACAORECEITATIPO,
         32,
         TRIBPROTESTOREMESSAITEM.CARTORIO