	select cdi.tipocadastro,
		   cdi.cadastrogeral,
		   cdi.pessoa,
		   p.nome,
		   p.cnpj_cpf as cpfCnpj,
		   cdi.exercicio,
		   cdi.divida,
		   dpr.subdivida,
		   dpr.parcela,
		   gr.descricao as descricaoDivida,
		   sum(cdi.valor) as valor,
		   sum(cdi.valorjuros) as valorJuros,
		   sum(cdi.valormulta) as valorMulta,
		   sum(cdi.valorcorrecao) as valorCorrecao,
		   sum(cdi.valorliquido) as valorLiquido,
		   sum(cdi.valorhonorario) as valorHonorario,
		   cp.telefoneresidencial,
		   cp.telefonecomercial,
		   cp.telefonefax,
		   cp.telefonecelular,
		   cp.email,
		   CASE
            WHEN cdi.tipocadastro = 1 THEN 'IMOBILIÁRIO'
            WHEN cdi.tipocadastro = 2 THEN 'MOBILIÁRIO'
            WHEN cdi.tipocadastro = 3 THEN 'RURAL'
            WHEN cdi.tipocadastro = 4 THEN 'CEMITÉRIO'
            WHEN cdi.tipocadastro = 9 THEN 'AVULSO'
            ELSE '-'
            END as descricaoTipoCadastro
	  from consultadebito cd
	  join consultadebitoitem cdi
		on cd.id = cdi.idconsultadebito
 left join pessoa p
		on cdi.pessoa = p.pessoa
left join contatopessoa cp
		on cp.sequencia = p.sequenciacontato
		and cp.pessoa  = p.pessoa
 left join tribguiarecolhimento gr
		on cdi.entidade = gr.entidade
	   and cdi.exercicio = gr.exercicio
	   and cdi.divida = gr.guiarecolhimento
 left join tribreceitatipo rt
 		on cdi.tipotributo = rt.tiporeceita
 left join tribdebitoparcelareceita dpr
 		on dpr.iddebitoparcelareceita = cdi.iddebitotributo
	 where cd.id = :idConsulta
  group by dpr.parcela,
  		   cdi.tipocadastro,
	       cdi.cadastrogeral,
	       cdi.pessoa,
	       p.nome,
	       p.cnpj_cpf,
	       cdi.exercicio,
	       cdi.divida,
	       dpr.subdivida,
	       gr.descricao,
	       cp.telefoneresidencial,
           cp.telefonecomercial,
           cp.telefonefax,
           cp.telefonecelular,
           cp.email
  order by cdi.tipocadastro,
	       cdi.cadastrogeral,
	       cdi.divida,
	       dpr.subdivida,
	       dpr.parcela