select
	tc.entidade,
	tc.exercicio,
	tc.carne,
	tc.carne || '/' || tc.exercicio as identificacao,
	tc.data as dataemissao,
	p.nome,
	tc.codigobarras,
	tc.situacaonaoretirado as situacaoCarne,
	CASE WHEN tc.situacaonaoretirado = '0'
            THEN 'Entregue'
         WHEN tc.situacaonaoretirado = '1'
            THEN 'Devolvido'
         WHEN tc.situacaonaoretirado = '2'
            THEN 'Cancelado'
    END AS descricaosituacaocarne,
    sum(boleto.valortotal) as valortotal
from
	tribcarne tc
inner join
(select
    distinct
	tcb.entidade,
	tcb.exercicio,
	tcb.carne,
	tb.bloqueto,
	tdpr.exercicio as exerciciodebito,
	tdpr.guiarecolhimento,
	tdpr.subdivida,
	coalesce(tb.valorprincipal,0) +
	coalesce(tb.valorjuros,0) +
	coalesce(tb.valormulta,0) +
	coalesce(tb.valorcorrecao,0) - coalesce(tb.valordesconto,0) as valortotal
from
    tribcarnebloqueto tcb
inner join tribbloqueto tb on
	tcb.entidade = tb.entidade
	and tcb.exercicio = tb.exerciciobloqueto
	and tcb.bloqueto = tb.bloqueto
inner join tribbloquetodebito tbd on
	tb.entidade = tbd.entidade
	and tb.exerciciobloqueto = tbd.exerciciobloqueto
	and tb.bloqueto = tbd.bloqueto
inner join tribdebitoparcelareceita tdpr on
	tbd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita) as boleto
on boleto.entidade = tc.entidade
and boleto.exercicio = tc.exercicio
and boleto.carne = tc.carne
inner join tribcadastrogeral tcg on
	tcg.tipocadastro = tc.tipocadastro
	and tcg.cadastrogeral = tc.cadastrogeral
inner join pessoa p on
	p.pessoa = tcg.pessoa
where
tc.entidade = :entidade
%s
group by
tc.entidade,
tc.exercicio,
tc.carne,
tc.data,
p.nome,
tc.codigobarras,
tc.situacaonaoretirado
