select
    item.entidade,
    debito.exercicio,
    debito.datalancamento,
    debito.dataprimeiraparcela,
    debitoparcela.datavencimento,
    debitoparcela.datavencimento as datavencimentooriginal,
    debito.formacorrecao,
    case when coalesce(debito.parcelado, 'N') = 'N' then 0 else 1 end as parcelado,
    debitoparcela.situacaolegal,
    item.receita as tributo,
    item.valor,
    debitoparcelatributo.valororiginal as valororiginal,
    item.guiarecolhimento as iddivida
from tribdocumentoitemdividaativa item
left outer join tribdebito debito
    on debito.entidade = item.entidade
    and debito.exercicio = item.exerciciodebito
    and debito.tipocadastro = item.tipocadastro
    and debito.cadastrogeral = item.cadastrogeral
    and debito.guiarecolhimento = item.guiarecolhimento
    and debito.subdivida = item.subdivida
left outer join tribdebitoparcela debitoparcela
    on debitoparcela.entidade = item.entidade
    and debitoparcela.exercicio = item.exerciciodebito
    and debitoparcela.tipocadastro = item.tipocadastro
    and debitoparcela.cadastrogeral = item.cadastrogeral
    and debitoparcela.guiarecolhimento = item.guiarecolhimento
    and debitoparcela.subdivida = item.subdivida
    and debitoparcela.parcela = item.parcela
left outer join tribdebitoparcelareceita debitoparcelatributo
    on debitoparcelatributo.entidade = item.entidade
    and debitoparcelatributo.exercicio = item.exerciciodebito
    and debitoparcelatributo.tipocadastro = item.tipocadastro
    and debitoparcelatributo.cadastrogeral = item.cadastrogeral
    and debitoparcelatributo.guiarecolhimento = item.guiarecolhimento
    and debitoparcelatributo.subdivida = item.subdivida
    and debitoparcelatributo.parcela = item.parcela
    and debitoparcelatributo.receita = item.receita
where item.entidade = :entidade
and item.exercicio = :exercicio
and item.tipodocumento = 26
and item.documento = :documento
and item.sequenciaitem = :sequenciaItem
