SELECT $[FILTROTODOSCADASTROS],
       TD.ENTIDADE,
       TD.EXERCICIO,
       TD.TIPOCADASTRO,
       TD.CADASTROGERAL,
       TD.GUIARECOLHIMENTO                              as DIVIDA,
       CAST(TD.SUBDIVIDA as NUMERIC(15, 2))             as SubDivida,
       TD.IDDEBITO,
       TDP.PARCELA,
       TSP.DESCRICAO                                    as SITUACAODEBITODESCRICAO,
       TDPR.RECEITA                                     as TRIBUTO,
       P.PESSOA,
       P.NOME                                           as NOMECONTRIBUINTE,
       P.NOMEFANTASIA,
       P.RG,
       P.INSCRICAOESTADUAL,
       P.TIPOPESSOA,
       P.CNPJ_CPF                                       AS CNPJCPFCONTRIBUINTE,
       EP.NUMERO                                        as NUMEROCONTRIBUINTE,
       EP.COMPLEMENTO                                   as COMPLEMENTOCONTRIBUINTE,
       LP.descricao                                     as LOGRADOUROCONTRIBUINTE,
       TLP.DESCRICAO                                    as TIPOLOGRADOUROCONTRIBUINTE,
       CP.DESCRICAO                                     AS CIDADECONTRIBUINTE,
       CP.UNIDADEFEDERACAO                              as UNIDADEFEDERACAOCONTRIBUINTE,
       TIPOLOG.DESCRICAO                                as TIPOLOGRADOURO,
       LOG.DESCRICAO                                    as LOGRADOURO,
       TCG.NUMERO                                       as NUMERO,
       TCG.COMPLEMENTO                                  as COMPLEMENTO,
       TCG.CEP                                          as cep,
       TSP.TipoSituacaoParcela,
       TDP.SITUACAOLEGAL,
       TD.DataPrimeiraParcela                           as DATAPRIMEIRAPARCELA,
       TD.FormaCorrecao,
       BAI.descricao                                    as bairro,
       TCM.numeroRegistro,
       TCM.atividadePrincipal,
       TCM.cadastroGeralImobiliario,
       TCM.telefone,
       CASE WHEN TD.Constituido = 'S' THEN 1 ELSE 0 END AS CONSTITUIDO,
       CASE WHEN TD.Parcelado = 'S' THEN 1 ELSE 0 END   AS PARCELADO,
       CASE WHEN TD.Reparcelado = 'S' THEN 1 ELSE 0 END AS REPARCELADO,
       tdpr.valor                                       as ValorPrincipal,
       TDP.DATAVENCIMENTO,
       TDP.DATALANCAMENTO,
       TDP.DATASITUACAO                                    DATAMOVIMENTO,
       TP.DATAPAGAMENTO,
       TDP.IDPROTESTO,
       COALESCE(CASE
                    WHEN tsp.tiposituacaoparcela IN (2,33,34,35,36)  THEN
                        pagamentos.valorpago
                    ELSE 0 END, 0)                      AS VALORPAGO,
       TGR.DESCRICAO                                    AS DESCRICAODIVIDA,
       TSP.SIGLA as siglaSituacao,
       TP.EXERCICIOPAGAMENTO,
       TD.IDPARCELAMENTO,
       COALESCE(pagamentos.VALORJUROS, 0)               as VALORJUROSPAGAMENTO,
       COALESCE(pagamentos.VALORMULTA, 0)               as VALORMULTAPAGAMENTO,
       COALESCE(pagamentos.VALORCORRECAO, 0)            as VALORCORRECAOPAGAMENTO,
       COALESCE(pagamentos.VALORDESCONTO, 0)            as VALORDESCONTOPAGAMENTO,
       TCI.INSCRICAOCADASTRAL,
       TCI.QUADRICULA_INSCRICAOCADASTRAL                as QUADRICULA,
       TCI.DISTRITO_INSCRICAOCADASTRAL                  as DISTRITO,
       TS.SETOR,
       TSQ.QUADRA,
       TCI.LOTE_INSCRICAOCADASTRAL                      as LOTEINSCRICAOCADASTRAL,
       TCI.UNIDADE_INSCRICAOCADASTRAL                   as UNIDADE,
       TCI.COMPLEMENTOLOTE,
       TPA.NUMEROCONTRATO,
       TPA.ANOCONTRATO,
       TCI.QUADRA_DESCR                                 as quadraFiscalizacao,
       TCI.LOTE_DESCR                                   as loteFiscalizacao,
       cda.IDCERTIDAO                                   AS idCda,
       cda.NUMEROCERTIDAO                               AS numeroCda,
       cda.EXERCICIOCERTIDAO                            AS exercicioCda
FROM TRIBDEBITO TD
         INNER JOIN TRIBDEBITOPARCELA TDP ON TD.ENTIDADE = TDP.ENTIDADE
    AND TD.EXERCICIO = TDP.EXERCICIO
    AND TD.TIPOCADASTRO = TDP.TIPOCADASTRO
    AND TD.CADASTROGERAL = TDP.CADASTROGERAL
    AND TD.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO
    AND TD.SUBDIVIDA = TDP.SUBDIVIDA
         LEFT JOIN TRIBPARCELAMENTO TPA ON TPA.IDPARCELAMENTO = coalesce(TD.IDPARCELAMENTO, TD.IDREPARCELAMENTO)
         LEFT JOIN TRIBSITUACAOPARCELA TSP ON TSP.SITUACAOPARCELA = TDP.SITUACAODEBITO
         LEFT JOIN TRIBTIPOSITUACAOPARCELA TTSP ON TTSP.TIPOSITUACAOPARCELA = TSP.TIPOSITUACAOPARCELA
         LEFT JOIN TRIBGUIARECOLHIMENTO TGR ON TGR.ENTIDADE = TD.ENTIDADE
    AND TGR.EXERCICIO = TD.EXERCICIO
    AND TGR.GUIARECOLHIMENTO = TD.GUIARECOLHIMENTO
         INNER JOIN TRIBDEBITOPARCELARECEITA TDPR ON TDP.ENTIDADE = TDPR.ENTIDADE
    AND TDP.EXERCICIO = TDPR.EXERCICIO
    AND TDP.TIPOCADASTRO = TDPR.TIPOCADASTRO
    AND TDP.CADASTROGERAL = TDPR.CADASTROGERAL
    AND TDP.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO
    AND TDP.SUBDIVIDA = TDPR.SUBDIVIDA
    AND TDP.PARCELA = TDPR.PARCELA
         left join lateral (select
                                tpd1.iddebitoparcelareceita,
                                min(idpagamentobloqueto) as idpagamentobloqueto,
                                sum(tpd1.valorpago)     as valorpago,
                                SUM(TPD1.VALORJUROS)    as valorjuros,
                                SUM(TPD1.VALORMULTA)    as valormulta,
                                SUM(TPD1.VALORCORRECAO) as valorcorrecao,
                                SUM(TPD1.VALORDESCONTO) as valordesconto
                            from tribpagamentodebito tpd1
                            where TPD1.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
                              AND (TPD1.ESTORNO IS NULL OR TPD1.ESTORNO = 'N')
                              AND (TPD1.valordevolvido IS NULL OR TPD1.valordevolvido = 0)
                            group by tpd1.iddebitoparcelareceita
    ) pagamentos on pagamentos.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
         LEFT JOIN TRIBPAGAMENTOBLOQUETO TPB ON TPB.IDPAGAMENTOBLOQUETO = pagamentos.IDPAGAMENTOBLOQUETO
         LEFT JOIN TRIBPAGAMENTO TP ON TPB.ENTIDADE = TP.ENTIDADE
    AND TPB.EXERCICIOPAGAMENTO = TP.EXERCICIOPAGAMENTO
    AND TPB.PAGAMENTO = TP.PAGAMENTO
         LEFT JOIN TRIBCADASTROGERAL TCG ON TCG.TIPOCADASTRO = TD.TIPOCADASTRO
    AND TCG.CADASTROGERAL = TD.CADASTROGERAL
         LEFT JOIN TRIBCADASTROIMOBILIARIO TCI ON TCG.IDKEY = TCI.TRIBCADASTROGERAL_IDKEY
         LEFT JOIN TRIBCADASTROMOBILIARIO TCM ON TCG.IDKEY = TCM.TRIBCADASTROGERAL_IDKEY
         LEFT JOIN TRIBSETOR TS ON TCI.TRIBSETOR_IDKEY = TS.IDKEY
         LEFT JOIN TRIBSETORQUADRA TSQ ON TCI.TRIBSETOR_IDKEY = TSQ.TRIBSETOR_IDKEY
    AND TCI.QUADRA_INSCRICAOCADASTRAL = TSQ.QUADRA
         LEFT JOIN LOGRADOURO LOG ON TCG.LOGRADOURO_IDKEY = LOG.IDKEY
         LEFT JOIN TIPOLOGRADOURO TIPOLOG ON LOG.TIPOLOGRADOURO = TIPOLOG.TIPOLOGRADOURO
         LEFT JOIN PESSOA P ON P.PESSOA = TCG.PESSOA
         LEFT JOIN ENDERECOPESSOA EP ON P.PESSOA = EP.PESSOA AND EP.SEQUENCIA = P.SEQUENCIAENDERECO
         LEFT JOIN LOGRADOURO LP ON EP.LOGRADOURO_IDKEY = LP.IDKEY
         LEFT JOIN TIPOLOGRADOURO TLP ON LP.TIPOLOGRADOURO = TLP.TIPOLOGRADOURO
         LEFT JOIN CIDADE CP ON EP.CIDADE = CP.CIDADE
         LEFT JOIN BAIRRO BAI ON BAI.IDKEY = TCG.BAIRRO_IDKEY
         LEFT OUTER JOIN ( SELECT  tdidajoin.entidade,
                                   tdidajoin.exercicio,
                                   tdidajoin.tipodocumento,
                                   tdidajoin.documento,
                                   tdidajoin.exerciciodebito,
                                   tdidajoin.tipocadastro,
                                   tdidajoin.cadastrogeral,
                                   tdidajoin.guiarecolhimento,
                                   tdidajoin.subdivida,
                                   tdidajoin.parcela,
                                   tdidajoin.receita,
                                   doc.idkey     AS IDCERTIDAO,
                                   doc.documento AS NUMEROCERTIDAO,
                                   doc.EXERCICIO AS EXERCICIOCERTIDAO,
                                   doc.cancelado
                           FROM  tribdocumentoitemdividaativa tdidajoin
                                INNER JOIN tribdocumento doc ON tdidajoin.entidade  = doc.entidade
                                                               AND tdidajoin.exercicio = doc.exercicio
                                                               AND tdidajoin.tipodocumento = doc.tipodocumento
                                                               AND tdidajoin.documento = doc.documento
                           WHERE tdidajoin.tipodocumento = 26
                                AND doc.cancelado = 'N'
                                AND (tdidajoin.exercicio, tdidajoin.documento) IN
                                         (SELECT MAX(tdidamax.exercicio), MAX(tdidamax.documento) AS ultimodocumento
                                          FROM tribdocumentoitemdividaativa tdidamax
                                              JOIN tribdocumento docmax ON docmax.entidade          = tdidamax.entidade
                                                                          AND  docmax.exercicio     = tdidamax.exercicio
                                                                          AND  docmax.tipodocumento = tdidamax.tipodocumento
                                                                          AND  docmax.documento     = tdidamax.documento
                                                                          AND  docmax.cancelado     = 'N'
                                          WHERE tdidamax.entidade       = tdidajoin.entidade
                                              AND tdidamax.exerciciodebito  = tdidajoin.exerciciodebito
                                              AND tdidamax.tipocadastro     = tdidajoin.tipocadastro
                                              AND tdidamax.cadastrogeral    = tdidajoin.cadastrogeral
                                              AND tdidamax.guiarecolhimento = tdidajoin.guiarecolhimento
                                              AND tdidamax.subdivida        = tdidajoin.subdivida
                                              AND tdidamax.parcela          = tdidajoin.parcela
                                              AND tdidamax.receita          = tdidajoin.receita
                                              AND tdidamax.tipodocumento    = tdidajoin.tipodocumento
                                              AND tdidamax.exercicio = (
                                                    SELECT MAX(tdidaexercicio.exercicio)
                                                    FROM tribdocumentoitemdividaativa tdidaexercicio
                                                       JOIN tribdocumento docexercicio ON docexercicio.entidade          = tdidaexercicio.entidade
                                                                                         AND  docexercicio.exercicio     = tdidaexercicio.exercicio
                                                                                         AND  docexercicio.tipodocumento = tdidaexercicio.tipodocumento
                                                                                         AND  docexercicio.documento     = tdidaexercicio.documento
                                                                                         AND  docexercicio.cancelado     = 'N'
                                                    WHERE tdidaexercicio.entidade           = tdidajoin.entidade
                                                        AND tdidaexercicio.exerciciodebito  = tdidajoin.exerciciodebito
                                                        AND tdidaexercicio.tipocadastro     = tdidajoin.tipocadastro
                                                        AND tdidaexercicio.cadastrogeral    = tdidajoin.cadastrogeral
                                                        AND tdidaexercicio.guiarecolhimento = tdidajoin.guiarecolhimento
                                                        AND tdidaexercicio.subdivida        = tdidajoin.subdivida
                                                        AND tdidaexercicio.parcela          = tdidajoin.parcela
                                                        AND tdidaexercicio.receita          = tdidajoin.receita
                                                        AND tdidaexercicio.tipodocumento    = tdidajoin.tipodocumento
                                              )
                                         )
                           ) cda ON TDPR.entidade             = cda.entidade
                                    AND TDPR.exercicio        = cda.exerciciodebito
                                    AND TDPR.tipocadastro     = cda.tipocadastro
                                    AND TDPR.cadastrogeral    = cda.cadastrogeral
                                    AND TDPR.guiarecolhimento = cda.guiarecolhimento
                                    AND TDPR.subdivida        = cda.subdivida
                                    AND TDPR.receita          = cda.receita
                                    AND TDPR.parcela          = cda.parcela
  WHERE
