select
%s
	coalesce(sum(cdi.valor), 0) as valortotal
from
	tribcancelamentodebito t1
left join tribcancelamentodebitoitem cdi
	on t1.entidade = cdi.entidade
	and t1.exercicio = cdi.exercicio
	and t1.idcancelamento = cdi.idcancelamento
left join tribtipodeducao tipoded
	on t1.tipodeducao = tipoded.tipodeducao
left join tribdebitoparcelareceita dpr
	on cdi.iddebitoparcelareceita = dpr.iddebitoparcelareceita
left join tribreceita rec
	on dpr.entidade = rec.entidade
	and dpr.exercicio = rec.exercicio
	and dpr.receita = rec.receita
left join tribreceitatipo rectipo
	on rec.tipoReceita = rectipo.tiporeceita
left join tribclassificacaoreceitatipo classtipo
	on rectipo.classificacaoreceitatipo = classtipo.classificacaoreceitatipo
left join tribcadastrogeral cad
	on dpr.tipocadastro = cad.tipocadastro
	and dpr.cadastrogeral = cad.cadastrogeral
left join pessoa p
	on cad.pessoa = p.pessoa
left join tribmotivodesconto md
	on t1.motivocancelamento = md.motivodesconto
left join cgato cgt
    on cgt.entidade = md.entidade
	and cgt.idato = md.idato
left join tribdebito td
    on dpr.entidade = td.entidade
	and dpr.exercicio = td.exercicio
	and dpr.tipocadastro = td.tipocadastro
	and dpr.cadastrogeral = td.cadastrogeral
	and dpr.guiarecolhimento = td.guiarecolhimento
	and dpr.subdivida = td.subdivida
where
	t1.datacancelamento between :dataInicial and :dataFinal
	and cdi.valor > 0
	and td.constituido = 'S'
	and tipoded.tipodeducao = :tipoMovimento
%s