/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.paginatedquery;

import br.com.elotech.tributos.util.paginatedquery.PaginatedQuery;
import br.com.elotech.tributos.util.paginatedquery.PaginatedQueryResultMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PaginatedQuery<T extends PaginatedQueryResultMapper<T>> {
    private final EntityManager entityManager;
    private PaginatedQueryResultMapper<T> sample;
    private String mainQuery;
    private Pageable pagination;
    private List<String> columns = List.of();
    private Map<String, Object> parameters = Map.of();
    private Consumer<? super Throwable> onCatchAction;
    private static final String COUNT_QUERY_TEMPLATE = " WITH countquery as ( %s )SELECT COUNT(*) FROM countquery";
    private static final String RESULT_QUERY_TEMPLATE = " SELECT %s %s";

    public PaginatedQuery(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public PaginatedQuery<T> fromMainQuery(String mainQuery) {
        this.mainQuery = mainQuery;
        return this;
    }

    public PaginatedQuery<T> retrieveColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    public PaginatedQuery<T> paginated(Pageable pagination) {
        this.pagination = pagination;
        return this;
    }

    public PaginatedQuery<T> retrieveSample(T sample) {
        this.sample = sample;
        return this;
    }

    public PaginatedQuery<T> withParams(Map<String, Object> params) {
        this.parameters = params;
        return this;
    }

    public PaginatedQuery<T> onError(Consumer<? super Throwable> action) {
        this.onCatchAction = action;
        return this;
    }

    public Page<T> getResult() {
        this.validateIfAllConditionsIsOk();
        return new PageImpl(this.getResultList(), this.pagination, this.getResultCount().longValue());
    }

    private Long getResultCount() {
        try {
            Query query = this.entityManager.createNativeQuery(this.getCountQuery());
            this.applyParameters(query);
            Object result = query.getSingleResult();
            return Long.valueOf(result.toString());
        }
        catch (Exception e) {
            if (Objects.nonNull(this.onCatchAction)) {
                this.onCatchAction.accept(e);
            }
            throw e;
        }
    }

    private List<T> getResultList() {
        try {
            Query query = this.entityManager.createNativeQuery(this.getResultQuery());
            this.applyPagination(query);
            this.applyParameters(query);
            return query.getResultList().stream().map(arg_0 -> ((PaginatedQueryResultMapper)this.sample).map(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            if (Objects.nonNull(this.onCatchAction)) {
                this.onCatchAction.accept(e);
            }
            throw e;
        }
    }

    private String getColumns() {
        return String.join((CharSequence)", ", this.columns);
    }

    private String getCountQuery() {
        return String.format(" WITH countquery as ( %s )SELECT COUNT(*) FROM countquery", this.getResultQuery());
    }

    private String getResultQuery() {
        return String.format(" SELECT %s %s", this.getColumns(), this.mainQuery);
    }

    private void applyPagination(Query query) {
        int offsetAt = this.pagination.getPageNumber() * this.pagination.getPageSize();
        int size = this.pagination.getPageSize();
        query.setFirstResult(offsetAt).setMaxResults(size);
    }

    private void applyParameters(Query query) {
        this.parameters.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
    }

    private void validateIfAllConditionsIsOk() {
        PaginatedQueryValidation.validateIfMainQueryIsOk((String)this.mainQuery);
        PaginatedQueryValidation.validateIfColumnsIsOk((List)this.columns);
        PaginatedQueryValidation.validateIfPaginationIsOk((Pageable)this.pagination);
        PaginatedQueryValidation.validateIfSampleIsOk((PaginatedQueryResultMapper)this.sample);
    }
}

