/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.dto.FilterDTO;
import br.com.elotech.tributos.exception.GenerateMultiValueFilterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MultiValueFilter {
    public static final String FILTER_VALID_REGEX = "^(\\d+-\\d+|\\d+)$";
    public static final String FILTER_BETWEEN_REGEX = "^\\d+-\\d+$";

    private MultiValueFilter() {
    }

    public static String generateFilters(String expression, String field) {
        List filters = MultiValueFilter.generateFilters((String)expression);
        if (filters.isEmpty()) {
            return "";
        }
        String generatedFilters = filters.stream().map(filter -> {
            if (Boolean.TRUE.equals(filter.getIsBetween())) {
                return String.format("%s between %s and %s", field, filter.getValue(), filter.getFinalValue());
            }
            return String.format("%s = %s", field, filter.getValue());
        }).collect(Collectors.joining(" or "));
        return String.format("(%s)", generatedFilters);
    }

    public static String generateFiltersRsql(String expression, String field) {
        List filters = MultiValueFilter.generateFilters((String)expression);
        if (filters.isEmpty()) {
            return "";
        }
        String generatedFilters = filters.stream().map(filter -> {
            if (Boolean.TRUE.equals(filter.getIsBetween())) {
                return String.format("(%s >= %s and %s <= %s)", field, filter.getValue(), field, filter.getFinalValue());
            }
            return String.format("%s == %s", field, filter.getValue());
        }).collect(Collectors.joining(" or "));
        return String.format("(%s)", generatedFilters);
    }

    public static List<FilterDTO> generateFilters(String expression) {
        if (StringUtils.isBlank((String)expression)) {
            return new ArrayList<FilterDTO>();
        }
        String[] filters = expression.split(",");
        List errors = Arrays.stream(filters).map(String::trim).filter(filter -> !filter.matches("^(\\d+-\\d+|\\d+)$")).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            String invalidFilters = String.join((CharSequence)",", errors);
            throw GenerateMultiValueFilterException.invalidFilters((String)invalidFilters);
        }
        return Arrays.stream(filters).map(String::trim).filter(filter -> filter.matches("^(\\d+-\\d+|\\d+)$")).map(FilterDTO::of).collect(Collectors.toList());
    }
}

