/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;

public class JsonNodeUtil {
    private JsonNodeUtil() {
    }

    public static void consumeAsText(JsonNode jsonNode, Consumer<String> consumer) {
        Optional.ofNullable(jsonNode).ifPresent(data -> consumer.accept(data.asText()));
    }

    public static void consumeAsInt(JsonNode jsonNode, Consumer<Integer> consumer) {
        Optional.ofNullable(jsonNode).ifPresent(data -> consumer.accept(data.asInt()));
    }

    public static void consumeAsLong(JsonNode jsonNode, Consumer<Long> consumer) {
        Optional.ofNullable(jsonNode).ifPresent(data -> consumer.accept(data.asLong()));
    }

    public static void consumeAsBoolean(JsonNode jsonNode, Consumer<Boolean> consumer) {
        Optional.ofNullable(jsonNode).ifPresent(data -> consumer.accept(data.asBoolean()));
    }

    public static void consumeAsDate(JsonNode jsonNode, Consumer<Date> consumer) {
        Optional.ofNullable(jsonNode).ifPresent(data -> {
            Instant instant = Instant.parse(data.asText());
            consumer.accept(Date.from(instant));
        });
    }
}

