/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.annotation.FieldConfig;
import br.com.elotech.tributos.util.FileUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.item.file.transform.FieldSet;

/*
 * Exception performing whole class analysis ignored.
 */
public class FieldUtils {
    public static <T> List<String> getFields(Class<T> tipo, String line) {
        ArrayList<String> retorno = new ArrayList<String>();
        List<Field> fields = List.of(tipo.getDeclaredFields());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(FieldConfig.class)) continue;
            FieldConfig fieldConfig = field.getAnnotation(FieldConfig.class);
            String texto = line.substring(fieldConfig.min() - 1, fieldConfig.max());
            retorno.add(texto.trim());
        }
        return retorno;
    }

    public static void setFields(Object object, FieldSet fieldSet) {
        try {
            List<Field> fields = List.of(object.getClass().getDeclaredFields());
            int i = 0;
            for (Field field : fields) {
                if (!field.isAnnotationPresent(FieldConfig.class)) continue;
                field.setAccessible(true);
                FieldConfig fieldConfig = field.getAnnotation(FieldConfig.class);
                String valor = fieldSet.readString(i);
                if (StringUtils.isEmpty((CharSequence)StringUtils.trim((String)valor))) {
                    field.setAccessible(false);
                    ++i;
                    continue;
                }
                if (field.getType().equals(BigDecimal.class)) {
                    field.set(object, new BigDecimal(valor).movePointLeft(2));
                }
                if (field.getType().equals(LocalDate.class)) {
                    String formato = fieldConfig.dateFormate();
                    field.set(object, FileUtils.tryParseLocalDateOrNull((String)valor, (String)formato));
                }
                if (field.getType().equals(Long.class)) {
                    field.set(object, new Long(valor));
                }
                if (field.getType().equals(String.class)) {
                    field.set(object, valor);
                }
                field.setAccessible(false);
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getString(Object object) {
        try {
            List<Field> fields = List.of(object.getClass().getDeclaredFields());
            int i = 0;
            StringBuilder sb = new StringBuilder();
            for (Field field : fields) {
                Object value;
                if (!field.isAnnotationPresent(FieldConfig.class)) continue;
                field.setAccessible(true);
                FieldConfig fieldConfig = field.getAnnotation(FieldConfig.class);
                if (field.getType().equals(BigDecimal.class)) {
                    value = (BigDecimal)field.get(object);
                    sb.append(FieldUtils.getCompleteString((String)((BigDecimal)value).toString().replace(".", ""), (FieldConfig)fieldConfig));
                }
                if (field.getType().equals(LocalDate.class)) {
                    value = (LocalDate)field.get(object);
                    String formato = fieldConfig.dateFormate();
                    DateTimeFormatter formatters = DateTimeFormatter.ofPattern(formato);
                    sb.append(FieldUtils.getCompleteString((String)((LocalDate)value).format(formatters), (FieldConfig)fieldConfig));
                }
                if (field.getType().equals(Long.class)) {
                    value = (Long)field.get(object);
                    sb.append(FieldUtils.getCompleteString((String)((Long)value).toString(), (FieldConfig)fieldConfig));
                }
                if (field.getType().equals(String.class)) {
                    value = (String)field.get(object);
                    if (Objects.isNull(value)) {
                        value = "";
                    }
                    sb.append(FieldUtils.getCompleteString((String)value, (FieldConfig)fieldConfig));
                }
                field.setAccessible(false);
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getCompleteString(String text, FieldConfig fieldConfig) {
        Integer size = fieldConfig.max() - fieldConfig.min() + 1;
        if (Boolean.TRUE.equals(fieldConfig.leftPad())) {
            return StringUtils.leftPad((String)text.substring(0, Math.min(text.length(), size)), (int)size, (String)fieldConfig.replace());
        }
        return StringUtils.rightPad((String)text.substring(0, Math.min(text.length(), size)), (int)size, (String)fieldConfig.replace());
    }
}

