/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.ConfigurableEnvironment;

/*
 * Exception performing whole class analysis ignored.
 */
public class AmbienteUtils {
    public static String getCurrentURL(ConfigurableEnvironment environment) {
        if (AmbienteUtils.environmentAccept((ConfigurableEnvironment)environment, (String[])new String[]{"onpremise"})) {
            return AmbienteUtils.buildUrlOnPremise((ConfigurableEnvironment)environment);
        }
        return AmbienteUtils.buildUrlOnCloud((ConfigurableEnvironment)environment);
    }

    private static String buildUrlOnPremise(ConfigurableEnvironment environment) {
        String externalUrl = environment.getProperty("tributos.externalUrl");
        if (StringUtils.isEmpty((CharSequence)externalUrl)) {
            throw new EloValidationException("URL externa n\u00e3o configurada.");
        }
        return externalUrl.concat(AmbienteUtils.getContextPath((ConfigurableEnvironment)environment));
    }

    private static String buildUrlOnCloud(ConfigurableEnvironment environment) {
        return "https://".concat(AmbienteUtils.getTenant()).concat("." + AmbienteUtils.getAmbiente((ConfigurableEnvironment)environment)).concat(".elotech.com.br").concat(AmbienteUtils.getContextPath((ConfigurableEnvironment)environment));
    }

    public static String getTenant() {
        return TenantContextHolder.getCurrentTenantId();
    }

    public static String getAmbiente(ConfigurableEnvironment environment) {
        if (AmbienteUtils.isDevEnvironment((ConfigurableEnvironment)environment)) {
            return "dev";
        }
        if (AmbienteUtils.isQaEnvironment((ConfigurableEnvironment)environment)) {
            return "qa";
        }
        if (AmbienteUtils.isTestEnvironment((ConfigurableEnvironment)environment)) {
            return "test";
        }
        return "oxy";
    }

    public static String getContextPath(ConfigurableEnvironment environment) {
        return environment.getProperty("server.servlet.context-path", "/tributos-api");
    }

    private static boolean isDevEnvironment(ConfigurableEnvironment environment) {
        return AmbienteUtils.environmentAccept((ConfigurableEnvironment)environment, (String[])new String[]{"local", "localoracle", "dev"});
    }

    private static boolean isQaEnvironment(ConfigurableEnvironment environment) {
        return AmbienteUtils.environmentAccept((ConfigurableEnvironment)environment, (String[])new String[]{"qa"});
    }

    private static boolean isTestEnvironment(ConfigurableEnvironment environment) {
        return AmbienteUtils.environmentAccept((ConfigurableEnvironment)environment, (String[])new String[]{"test"});
    }

    private static boolean environmentAccept(ConfigurableEnvironment environment, String ... profiles) {
        return environment.acceptsProfiles(profiles);
    }
}

