/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoCotaUnicaDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AgrupaDebitos {
    private AgrupaDebitos() {
    }

    public static List<DebitoAgrupadoPorFormaPagamentoDTO> agrupaDebitosPorDebitoEFormaPagamento(List<DebitoParcelaTributoCotaUnicaDTO> debitosParcelaReceitaCotaUnicaDTO) {
        Map<Long, Map<Long, List<DebitoParcelaTributoCotaUnicaDTO>>> debitoParcelaTributoAgrupadoPorIdDebitoeFormaPagamento = debitosParcelaReceitaCotaUnicaDTO.stream().map(DebitoParcelaTributoCotaUnicaDTO::applyDesconto).collect(Collectors.groupingBy(DebitoParcelaTributoCotaUnicaDTO::getIdDebito, Collectors.groupingBy(DebitoParcelaTributoCotaUnicaDTO::getFormaPagamento)));
        ArrayList debitos = new ArrayList();
        debitoParcelaTributoAgrupadoPorIdDebitoeFormaPagamento.forEach((idDebito, values) -> values.forEach((formaPagamento, debitoParcelaTributos) -> debitos.add(AgrupaDebitos.agrupaParcelaTributoPorDebito((List)debitoParcelaTributos))));
        return debitos.stream().sorted(Comparator.comparing(DebitoAgrupadoPorFormaPagamentoDTO::getIdDebito).thenComparing(DebitoAgrupadoPorFormaPagamentoDTO::getSubDivida).thenComparing(Comparator.comparing(DebitoAgrupadoPorFormaPagamentoDTO::getOrdemEmissao, Comparator.nullsLast(Comparator.naturalOrder()))).thenComparing(Comparator.comparing(DebitoAgrupadoPorFormaPagamentoDTO::getFormaPagamento))).collect(Collectors.toList());
    }

    private static DebitoAgrupadoPorFormaPagamentoDTO agrupaParcelaTributoPorDebito(List<DebitoParcelaTributoCotaUnicaDTO> debitoParcelaTributoPorFormaPagamento) {
        DebitoParcelaTributoCotaUnicaDTO debitoParcelaReceitaFirst = debitoParcelaTributoPorFormaPagamento.iterator().next();
        DebitoAgrupadoPorFormaPagamentoDTO debitoCotaUnicaDTO = new DebitoAgrupadoPorFormaPagamentoDTO();
        debitoCotaUnicaDTO.setIdDebito(debitoParcelaReceitaFirst.getIdDebito());
        debitoCotaUnicaDTO.setExercicio(debitoParcelaReceitaFirst.getExercicio());
        debitoCotaUnicaDTO.setTipoCadastro(debitoParcelaReceitaFirst.getTipoCadastro());
        debitoCotaUnicaDTO.setCadastroGeral(debitoParcelaReceitaFirst.getCadastroGeral());
        debitoCotaUnicaDTO.setDivida(debitoParcelaReceitaFirst.getGuiaRecolhimento());
        debitoCotaUnicaDTO.setSubDivida(debitoParcelaReceitaFirst.getSubdivida());
        debitoCotaUnicaDTO.setDescricaoVisualizacao(debitoParcelaReceitaFirst.getDescricaoGuia());
        debitoCotaUnicaDTO.setFormaPagamento(debitoParcelaReceitaFirst.getFormaPagamento());
        debitoCotaUnicaDTO.setTipoFormaPagamento(debitoParcelaReceitaFirst.getTipoFormaPagamento());
        debitoCotaUnicaDTO.setEntidade(debitoParcelaReceitaFirst.getEntidade());
        debitoCotaUnicaDTO.setVencimento(debitoParcelaReceitaFirst.getVencimento());
        debitoCotaUnicaDTO.setDescricaoFormaPagamento(debitoParcelaReceitaFirst.getDescricaoFormaPagamento());
        BigDecimal valorTotal = AgrupaDebitos.getValorTotal(debitoParcelaTributoPorFormaPagamento);
        BigDecimal valorTotalComDesconto = AgrupaDebitos.getValorTotalComDesconto(debitoParcelaTributoPorFormaPagamento);
        BigDecimal percentualDesconto = AgrupaDebitos.getPercentualDesconto(debitoParcelaTributoPorFormaPagamento);
        debitoCotaUnicaDTO.setValor(valorTotalComDesconto);
        debitoCotaUnicaDTO.setValorDesconto(valorTotal.subtract(valorTotalComDesconto));
        debitoCotaUnicaDTO.setValorOriginal(valorTotal);
        debitoCotaUnicaDTO.setPercentualDesconto(percentualDesconto);
        debitoCotaUnicaDTO.setOrdemEmissao(debitoParcelaReceitaFirst.getOrdemEmissao());
        debitoCotaUnicaDTO.setVerificaFormaPagtoDiferenciada(debitoParcelaReceitaFirst.getVerificaFormaPagtoDiferenciada());
        debitoCotaUnicaDTO.setIsCotaUnica(debitoParcelaReceitaFirst.isCotaUnica());
        debitoCotaUnicaDTO.setNome(debitoParcelaReceitaFirst.getNome());
        return debitoCotaUnicaDTO;
    }

    private static BigDecimal getValorTotal(List<DebitoParcelaTributoCotaUnicaDTO> listDebitoParcelaReceita) {
        return listDebitoParcelaReceita.stream().map(DebitoParcelaTributoCotaUnicaDTO::getValorTotalSemDesconto).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static BigDecimal getValorTotalComDesconto(List<DebitoParcelaTributoCotaUnicaDTO> listDebitoParcelaReceita) {
        return listDebitoParcelaReceita.stream().map(DebitoParcelaTributoCotaUnicaDTO::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static BigDecimal getPercentualDesconto(List<DebitoParcelaTributoCotaUnicaDTO> listDebitoParcelaReceita) {
        List listaDescontos = listDebitoParcelaReceita.stream().map(DebitoParcelaTributoCotaUnicaDTO::getDesconto).filter(f -> f.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (!listaDescontos.isEmpty()) {
            return (BigDecimal)listaDescontos.get(0);
        }
        return BigDecimal.ZERO;
    }
}

