/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.unico;

import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.tributos.security.AuthenticationClientUnico;
import br.com.elotech.unico.client.PessoaFeignClient;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.exception.UnicoClientException;
import feign.FeignException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class PessoaClientUnico {
    private static final Logger LOGGER = LoggerFactory.getLogger(PessoaClientUnico.class);
    private static final String MSGAUTENTICADOSUCESSO = "Autenticado no \u00fanico com sucesso";
    private final PessoaFeignClient pessoaFeignClient;
    private final AuthenticationClientUnico authClient;

    public PessoaClientUnico(PessoaFeignClient pessoaFeignClient, AuthenticationClientUnico authenticationClient) {
        this.pessoaFeignClient = pessoaFeignClient;
        this.authClient = authenticationClient;
    }

    public PessoaDTO savePessoa(PessoaDTO pessoaDTO) {
        try {
            String token = this.authClient.authenticateAndReturnToken();
            LOGGER.debug(MSGAUTENTICADOSUCESSO);
            return this.pessoaFeignClient.savePessoa(token, pessoaDTO);
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao salvar a pessoa no \u00fanico. [{}]\nResponse: {}", new Object[]{ex.getMessage(), ex.contentUTF8(), ex});
            LOGGER.error("PessoaDTO. [{}]", (Object)pessoaDTO);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel inserir a nova pessoa no \u00fanico", (Throwable)ex);
        }
    }

    public Optional<PessoaDTO> getPessoaByCnpjCpfAndAtivo(String cnpjCpf) {
        try {
            String token = this.authClient.authenticateAndReturnToken();
            LOGGER.debug(MSGAUTENTICADOSUCESSO);
            String search = String.format("cnpjCpf==%s and inativo==false", cnpjCpf);
            ResponseEntity responsePessoas = this.pessoaFeignClient.findPessoaByRSQL(token, search);
            if (responsePessoas.getStatusCode().equals((Object)HttpStatus.OK) && responsePessoas.hasBody() && ((EloPage)responsePessoas.getBody()).hasContent()) {
                return Optional.of((PessoaDTO)((EloPage)responsePessoas.getBody()).getContent().get(0));
            }
            return Optional.empty();
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao carregar a pessoa no \u00fanico. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel carregar a pessoa do \u00fanico", (Throwable)ex);
        }
    }

    public PessoaDTO ativaContribuinte(Long idPessoa) {
        try {
            String token = this.authClient.authenticateAndReturnToken();
            LOGGER.debug(MSGAUTENTICADOSUCESSO);
            ResponseEntity pessoaDTOResponseEntity = this.pessoaFeignClient.ativaContribuinte(idPessoa, token);
            if (pessoaDTOResponseEntity.getStatusCode().equals((Object)HttpStatus.OK) && Objects.nonNull(pessoaDTOResponseEntity.getBody())) {
                return (PessoaDTO)pessoaDTOResponseEntity.getBody();
            }
            return null;
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao ativar pessoa como contribuinte. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel ativar a pessoa no m\u00f3dulo aise tributos", (Throwable)ex);
        }
    }

    public PessoaDTO patchPessoa(Long id, List<JsonUpdatePartial> updates) {
        try {
            LOGGER.debug(MSGAUTENTICADOSUCESSO);
            ResponseEntity response = this.pessoaFeignClient.patch(updates, id);
            if (response.getStatusCode().equals((Object)HttpStatus.OK) && response.hasBody()) {
                return (PessoaDTO)response.getBody();
            }
            return null;
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao realizar patch da pessoa no \u00fanico. [{}]\nUpdates: {}", new Object[]{ex.getMessage(), updates, ex});
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel atualizar parcialmente a pessoa no \u00fanico", (Throwable)ex);
        }
    }
}

