/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.unico;

import br.com.elotech.tributos.security.AuthenticationClientUnico;
import br.com.elotech.unico.client.CidadeFeignClient;
import br.com.elotech.unico.client.dto.CidadeDTO;
import br.com.elotech.unico.exception.UnicoClientException;
import feign.FeignException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CidadeClientUnico {
    private static final Logger LOGGER = LoggerFactory.getLogger(CidadeClientUnico.class);
    private static final String MSGAUTENTICADOSUCESSO = "Autenticado no \u00fanico com sucesso";
    private final CidadeFeignClient cidadeFeignClient;
    private final AuthenticationClientUnico authClient;

    public CidadeClientUnico(CidadeFeignClient cidadeFeignClient, AuthenticationClientUnico authenticationClient) {
        this.cidadeFeignClient = cidadeFeignClient;
        this.authClient = authenticationClient;
    }

    public CidadeDTO saveCidade(CidadeDTO cidadeDTO) {
        try {
            String token = this.authClient.authenticateAndReturnToken();
            LOGGER.debug(MSGAUTENTICADOSUCESSO);
            return this.cidadeFeignClient.saveCidade(token, cidadeDTO);
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao salvar a cidade no \u00fanico. [{}]\nResponse: {}", new Object[]{ex.getMessage(), ex.contentUTF8(), ex});
            LOGGER.error("CidadeDTO. [{}]", (Object)cidadeDTO);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel inserir a nova cidade no \u00fanico", (Throwable)ex);
        }
    }
}

