/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples.pgfn;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnArquivo;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoDTO;
import br.com.elotech.tributos.enums.supersimples.pgfn.SituacaoArquivoPgfn;
import br.com.elotech.tributos.repository.supersimples.pgfn.PgfnArquivoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.supersimples.pgfn.PgfnConfiguracaoService;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PgfnArquivoService
extends CrudService<PgfnArquivo, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgfnArquivoService.class);
    private final PgfnArquivoRepository pgfnArquivoRepository;
    private final PgfnConfiguracaoService pgfnConfiguracaoService;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;

    public PgfnArquivo importArquivo(MultipartFile file) throws IOException {
        this.validateConfiguracao();
        String hash = this.calculateHashArquivo(file);
        this.validateHashArquivo(hash);
        PgfnArquivoDTO dto = this.buildPgfnArquivoDTO(file, SecurityUtils.getUserAise());
        this.validateTipoRegistro(dto.getTipoRegistro());
        PgfnArquivo pgfnArquivo = this.saveArquivo(dto);
        this.uploadArquivo(pgfnArquivo, file, hash);
        return pgfnArquivo;
    }

    public void validateConfiguracao() {
        this.pgfnConfiguracaoService.validateConfiguracao();
    }

    private String calculateHashArquivo(MultipartFile file) throws IOException {
        String fileContent = new String(file.getBytes(), StandardCharsets.UTF_8);
        return DigestUtils.sha256Hex((String)fileContent);
    }

    private void validateHashArquivo(String hash) {
        this.findByHash(hash).ifPresent(existingFile -> {
            throw new EloValidationException(String.format("O arquivo j\u00e1 foi importado com o ID %d.", existingFile.getId()));
        });
    }

    private Optional<PgfnArquivo> findByHash(String hash) {
        return this.pgfnArquivoRepository.findByHash(hash);
    }

    public void validateTipoRegistro(Long tipoRegistro) {
        if (tipoRegistro != 0L) {
            throw new IllegalArgumentException("Cabe\u00e7alho inv\u00e1lido no arquivo PGFN.");
        }
    }

    private PgfnArquivo saveArquivo(PgfnArquivoDTO dto) {
        return (PgfnArquivo)this.pgfnArquivoRepository.save((Object)PgfnArquivoDTO.of((PgfnArquivoDTO)dto));
    }

    private PgfnArquivoDTO buildPgfnArquivoDTO(MultipartFile file, String usuario) {
        PgfnArquivoDTO pgfnArquivoDTO;
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));
        try {
            pgfnArquivoDTO = new PgfnArquivoDTO(reader.readLine(), file.getOriginalFilename(), usuario);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Erro ao processar o cabe\u00e7alho do arquivo PGFN.", ex);
            }
        }
        reader.close();
        return pgfnArquivoDTO;
    }

    private void uploadArquivo(PgfnArquivo pgfnArquivo, MultipartFile file, String hash) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("idPgfnArquivo", pgfnArquivo.getId().toString());
        ArquivoDTO arquivoDTO = new ArquivoDTO(null, file.getOriginalFilename(), SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/pgfn-arquivo", LocalDate.now(), "text/plain", null, null, metadata);
        ArquivoDTO storageResponse = this.arquivoStorageFeignClient.createWithFile(arquivoDTO, file);
        pgfnArquivo.setIdArquivo(storageResponse.getId());
        pgfnArquivo.setHash(hash);
        this.pgfnArquivoRepository.save((Object)pgfnArquivo);
    }

    private void updateSituacaoArquivo(Long idArquivoPgfn, SituacaoArquivoPgfn situacao) {
        PgfnArquivo pgfnArquivo = (PgfnArquivo)this.pgfnArquivoRepository.findOne((Object)idArquivoPgfn);
        pgfnArquivo.setSituacao(situacao);
        if (SituacaoArquivoPgfn.ERRO_IMPORTACAO.equals((Object)situacao)) {
            pgfnArquivo.setHash(null);
        }
        this.pgfnArquivoRepository.save((Object)pgfnArquivo);
    }

    public void iniciarImportacao(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.IMPORTANDO);
    }

    public void finalizarImportacao(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.IMPORTADO);
    }

    public void finalizarImportacaoComErro(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.ERRO_IMPORTACAO);
    }

    public void iniciarValidacao(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.VALIDANDO);
    }

    public void finalizarValidacao(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.VALIDADO);
    }

    public void finalizarValidacaoComErro(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.ERRO_VALIDACAO);
    }

    public void iniciarProcessamento(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.PROCESSANDO);
    }

    public void finalizarProcessamento(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.PROCESSADO);
    }

    public void finalizarProcessamentoComErro(Long idArquivoPgfn) {
        this.updateSituacaoArquivo(idArquivoPgfn, SituacaoArquivoPgfn.ERRO_PROCESSAMENTO);
    }

    @Generated
    public PgfnArquivoService(PgfnArquivoRepository pgfnArquivoRepository, PgfnConfiguracaoService pgfnConfiguracaoService, ArquivoStorageFeignClient arquivoStorageFeignClient) {
        this.pgfnArquivoRepository = pgfnArquivoRepository;
        this.pgfnConfiguracaoService = pgfnConfiguracaoService;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
    }
}

