/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples.pgfn;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.DividaTributoPK;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnConfiguracao;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnDadosDebito;
import br.com.elotech.tributos.dto.DebitoManualIssDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.debito.DebitoSubdividaDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemEntityDTO;
import br.com.elotech.tributos.enums.supersimples.pgfn.SituacaoItemArquivoPgfn;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.repository.DividaTributoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GeracaoDebitoPgfnService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeracaoDebitoPgfnService.class);
    private final ParametroGeralService parametroGeralService;
    private final DebitoService debitoService;
    private final GeraDebitoService geraDebitoService;
    private final ContextService contextService;
    private final DividaTributoRepository dividaTributoRepository;

    public void generateNovoDebito(PgfnArquivoItemEntityDTO item, PgfnConfiguracao configuracao) {
        try {
            PgfnDadosDebito dadosDebito = item.getDadosDebito();
            String periodoApuracao = dadosDebito.getPeriodoApuracao();
            long exercicioApuracao = Long.parseLong(periodoApuracao.substring(0, 4));
            Long dividaConfigurada = this.fetchDividaConfigurada(dadosDebito.getTributo(), configuracao);
            DebitoManualIssDTO debitoManualIssDTO = this.createDebitoManualIssDTO(item, configuracao, exercicioApuracao, dividaConfigurada, periodoApuracao);
            LocalDate dataVencimento = item.getDadosDebito().getVencimento();
            this.addParcelaToDebitoManual(debitoManualIssDTO, dataVencimento, item.getDadosDebito().getValor());
            this.addObservacoesToDebitoManual(debitoManualIssDTO, item);
            Optional debito = this.geraDebitoService.geraDebitoManualPgfn(debitoManualIssDTO).stream().findFirst();
            debito.ifPresent(value -> this.updateItemDadosDebito(item, value));
        }
        catch (Exception e) {
            log.debug("Erro ao gerar d\u00e9bito do PGFN para o registro: Arquivo: [{}] Dados: [{}]. Erro: [{}] ", new Object[]{item.getDadosDebito().getPgfnArquivo().getId(), item.getDadosDebito().getId(), e.getMessage(), e});
            this.updateItemDadosDebitoComErroNaGeracaoDebito(item, e.getMessage());
        }
    }

    private DebitoManualIssDTO createDebitoManualIssDTO(PgfnArquivoItemEntityDTO item, PgfnConfiguracao configuracao, long exercicioApuracao, Long dividaConfigurada, String periodoApuracao) {
        DebitoManualIssDTO debitoManualIssDTO = new DebitoManualIssDTO();
        debitoManualIssDTO.setTributo(this.fetchTributoConfigurado(configuracao, item.getDadosDebito().getTributo().longValue(), exercicioApuracao));
        debitoManualIssDTO.setExercicio(Long.valueOf(exercicioApuracao));
        debitoManualIssDTO.setBaixaAutomatica(Boolean.TRUE);
        debitoManualIssDTO.setTipoCadastro(TipoCadastro.fromValue((Long)item.getDevedorPreferencial().getTipoCadastro()));
        debitoManualIssDTO.setCadastroGeral(item.getDevedorPreferencial().getCadastroGeral());
        debitoManualIssDTO.setDivida(dividaConfigurada);
        debitoManualIssDTO.setSubDivida(this.fetchSubdivida(item, exercicioApuracao, dividaConfigurada, periodoApuracao));
        debitoManualIssDTO.setDataLancamento(LocalDate.now());
        debitoManualIssDTO.setDataInclusao(LocalDate.now());
        debitoManualIssDTO.setProgram("ArquivoPGFN");
        return debitoManualIssDTO;
    }

    private void addParcelaToDebitoManual(DebitoManualIssDTO debitoManualIssDTO, LocalDate dataVencimento, BigDecimal valor) {
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setDataVencimento(dataVencimento);
        debitoManualParcelaDTO.setValor(valor);
        debitoManualParcelaDTO.setDataSituacao(dataVencimento);
        debitoManualParcelaDTO.setMesReferencia(Long.valueOf(dataVencimento.getMonth().getValue()));
        debitoManualParcelaDTO.setAnoReferencia(Long.valueOf(dataVencimento.getYear()));
        debitoManualIssDTO.getParcelas().add(debitoManualParcelaDTO);
    }

    private void addObservacoesToDebitoManual(DebitoManualIssDTO debitoManualIssDTO, PgfnArquivoItemEntityDTO item) {
        debitoManualIssDTO.getObservacoes().add(this.createObservacaoDTO(String.format("D\u00e9bito gerado pela importa\u00e7\u00e3o do arquivo PGFN pelos dados %d do arquivo %d", item.getDadosDebito().getId(), item.getDadosDebito().getPgfnArquivo().getId())));
        String fundamentoLegalPrincipal = item.getDadosDebito().getFundamentoLegalPrincipal();
        if (Objects.nonNull(fundamentoLegalPrincipal) && !fundamentoLegalPrincipal.isEmpty()) {
            debitoManualIssDTO.getObservacoes().add(this.createObservacaoDTO(fundamentoLegalPrincipal));
        }
    }

    private void updateItemDadosDebitoComErroNaGeracaoDebito(PgfnArquivoItemEntityDTO item, String message) {
        item.getDadosDebito().setDebito(null);
        item.getDadosDebito().setParcela(null);
        item.getDadosDebito().setSituacao(SituacaoItemArquivoPgfn.ERRO_GERACAO_DEBITO);
        item.getDadosDebito().setMensagem(this.truncateMessageItem(String.format("Erro ao gerar d\u00e9bito. Erro: %s", message)));
    }

    private String truncateMessageItem(String mensagem) {
        int MAX_LENGTH = 1000;
        return mensagem.length() > 1000 ? mensagem.substring(0, 1000) : mensagem;
    }

    private DebitoManualObservacaoDTO createObservacaoDTO(String observacao) {
        DebitoManualObservacaoDTO observacaoDTO = new DebitoManualObservacaoDTO();
        observacaoDTO.setObservacao(observacao);
        return observacaoDTO;
    }

    private DividaTributo fetchTributoConfigurado(PgfnConfiguracao configuracao, long tributoId, long exercicioApuracao) {
        Divida divida = this.isDebitoIss(Long.valueOf(tributoId)) ? configuracao.getDividaIss() : configuracao.getDividaIcms();
        Tributo tributo = this.isDebitoIss(Long.valueOf(tributoId)) ? configuracao.getTributoIss() : configuracao.getTributoIcms();
        DividaTributoPK dividaTributoPK = new DividaTributoPK();
        dividaTributoPK.setEntidade(this.contextService.getEntidadePrincipal());
        dividaTributoPK.setExercicio(Long.valueOf(exercicioApuracao));
        dividaTributoPK.setDivida(divida.getDivida());
        dividaTributoPK.setTributo(tributo.getTributo());
        return (DividaTributo)this.dividaTributoRepository.findOne((Object)dividaTributoPK);
    }

    private Long fetchDividaConfigurada(Long tributo, PgfnConfiguracao configuracao) {
        return this.isDebitoIss(tributo) ? configuracao.getDividaIss().getDivida() : configuracao.getDividaIcms().getDivida();
    }

    private boolean isDebitoIss(Long tributo) {
        return tributo == 1L || tributo == 3L;
    }

    private Long fetchSubdivida(PgfnArquivoItemEntityDTO item, long exercicioApuracao, Long divida, String periodoApuracao) {
        boolean isUtilizaMesComoSubdivida = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.DEBITO_ISS_MES_COMO_PARCELA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (!isUtilizaMesComoSubdivida) {
            return this.debitoService.getNextValueSubdivida(NextSubdividaValueParams.of((Long)item.getDevedorPreferencial().getTipoCadastro(), (Long)item.getDevedorPreferencial().getCadastroGeral(), (Long)exercicioApuracao, (Long)divida));
        }
        long mes = Long.parseLong(periodoApuracao.substring(4, 6));
        long subdividaMes = mes + 100L;
        List debitoSubdividas = this.debitoService.getDebitoSubdividasByCompositeKey(item.getDevedorPreferencial().getTipoCadastro(), item.getDevedorPreferencial().getCadastroGeral(), Long.valueOf(exercicioApuracao), divida);
        return this.calculateProximaSubdividaByMes(subdividaMes, mes, debitoSubdividas);
    }

    private long calculateProximaSubdividaByMes(long subdividaAtual, long mes, List<DebitoSubdividaDTO> debitoSubdividas) {
        return debitoSubdividas.stream().filter(dto -> this.getDoisUltimosDigitos(dto.getSubdivida().longValue()) == mes && dto.getSubdivida() > subdividaAtual).map(DebitoSubdividaDTO::getSubdivida).max(Long::compare).map(maiorSubdivida -> maiorSubdivida + 100L).orElse(subdividaAtual);
    }

    private long getDoisUltimosDigitos(long valor) {
        return valor % 100L;
    }

    private void updateItemDadosDebito(PgfnArquivoItemEntityDTO item, Debito debito) {
        item.getDadosDebito().setDebito(debito);
        item.getDadosDebito().setParcela(debito.getNumeroParcela());
        item.getDadosDebito().setSituacao(SituacaoItemArquivoPgfn.DEBITO_GERADO);
    }

    @Generated
    public GeracaoDebitoPgfnService(ParametroGeralService parametroGeralService, DebitoService debitoService, GeraDebitoService geraDebitoService, ContextService contextService, DividaTributoRepository dividaTributoRepository) {
        this.parametroGeralService = parametroGeralService;
        this.debitoService = debitoService;
        this.geraDebitoService = geraDebitoService;
        this.contextService = contextService;
        this.dividaTributoRepository = dividaTributoRepository;
    }
}

