/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.solicitacaopagamento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.solicitacaopagamento.SolicitacaoPagamento;
import br.com.elotech.tributos.domain.solicitacaopagamento.SolicitacaoPagamentoArquivo;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.pagamento.SolicitacaoPagamentoSicoobResponseDTO;
import br.com.elotech.tributos.enums.SituacaoSolicitacaoPagamento;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SolicitacaoPagamentoService
extends CrudService<SolicitacaoPagamento, Long> {
    public SolicitacaoPagamento createSolicitacao(SolicitacaoPagamentoSicoobResponseDTO response, Convenio convenio, LocalDate dataReferencia) {
        SolicitacaoPagamento solicitacaoPagamento = new SolicitacaoPagamento();
        solicitacaoPagamento.setCodigoSolicitacao(response.getResultado().getCodigoSolicitacao());
        solicitacaoPagamento.setSituacao(SituacaoSolicitacaoPagamento.AGUARDANDO_PROCESSAMENTO);
        solicitacaoPagamento.setConvenio(convenio);
        solicitacaoPagamento.setDataInclusao(LocalDate.now());
        solicitacaoPagamento.setDataReferencia(dataReferencia);
        return (SolicitacaoPagamento)this.save((EloEntity)solicitacaoPagamento, null);
    }

    public SolicitacaoPagamento updateSolicitacao(SolicitacaoPagamentoSicoobResponseDTO response, SolicitacaoPagamento solicitacaoPagamento, SituacaoSolicitacaoPagamento situacao) {
        solicitacaoPagamento.setQuantidadeRegistros(Optional.ofNullable(response.getResultado().getQuantidadeTotalRegistros()).orElse(0));
        solicitacaoPagamento.setQuantidadeArquivo(Optional.ofNullable(response.getResultado().getQuantidadeArquivo()).orElse(0));
        solicitacaoPagamento.setSituacao(situacao);
        solicitacaoPagamento.setDataProcessamento(LocalDate.now());
        return (SolicitacaoPagamento)this.save((EloEntity)solicitacaoPagamento, null);
    }

    public void insertArquivoSolicitacao(SolicitacaoPagamento solicitacaoPagamento, SolicitacaoPagamentoSicoobResponseDTO response, Long idArquivo) {
        SolicitacaoPagamentoArquivo arquivo = new SolicitacaoPagamentoArquivo();
        arquivo.setCodigoArquivo(idArquivo);
        arquivo.setNomeArquivo(response.getResultado().getNomeArquivo().replace(".zip", ".json"));
        arquivo.setConteudoArquivo(response.getResultado().getArquivo());
        arquivo.setSolicitacaoPagamento(solicitacaoPagamento);
        solicitacaoPagamento.getArquivos().add(arquivo);
        this.save((EloEntity)solicitacaoPagamento, null);
    }

    @Generated
    public SolicitacaoPagamentoService() {
    }
}

