/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.dto.sisobra.wsdl.RecepcaoDSMResponse;
import br.com.elotech.tributos.dto.sisobra.wsdl.RecepcaoLoteResponse;
import br.com.elotech.tributos.repository.CertificadoRepository;
import br.com.elotech.tributos.service.AssinaturaXMLService;
import br.com.elotech.tributos.service.sisobra.SisObraClient;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Service
public class SisObraServiceUtils {
    private final CertificadoRepository certificadoRepository;
    private final AssinaturaXMLService assinaturaXMLService;
    private final SisObraClient sisObraClient;

    public Boolean isXMLEnviadoComErro(String xml) {
        Boolean xmlComErro = Boolean.FALSE;
        try {
            String codRetorno;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("UTF-8"))));
            Node codRetornoNode = document.getElementsByTagName("codRetorno").item(0);
            if (codRetornoNode != null && (codRetorno = codRetornoNode.getTextContent()) != null && codRetorno.contains("ER")) {
                xmlComErro = Boolean.TRUE;
            }
            return xmlComErro;
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao processar XML de retorno : " + e.getMessage());
        }
    }

    public Certificado getCertificadoByEntidade(Long Id2) {
        return (Certificado)this.certificadoRepository.findById((Object)Id2).orElseThrow(() -> new EloValidationException("Certificado n\u00e3o encontrado"));
    }

    public String getXmlAssinado(String xml, String uri, String tagToInsert, Certificado certificado) {
        String xmlAssinado;
        try {
            xmlAssinado = this.assinaturaXMLService.assinar(xml, certificado, uri, tagToInsert);
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao assinar XML: " + e.getMessage());
        }
        return xmlAssinado;
    }

    public String enviarLoteXmlReceitaFederal(String xml, Certificado certificado) {
        RecepcaoLoteResponse recepcaoLoteResponse = this.sisObraClient.getRecepcaoResponse(xml, certificado.getKeyStore(), certificado.getSenha().toCharArray());
        return recepcaoLoteResponse.getXmlResultado();
    }

    public String enviarDsmXmlReceitaFederal(String xml, Certificado certificado) {
        RecepcaoDSMResponse recepcaoDSMResponse = this.sisObraClient.getRecepcaoDsmResponse(xml, certificado.getKeyStore(), certificado.getSenha().toCharArray());
        return recepcaoDSMResponse.getXmlResultado();
    }

    @Generated
    public SisObraServiceUtils(CertificadoRepository certificadoRepository, AssinaturaXMLService assinaturaXMLService, SisObraClient sisObraClient) {
        this.certificadoRepository = certificadoRepository;
        this.assinaturaXMLService = assinaturaXMLService;
        this.sisObraClient = sisObraClient;
    }
}

