/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.domain.sisobra.SisObraHabitese;
import br.com.elotech.tributos.domain.sisobra.SisObraHabiteseArea;
import br.com.elotech.tributos.domain.sisobra.SisObraHabiteseHistorico;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.sisobra.FiltroSisObraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraAreaDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseDadosAlvaraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseHistoricoDTO;
import br.com.elotech.tributos.enums.sisobra.StatusDocumentos;
import br.com.elotech.tributos.enums.sisobra.TipoArea;
import br.com.elotech.tributos.enums.sisobra.TipoHabitese;
import br.com.elotech.tributos.enums.sisobra.UnidadeMedida;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraAreaRepositoryImpl;
import br.com.elotech.tributos.repository.sisobra.SisObraHabiteseAreaRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraHabiteseHistoricoRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraHabiteseRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.sisobra.SisObraServiceUtils;
import br.com.elotech.tributos.util.sisobra.SisObraHabiteseXmlBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SisObraHabiteseService
extends CrudService<SisObraHabitese, Long> {
    private static final Long ACRESCIMO_DE_SEQUENCIA = 1L;
    private final SisObraAlvaraAreaRepositoryImpl sisObraAlvaraAreaRepositoryImpl;
    private final SisObraHabiteseRepository sisObraHabiteseRepository;
    private final SisObraHabiteseAreaRepository sisObraHabiteseAreaRepository;
    private final ContextService contextService;
    private final SisObraHabiteseHistoricoRepository sisObraHabiteseHistoricoRepository;
    private final SisObraServiceUtils sisObraServiceUtils;

    public Page<SisObraHabiteseDTO> findDocumentoSisObraHabitese(FiltroSisObraDTO filtro, Pageable pageable) {
        List documentos = this.sisObraHabiteseRepository.findDocumentoSisObraHabitese(filtro, pageable);
        return new PageImpl(documentos, pageable, (long)documentos.size());
    }

    public Page<SisObraHabiteseHistoricoDTO> findHistoricoHabitese(Long id, Pageable pageable) {
        List sisObraHabiteseHistorico = this.sisObraHabiteseHistoricoRepository.findByIdHabitese(id, pageable);
        List sisObraHabiteseHistoricoDTO = sisObraHabiteseHistorico.stream().map(SisObraHabiteseHistoricoDTO::from).collect(Collectors.toList());
        return new PageImpl(sisObraHabiteseHistoricoDTO, pageable, (long)pageable.getPageSize());
    }

    public void gravarDados(List<SisObraHabiteseDTO> habiteses, UserSecurityDTO user) {
        Certificado certificado = this.sisObraServiceUtils.getCertificadoByEntidade(this.contextService.getEntidadePrincipal());
        for (SisObraHabiteseDTO habitese : habiteses) {
            SisObraHabitese habiteseToSave = new SisObraHabitese();
            List listHabiteseArea = new ArrayList();
            if (habitese.getIdSisObraHabitese() > 0L) {
                habiteseToSave = (SisObraHabitese)this.sisObraHabiteseRepository.findOne((Object)habitese.getIdSisObraHabitese());
                this.deleteAreasHabiteseById(habitese.getIdSisObraHabitese());
            }
            SisObraHabiteseDadosAlvaraDTO dadosAlvara = this.getDadosAlvaraHabitese(habitese.getNroAlvaraHabitese(), habitese.getDataAlvaraHabitese());
            habiteseToSave.setNumeroHabitese(String.valueOf(habitese.getDocumento()));
            habiteseToSave.setDataHabitese(habitese.getDataEmissao());
            habiteseToSave.setDataInicioObra(habitese.getDataInicio());
            habiteseToSave.setDataFinalObra(habitese.getDataEncerramento());
            habiteseToSave.setTipoHabitese(this.getTipoHabitese(habitese, dadosAlvara).getId());
            habiteseToSave.setUnidadeMedida(UnidadeMedida.M2.getId());
            habiteseToSave.setValorUnidadeMedida(Double.valueOf(0.0));
            habiteseToSave.setIdAlvara(dadosAlvara.getIdAlvara());
            habiteseToSave.setDataAlvara(habitese.getDataAlvaraHabitese());
            habiteseToSave.setNumeroAlvaraDoc(habitese.getNroAlvaraHabitese());
            habiteseToSave.setTipoDocumento(habitese.getTipoDocumento());
            habiteseToSave.setIdSisobraHabitese(habitese.getExercicioDocumento() + String.format("%04d", habitese.getTipoDocumento()) + String.format("%06d", habitese.getDocumento()));
            this.sisObraHabiteseRepository.save((Object)habiteseToSave);
            listHabiteseArea = this.gravarDadosArea(habiteseToSave.getId(), this.contextService.getEntidadePrincipal(), habitese.getExercicioProjeto(), habitese.getProjeto());
            String xmlToSave = this.getHabiteseXml(habiteseToSave, listHabiteseArea, habitese.getCnpjCpfDocumento(), dadosAlvara);
            String xmlToSaveAssinado = this.sisObraServiceUtils.getXmlAssinado(xmlToSave, "infHabitese", "Habitese", certificado);
            String xmlRetorno = this.sisObraServiceUtils.enviarLoteXmlReceitaFederal(xmlToSaveAssinado, certificado);
            boolean enviadoComSucesso = this.sisObraServiceUtils.isXMLEnviadoComErro(xmlRetorno) == false;
            this.updateHabiteseWithXml(habiteseToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, Boolean.valueOf(enviadoComSucesso));
            this.gravarHistoricoHabitese(habiteseToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, enviadoComSucesso, user);
        }
    }

    public void deleteAreasHabiteseById(Long idHabitese) {
        this.sisObraHabiteseAreaRepository.deleteByIdHabitese(idHabitese);
    }

    private void gravarHistoricoHabitese(SisObraHabitese habitese, String xml, String xmlAssinado, String xmlRetorno, boolean enviadoComSucesso, UserSecurityDTO user) {
        StatusDocumentos status = StatusDocumentos.ENVIADO_COM_ERRO;
        if (enviadoComSucesso) {
            status = StatusDocumentos.ENVIADO_COM_SUCESSO;
        }
        SisObraHabiteseHistorico sisObraHabiteseHistorico = new SisObraHabiteseHistorico();
        sisObraHabiteseHistorico.setSisObraHabitese(habitese);
        sisObraHabiteseHistorico.setSequencia(this.sisObraHabiteseHistoricoRepository.findMaxSequenciaHistoricoByIdHabitese(habitese.getId()));
        sisObraHabiteseHistorico.setStatusEnvio(status.getDescricao());
        sisObraHabiteseHistorico.setUsuarioEnvio(user.getPreferredUsername());
        sisObraHabiteseHistorico.setDataEnvio(LocalDate.now());
        sisObraHabiteseHistorico.setXmlEnvio(xml.getBytes());
        sisObraHabiteseHistorico.setXmlEnvioAssinado(xmlAssinado.getBytes());
        sisObraHabiteseHistorico.setXmlRetorno(xmlRetorno.getBytes());
        this.sisObraHabiteseHistoricoRepository.save((Object)sisObraHabiteseHistorico);
    }

    public TipoHabitese getTipoHabitese(SisObraHabiteseDTO habitese, SisObraHabiteseDadosAlvaraDTO areaAlvara) {
        Long areaHabitese;
        Long l = areaHabitese = habitese.getAreaTotal() > 0L ? habitese.getAreaTotal() : habitese.getArea();
        if (areaAlvara != null && areaHabitese < areaAlvara.getArea()) {
            return TipoHabitese.PARCIAL;
        }
        return TipoHabitese.TOTAL;
    }

    public SisObraHabiteseDadosAlvaraDTO getDadosAlvaraHabitese(String numeroAlvara, LocalDate dataAlvara) {
        List dadosAlvara = this.sisObraHabiteseRepository.findDadosAlvara(numeroAlvara, dataAlvara);
        if (dadosAlvara == null || dadosAlvara.isEmpty()) {
            throw new EloValidationException("Alv\u00e1ra " + numeroAlvara + " n\u00e3o encontrado para o Habite-se.");
        }
        return (SisObraHabiteseDadosAlvaraDTO)dadosAlvara.get(0);
    }

    private List<SisObraHabiteseArea> gravarDadosArea(Long idHabitese, Long entidade, Long exercicio, Long projeto) {
        List AlvaraAreas = this.sisObraAlvaraAreaRepositoryImpl.getAreaAlvaraByProjeto(entidade, exercicio, projeto);
        ArrayList<SisObraHabiteseArea> listHabiteseArea = new ArrayList<SisObraHabiteseArea>();
        long sequencia = 0L;
        for (SisObraAlvaraAreaDTO alvaraArea : AlvaraAreas) {
            SisObraHabiteseArea sisObraHabiteseArea = new SisObraHabiteseArea();
            sisObraHabiteseArea.setIdHabitese(idHabitese);
            sisObraHabiteseArea.setSequencia(Long.valueOf(sequencia += ACRESCIMO_DE_SEQUENCIA.longValue()));
            sisObraHabiteseArea.setTipo(TipoArea.PRINCIPAL.getFlagDescricao());
            sisObraHabiteseArea.setCategoria(alvaraArea.getCategoria());
            sisObraHabiteseArea.setDestinacao(alvaraArea.getDestinacao());
            sisObraHabiteseArea.setTipoObra(alvaraArea.getTipoObra());
            sisObraHabiteseArea.setArea(Double.valueOf(alvaraArea.getArea()));
            sisObraHabiteseArea.setQtdTotalUnidade(alvaraArea.getQtdeTotalUnidade());
            this.sisObraHabiteseAreaRepository.save((Object)sisObraHabiteseArea);
            listHabiteseArea.add(sisObraHabiteseArea);
        }
        return listHabiteseArea;
    }

    public String getHabiteseXml(SisObraHabitese habitese, List<SisObraHabiteseArea> habiteseAreas, String cnpjCpfDocumento, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        return SisObraHabiteseXmlBuilder.buildXmlHabitese((SisObraHabitese)habitese, habiteseAreas, (String)cnpjCpfDocumento, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara);
    }

    private void updateHabiteseWithXml(SisObraHabitese habitese, String xml, String xmlAssinado, String xmlRetorno, Boolean enviadoComSucesso) {
        habitese.setXmlEnviado(xml.getBytes());
        habitese.setXmlEnviadoAssinado(xmlAssinado.getBytes());
        habitese.setXmlRetorno(xmlRetorno.getBytes());
        habitese.setEnviado(Boolean.TRUE);
        habitese.setEnviadoComSucesso(enviadoComSucesso);
        this.sisObraHabiteseRepository.save((Object)habitese);
    }

    @Generated
    public SisObraHabiteseService(SisObraAlvaraAreaRepositoryImpl sisObraAlvaraAreaRepositoryImpl, SisObraHabiteseRepository sisObraHabiteseRepository, SisObraHabiteseAreaRepository sisObraHabiteseAreaRepository, ContextService contextService, SisObraHabiteseHistoricoRepository sisObraHabiteseHistoricoRepository, SisObraServiceUtils sisObraServiceUtils) {
        this.sisObraAlvaraAreaRepositoryImpl = sisObraAlvaraAreaRepositoryImpl;
        this.sisObraHabiteseRepository = sisObraHabiteseRepository;
        this.sisObraHabiteseAreaRepository = sisObraHabiteseAreaRepository;
        this.contextService = contextService;
        this.sisObraHabiteseHistoricoRepository = sisObraHabiteseHistoricoRepository;
        this.sisObraServiceUtils = sisObraServiceUtils;
    }
}

