/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.tributos.dto.sisobra.wsdl.ObjectFactory;
import br.com.elotech.tributos.dto.sisobra.wsdl.RecepcaoDSM;
import br.com.elotech.tributos.dto.sisobra.wsdl.RecepcaoDSMResponse;
import br.com.elotech.tributos.dto.sisobra.wsdl.RecepcaoLote;
import br.com.elotech.tributos.dto.sisobra.wsdl.RecepcaoLoteResponse;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.HttpsUrlConnectionMessageSender;

@Service
public class SisObraClient {
    private static final Logger log = LoggerFactory.getLogger(SisObraClient.class);
    private static final String CONTEXT_PATH = "br.com.elotech.tributos.dto.sisobra.wsdl";
    private static final String DEFAULT_URL = "https://sisobrapref.receita.economia.gov.br/sisobraprefWS/recepcao";
    private static final String DEFAULT_PROTOCOL = "TLS";

    private WebServiceTemplate getCustomWebServiceTemplate(KeyStore digitalCertificateKeyStore, char[] senhaToken) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            try (InputStream is = new ClassPathResource("RaizBrasileiraV10.cer").getInputStream();){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate caCert = cf.generateCertificate(is);
                trustStore.setCertificateEntry("raiz-servidor", caCert);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager[] trustManagers = tmf.getTrustManagers();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(digitalCertificateKeyStore, senhaToken);
            KeyManager[] keyManagers = kmf.getKeyManagers();
            SSLContext sc = SSLContext.getInstance(DEFAULT_PROTOCOL);
            sc.init(keyManagers, trustManagers, new SecureRandom());
            HttpsUrlConnectionMessageSender messageSender = new HttpsUrlConnectionMessageSender();
            messageSender.setSslSocketFactory(sc.getSocketFactory());
            Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
            marshaller.setContextPath(CONTEXT_PATH);
            WebServiceTemplate webServiceTemplate = new WebServiceTemplate();
            webServiceTemplate.setMessageSender((WebServiceMessageSender)messageSender);
            webServiceTemplate.setDefaultUri(DEFAULT_URL);
            webServiceTemplate.setMarshaller((Marshaller)marshaller);
            webServiceTemplate.setUnmarshaller((Unmarshaller)marshaller);
            log.info("SSL configurado com certificado digital (KeyManager) com sucesso.");
            return webServiceTemplate;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException("Erro ao configurar SSL com certificado digital: ", e);
        }
    }

    public RecepcaoLoteResponse getRecepcaoResponse(String xml, KeyStore keyStore, char[] senhaToken) {
        RecepcaoLote request = new RecepcaoLote();
        request.setXmlEntrada(xml);
        ObjectFactory factory = new ObjectFactory();
        JAXBElement jaxbRequest = factory.createRecepcaoLote(request);
        log.info("Enviando XML ao SisobraPref");
        JAXBElement jaxbResponse = (JAXBElement)this.getCustomWebServiceTemplate(keyStore, senhaToken).marshalSendAndReceive((Object)jaxbRequest);
        return (RecepcaoLoteResponse)jaxbResponse.getValue();
    }

    public RecepcaoDSMResponse getRecepcaoDsmResponse(String xml, KeyStore keyStore, char[] senhaToken) {
        RecepcaoDSM request = new RecepcaoDSM();
        request.setXmlEntrada(xml);
        ObjectFactory factory = new ObjectFactory();
        JAXBElement jaxbRequest = factory.createRecepcaoDSM(request);
        log.info("Enviando XML ao SisobraPref");
        JAXBElement jaxbResponse = (JAXBElement)this.getCustomWebServiceTemplate(keyStore, senhaToken).marshalSendAndReceive((Object)jaxbRequest);
        return (RecepcaoDSMResponse)jaxbResponse.getValue();
    }
}

