/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.domain.sisobra.SisObraAlvara;
import br.com.elotech.tributos.domain.sisobra.SisObraAlvaraArea;
import br.com.elotech.tributos.domain.sisobra.SisObraAlvaraHistorico;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.sisobra.FiltroSisObraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraAreaDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlvaraHistoricoDTO;
import br.com.elotech.tributos.enums.sisobra.StatusDocumentos;
import br.com.elotech.tributos.enums.sisobra.TipoAlvara;
import br.com.elotech.tributos.enums.sisobra.TipoArea;
import br.com.elotech.tributos.enums.sisobra.UnidadeMedida;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraAreaRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraAreaRepositoryImpl;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraHistoricoRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraAlvaraRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.sisobra.SisObraServiceUtils;
import br.com.elotech.tributos.util.sisobra.SisObraAlvaraXmlBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SisObraAlvaraService
extends CrudService<SisObraAlvara, Long> {
    private static final Long ACRESCIMO_DE_SEQUENCIA = 1L;
    private final SisObraAlvaraRepository sisObraAlvaraRepository;
    private final SisObraAlvaraAreaRepository sisObraAlvaraAreaRepository;
    private final SisObraAlvaraAreaRepositoryImpl sisObraAlvaraAreaRepositoryImpl;
    private final ContextService contextService;
    private final SisObraAlvaraHistoricoRepository sisObraAlvaraHistoricoRepository;
    private final SisObraServiceUtils sisObraServiceUtils;

    public Page<SisObraAlvaraDTO> findDocumentoSisObraAlvara(FiltroSisObraDTO filtro, Pageable pageable) {
        List documentos = this.sisObraAlvaraRepository.findDocumentoSisObraAlvara(filtro, pageable);
        return new PageImpl(documentos, pageable, (long)documentos.size());
    }

    public Page<SisObraAlvaraHistoricoDTO> findHistoricoAlvara(Long id, Pageable pageable) {
        List sisObraAlvaraHistorico = this.sisObraAlvaraHistoricoRepository.findByIdAlvara(id, pageable);
        List sisObraAlvaraHistoricoDTO = sisObraAlvaraHistorico.stream().map(SisObraAlvaraHistoricoDTO::from).collect(Collectors.toList());
        return new PageImpl(sisObraAlvaraHistoricoDTO, pageable, (long)pageable.getPageSize());
    }

    public void gravarDados(List<SisObraAlvaraDTO> alvaras, TipoAlvara tipoAlvara, UserSecurityDTO user) {
        Certificado certificado = this.sisObraServiceUtils.getCertificadoByEntidade(this.contextService.getEntidadePrincipal());
        for (SisObraAlvaraDTO alvara : alvaras) {
            List listAlvaraArea = new ArrayList();
            SisObraAlvara alvaraToSave = new SisObraAlvara();
            if (alvara.getIdSisObraAlvara() > 0L) {
                alvaraToSave = (SisObraAlvara)this.sisObraAlvaraRepository.findOne((Object)alvara.getIdSisObraAlvara());
                this.deleteAreasByIdAlvara(alvara.getIdSisObraAlvara());
            }
            alvaraToSave.setNumeroAlvara(String.valueOf(alvara.getDocumento()));
            if (tipoAlvara.equals((Object)TipoAlvara.INICIAL)) {
                alvaraToSave.setNumeroProtocoloAnterior(null);
                alvaraToSave.setTipoAlvara(TipoAlvara.INICIAL.getId());
            }
            alvaraToSave.setNomeObra(alvara.getObraNome());
            alvaraToSave.setDataAlvara(alvara.getDataEmissao());
            alvaraToSave.setDataInicioObra(alvara.getDataInicio());
            alvaraToSave.setDataFinalObra(alvara.getDataEncerramento());
            alvaraToSave.setProprietarioImovel(alvara.getProprietarioImovel());
            alvaraToSave.setTipoVinculo(alvara.getTipoVinculo());
            alvaraToSave.setCnpjDonoObra(alvara.getCnpjDonoObra());
            alvaraToSave.setCpfDonoObra(alvara.getCpfDonoObra());
            alvaraToSave.setCnpjIncorporadorConcivil(alvara.getCnpjIncorporadora());
            alvaraToSave.setCpfIncorporadorConcivil(alvara.getCpfIncorporadora());
            alvaraToSave.setCnpjEmpresaConstrutora(alvara.getCpnjConstrutora());
            alvaraToSave.setObraCep(alvara.getObraCEP());
            alvaraToSave.setObraTipoLogradouro(alvara.getObraTipoLogradouro());
            alvaraToSave.setObraLogradouro(alvara.getObraLogradouro());
            alvaraToSave.setObraNumero(alvara.getObraNumero());
            alvaraToSave.setObraComplemento(alvara.getObraComplemento());
            alvaraToSave.setObraBairro(alvara.getObraBairro());
            alvaraToSave.setUnidadeMedida(UnidadeMedida.M2.getId());
            alvaraToSave.setCpfProprietarioObra(alvara.getCpfProprietarioObra());
            alvaraToSave.setCnpjProprietarioObra(alvara.getCnpjProprietarioObra());
            alvaraToSave.setNumeroProcesso(alvara.getNumeroProcesso());
            alvaraToSave.setRespTecnicoNomeEngenheiro(alvara.getNomeEngenheiroRespExec());
            alvaraToSave.setRespTecnicoCreaEngenheiro(alvara.getCreaEngenheiroRespExec());
            alvaraToSave.setRespTecnicoNumeroArt(alvara.getArtEngenheiro());
            alvaraToSave.setRespTecnicoNomeArquiteto(alvara.getNomeArquitetoRespExec());
            alvaraToSave.setRespTecnicoCauArquiteto(alvara.getCauArquitetoRespExec());
            alvaraToSave.setRespTecnicoNumeroRrt(alvara.getRrtArquiteto());
            alvaraToSave.setRespProjNomeEngenheiro(alvara.getNomeEngenheiroRespProj());
            alvaraToSave.setRespProjCreaEngenheiro(alvara.getCreaEngenheiroRespProj());
            alvaraToSave.setRespProjNumeroArt(alvara.getArtEngenheiro());
            alvaraToSave.setRespProjNomeArquiteto(alvara.getNomeArquitetoRespProj());
            alvaraToSave.setRespProjCauArquiteto(alvara.getCauArquitetoRespProj());
            alvaraToSave.setRespProjNumeroRrt(alvara.getRrtArquiteto());
            alvaraToSave.setTipoDocumento(alvara.getTipoDocumento());
            alvaraToSave.setIdSisobraAlvara(alvara.getExercicioDocumento() + String.format("%04d", alvara.getTipoDocumento()) + String.format("%06d", alvara.getDocumento()));
            alvaraToSave.setTipoRespExec(alvara.getTipoRespExec());
            alvaraToSave.setTipoRespProjeto(alvara.getTipoRespProjeto());
            alvaraToSave.setRespTecnicoNumeroTrt(alvara.getTrtTecnicoInd());
            this.sisObraAlvaraRepository.save((Object)alvaraToSave);
            listAlvaraArea = this.gravarDadosArea(alvaraToSave.getId(), this.contextService.getEntidadePrincipal(), alvara.getExercicioProjeto(), alvara.getProjeto());
            String xmlToSave = this.getAlvaraXml(alvaraToSave, listAlvaraArea);
            String xmlToSaveAssinado = this.sisObraServiceUtils.getXmlAssinado(xmlToSave, "infAlvara", "Alvara", certificado);
            String xmlRetorno = this.sisObraServiceUtils.enviarLoteXmlReceitaFederal(xmlToSaveAssinado, certificado);
            boolean enviadoComSucesso = this.sisObraServiceUtils.isXMLEnviadoComErro(xmlRetorno) == false;
            this.updateAlvaraWithXml(alvaraToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, Boolean.valueOf(enviadoComSucesso));
            this.gravarHistoricoAlvara(alvaraToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, enviadoComSucesso, user);
        }
    }

    private void deleteAreasByIdAlvara(Long idAlvara) {
        this.sisObraAlvaraAreaRepository.deleteByIdAlvara(idAlvara);
    }

    public List<SisObraAlvaraArea> gravarDadosArea(Long idAlvara, Long entidade, Long exercicio, Long projeto) {
        List alvaraAreas = this.sisObraAlvaraAreaRepositoryImpl.getAreaAlvaraByProjeto(entidade, exercicio, projeto);
        ArrayList<SisObraAlvaraArea> listAlvaraArea = new ArrayList<SisObraAlvaraArea>();
        long sequencia = 0L;
        for (SisObraAlvaraAreaDTO alvaraArea : alvaraAreas) {
            SisObraAlvaraArea sisObraAlvaraArea = new SisObraAlvaraArea();
            sisObraAlvaraArea.setIdAlvara(idAlvara);
            sisObraAlvaraArea.setSequencia(Long.valueOf(sequencia += ACRESCIMO_DE_SEQUENCIA.longValue()));
            sisObraAlvaraArea.setTipo(TipoArea.PRINCIPAL.getFlagDescricao());
            sisObraAlvaraArea.setCategoria(alvaraArea.getCategoria());
            sisObraAlvaraArea.setDestinacao(alvaraArea.getDestinacao());
            sisObraAlvaraArea.setTipoObra(alvaraArea.getTipoObra());
            sisObraAlvaraArea.setArea(alvaraArea.getArea());
            sisObraAlvaraArea.setQtdTotalUnidade(alvaraArea.getQtdeTotalUnidade());
            this.sisObraAlvaraAreaRepository.save((Object)sisObraAlvaraArea);
            listAlvaraArea.add(sisObraAlvaraArea);
        }
        return listAlvaraArea;
    }

    private void updateAlvaraWithXml(SisObraAlvara alvara, String xml, String xmlAssinado, String xmlRetorno, Boolean enviadoComSucesso) {
        alvara.setXmlEnviado(xml.getBytes());
        alvara.setXmlEnviadoAssinado(xmlAssinado.getBytes());
        alvara.setXmlRetorno(xmlRetorno.getBytes());
        alvara.setEnviado(Boolean.TRUE);
        alvara.setEnviadoComSucesso(enviadoComSucesso);
        this.sisObraAlvaraRepository.save((Object)alvara);
    }

    private void gravarHistoricoAlvara(SisObraAlvara alvara, String xml, String xmlAssinado, String xmlRetorno, boolean enviadoComSucesso, UserSecurityDTO user) {
        StatusDocumentos status = StatusDocumentos.ENVIADO_COM_ERRO;
        if (enviadoComSucesso) {
            status = StatusDocumentos.ENVIADO_COM_SUCESSO;
        }
        SisObraAlvaraHistorico sisObraAlvaraHistorico = new SisObraAlvaraHistorico();
        sisObraAlvaraHistorico.setSisObraAlvara(alvara);
        sisObraAlvaraHistorico.setSequencia(this.sisObraAlvaraHistoricoRepository.findMaxSequenciaHistoricoByIdAlvara(alvara.getId()));
        sisObraAlvaraHistorico.setStatusEnvio(status.getDescricao());
        sisObraAlvaraHistorico.setUsuarioEnvio(user.getPreferredUsername());
        sisObraAlvaraHistorico.setDataEnvio(LocalDate.now());
        sisObraAlvaraHistorico.setXmlEnvio(xml.getBytes());
        sisObraAlvaraHistorico.setXmlEnvioAssinado(xmlAssinado.getBytes());
        sisObraAlvaraHistorico.setXmlRetorno(xmlRetorno.getBytes());
        this.sisObraAlvaraHistoricoRepository.save((Object)sisObraAlvaraHistorico);
    }

    public String getAlvaraXml(SisObraAlvara alvara, List<SisObraAlvaraArea> alvaraArea) {
        return SisObraAlvaraXmlBuilder.buildXmlAlvara((SisObraAlvara)alvara, alvaraArea);
    }

    @Generated
    public SisObraAlvaraService(SisObraAlvaraRepository sisObraAlvaraRepository, SisObraAlvaraAreaRepository sisObraAlvaraAreaRepository, SisObraAlvaraAreaRepositoryImpl sisObraAlvaraAreaRepositoryImpl, ContextService contextService, SisObraAlvaraHistoricoRepository sisObraAlvaraHistoricoRepository, SisObraServiceUtils sisObraServiceUtils) {
        this.sisObraAlvaraRepository = sisObraAlvaraRepository;
        this.sisObraAlvaraAreaRepository = sisObraAlvaraAreaRepository;
        this.sisObraAlvaraAreaRepositoryImpl = sisObraAlvaraAreaRepositoryImpl;
        this.contextService = contextService;
        this.sisObraAlvaraHistoricoRepository = sisObraAlvaraHistoricoRepository;
        this.sisObraServiceUtils = sisObraServiceUtils;
    }
}

