/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sisobra;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.domain.sisobra.SisObraAlteraSituacaoHistorico;
import br.com.elotech.tributos.domain.sisobra.SisObraAlteracaoSituacao;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.sisobra.FiltroSisObraDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlteraSituacaoDTO;
import br.com.elotech.tributos.dto.sisobra.SisObraAlteraSituacaoHistoricoDTO;
import br.com.elotech.tributos.enums.sisobra.SituacaoDocumento;
import br.com.elotech.tributos.enums.sisobra.StatusDocumentos;
import br.com.elotech.tributos.repository.sisobra.SisObraAlteraSituacaoHistoricoRepository;
import br.com.elotech.tributos.repository.sisobra.SisObraAlteracaoSituacaoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.sisobra.SisObraServiceUtils;
import br.com.elotech.tributos.util.sisobra.SisObraAlteraSituacaoXmlBuilder;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SisObraAlteraSituacaoService
extends CrudService<SisObraAlteracaoSituacao, Long> {
    private final SisObraAlteracaoSituacaoRepository sisObraAlteracaoSituacaoRepository;
    private final ContextService contextService;
    private final SisObraAlteraSituacaoHistoricoRepository sisObraAlteraSituacaoHistoricoRepository;
    private final SisObraServiceUtils sisObraServiceUtils;

    public Page<SisObraAlteraSituacaoDTO> findDocumentoSisObraAlteraSituacao(FiltroSisObraDTO filtro, Pageable pageable) {
        List documentos = this.sisObraAlteracaoSituacaoRepository.findDocumentoSisObraCancelamento(filtro, pageable);
        return new PageImpl(documentos, pageable, (long)documentos.size());
    }

    public void gravarDados(List<SisObraAlteraSituacaoDTO> documentos, UserSecurityDTO user) {
        Certificado certificado = this.sisObraServiceUtils.getCertificadoByEntidade(this.contextService.getEntidadePrincipal());
        for (SisObraAlteraSituacaoDTO documento : documentos) {
            SisObraAlteracaoSituacao documentoToSave = new SisObraAlteracaoSituacao();
            if (documento.getIdAlteraSituacao() > 0L) {
                documentoToSave = (SisObraAlteracaoSituacao)this.sisObraAlteracaoSituacaoRepository.findOne((Object)documento.getIdAlteraSituacao());
            }
            documentoToSave.setTipoDocumentoOriginal(documento.getTipoDocumento());
            documentoToSave.setTipoDocumento(documento.getTipoDocumentoAlteracao());
            documentoToSave.setNumeroDocumento(String.valueOf(documento.getDocumento()));
            documentoToSave.setDataDocumento(documento.getDataDocumento());
            documentoToSave.setDataCancelamento(documento.getDataCancelamento());
            documentoToSave.setNumeroProtocoloEnvio(this.getNumeroProtocolo(documento));
            documentoToSave.setSituacaoAlteracao(SituacaoDocumento.CANCELADO.getId());
            documentoToSave.setAno(documento.getAnoDocumento());
            documentoToSave.setMes(documento.getMesDocumento());
            this.sisObraAlteracaoSituacaoRepository.save((Object)documentoToSave);
            String xmlToSave = this.getAlteracaoSituacaoXml(documentoToSave);
            String xmlToSaveAssinado = this.sisObraServiceUtils.getXmlAssinado(xmlToSave, "infDocumento", "AlteraSituacao", certificado);
            String xmlRetorno = this.sisObraServiceUtils.enviarLoteXmlReceitaFederal(xmlToSaveAssinado, certificado);
            boolean enviadoComSucesso = this.sisObraServiceUtils.isXMLEnviadoComErro(xmlRetorno) == false;
            this.updateAlteracaoSituacaoWithXml(documentoToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, Boolean.valueOf(enviadoComSucesso));
            this.gravarHistoricoAlteraSituacao(documentoToSave, xmlToSave, xmlToSaveAssinado, xmlRetorno, enviadoComSucesso, user);
        }
    }

    public void gravarHistoricoAlteraSituacao(SisObraAlteracaoSituacao alteraSituacao, String xml, String xmlAssinado, String xmlRetorno, boolean enviadoComSucesso, UserSecurityDTO user) {
        StatusDocumentos status = StatusDocumentos.ENVIADO_COM_ERRO;
        if (enviadoComSucesso) {
            status = StatusDocumentos.ENVIADO_COM_SUCESSO;
        }
        SisObraAlteraSituacaoHistorico sisObraAlteraSituacaoHistorico = new SisObraAlteraSituacaoHistorico();
        sisObraAlteraSituacaoHistorico.setSisObraAlteracaoSituacao(alteraSituacao);
        sisObraAlteraSituacaoHistorico.setSequencia(this.sisObraAlteraSituacaoHistoricoRepository.findMaxSequenciaHistoricoByIdAlteraSituacao(alteraSituacao.getId()));
        sisObraAlteraSituacaoHistorico.setStatusEnvio(status.getDescricao());
        sisObraAlteraSituacaoHistorico.setUsuarioEnvio(user.getPreferredUsername());
        sisObraAlteraSituacaoHistorico.setDataEnvio(LocalDate.now());
        sisObraAlteraSituacaoHistorico.setXmlEnvio(xml.getBytes());
        sisObraAlteraSituacaoHistorico.setXmlEnvioAssinado(xmlAssinado.getBytes());
        sisObraAlteraSituacaoHistorico.setXmlRetorno(xmlRetorno.getBytes());
        this.sisObraAlteraSituacaoHistoricoRepository.save((Object)sisObraAlteraSituacaoHistorico);
    }

    public Page<SisObraAlteraSituacaoHistoricoDTO> findHistoricoAlteraSituacao(Long id, Pageable pageable) {
        List sisObraAlteraSituacaoHistorico = this.sisObraAlteraSituacaoHistoricoRepository.findByIdAlteraSituacao(id, pageable);
        List sisObraAlteraSituacaoHistoricoDTO = sisObraAlteraSituacaoHistorico.stream().map(SisObraAlteraSituacaoHistoricoDTO::from).collect(Collectors.toList());
        return new PageImpl(sisObraAlteraSituacaoHistoricoDTO, pageable, (long)pageable.getPageSize());
    }

    public String getNumeroProtocolo(SisObraAlteraSituacaoDTO documento) {
        if (documento.getNumeroProtocoloAlvara() != null && !documento.getNumeroProtocoloAlvara().isEmpty()) {
            return documento.getNumeroProtocoloAlvara();
        }
        if (documento.getNumeroProtocoloHabitese() != null && !documento.getNumeroProtocoloHabitese().isEmpty()) {
            return documento.getNumeroProtocoloHabitese();
        }
        return "";
    }

    private void updateAlteracaoSituacaoWithXml(SisObraAlteracaoSituacao documento, String xml, String xmlAssinado, String xmlRetorno, Boolean enviadoComSucesso) {
        documento.setXmlEnviado(xml.getBytes());
        documento.setXmlEnviadoAssinado(xmlAssinado.getBytes());
        documento.setXmlRetorno(xmlRetorno.getBytes());
        documento.setEnviado(Boolean.TRUE);
        documento.setEnviadoComSucesso(enviadoComSucesso);
        this.sisObraAlteracaoSituacaoRepository.save((Object)documento);
    }

    public String getAlteracaoSituacaoXml(SisObraAlteracaoSituacao documento) {
        return SisObraAlteraSituacaoXmlBuilder.buildXmlAlteraSituacao((SisObraAlteracaoSituacao)documento);
    }

    @Generated
    public SisObraAlteraSituacaoService(SisObraAlteracaoSituacaoRepository sisObraAlteracaoSituacaoRepository, ContextService contextService, SisObraAlteraSituacaoHistoricoRepository sisObraAlteraSituacaoHistoricoRepository, SisObraServiceUtils sisObraServiceUtils) {
        this.sisObraAlteracaoSituacaoRepository = sisObraAlteracaoSituacaoRepository;
        this.contextService = contextService;
        this.sisObraAlteraSituacaoHistoricoRepository = sisObraAlteraSituacaoHistoricoRepository;
        this.sisObraServiceUtils = sisObraServiceUtils;
    }
}

