/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.ArrecadacaoCreditoValidacao;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class ArrecadacaoCreditoValidacaoSimAmService {
    public List<ErrosImportacaoSIMAM> validaArrecadacao(ArrecadacaoCreditoValidacao arrecadacao, StepExecution stepExecution) {
        ArrayList<ErrosImportacaoSIMAM> erros = new ArrayList<ErrosImportacaoSIMAM>();
        arrecadacao.loadInformacoesAdicionais();
        LocalDate datatrabalho = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobParameters().getDate("dataFinal")));
        this.validaSeTemNrArrecadacaoDuplicado(arrecadacao, erros);
        this.validaAOrigemDaReceita(arrecadacao, erros);
        this.validaLancamentoDoCreditoParaArrecadacao(arrecadacao, erros);
        this.validaInscricaoEmDividaAtivaParaArrecadacao(arrecadacao, erros);
        this.validaTipoDaArrecadacao(arrecadacao, erros);
        this.validaSeAArrecadacaoEDoMesEAnoDeTrabalho(arrecadacao, erros, datatrabalho);
        this.validaSeOValorArrecadadoEPositivo(arrecadacao, erros);
        this.validaSeArrecadacaoDeCreditoDoExercicio(arrecadacao, erros);
        this.validaSeArrecadacaoDeCreditoEmDividaAtiva(arrecadacao, erros);
        this.validaSeArrecadacaoDoExercicioOuDividaAtiva(arrecadacao, erros);
        this.validaSeArrecadacaoEstaDuplicada(arrecadacao, erros);
        this.validaSeArrecadacaoDoAnoDoCredito(arrecadacao, erros);
        return erros;
    }

    private void validaSeTemNrArrecadacaoDuplicado(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (arrecadacao.isDuplicado()) {
            String message = "O conjunto (nrArrecadacao e nrAnoArrecadacao) declarado na tabela (ArrecadacaoCredito) apresenta-se com registro duplicado.";
            Long codigoErro = 2103L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaAOrigemDaReceita(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isTipoOrigemReceitaValida()) {
            String message = "O Tipo de Origem de Receita (idTipoOrigemReceita) declarado na tabela (ArrecadacaoCredito) n\u00e3o existe na tabela (TipoOrigemReceita).";
            Long codigoErro = 2104L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaLancamentoDoCreditoParaArrecadacao(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isLancamentoParaArrecadacaoValida()) {
            String message = "O c\u00f3digo e ano do cr\u00e9dito (nrCredito e nrAnoCredito) declarado na tabela (ArrecadacaoCredito) deve existir na tabela (LancamentoCredito).";
            Long codigoErro = 2105L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaInscricaoEmDividaAtivaParaArrecadacao(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isInscricaoDividaAtivaParaArrecadacaoValida()) {
            String message = "O c\u00f3digo e ano do cr\u00e9dito (nrDivida e nrAnoDivida) declarado na  tabela (ArrecadacaoCredito) deve existir na tabela (InscricaoDividaAtiva).";
            Long codigoErro = 2106L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaTipoDaArrecadacao(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isTipoArrecadacaoValida()) {
            String message = "O Tipo de Arrecada\u00e7\u00e3o (idTipoArrecadacao) declarado na tabela (ArrecadacaoCredito) n\u00e3o existe na tabela (TipoArrecadacao).";
            Long codigoErro = 2107L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeAArrecadacaoEDoMesEAnoDeTrabalho(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros, LocalDate dataTrabalho) {
        if (!arrecadacao.isArrecadacaoDoAnoEMesDeTrabalho(dataTrabalho)) {
            String message = "O M\u00eas e Ano declarado na  tabela (ArrecadacaoCredito) n\u00e3o pode ser maior que o m\u00eas/ano de trabalho.";
            Long codigoErro = 2108L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeOValorArrecadadoEPositivo(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isValorArrecadacaoPositiva()) {
            String message = "O valor da arrecada\u00e7\u00e3o (vlArrecadacao) declarado na tabela (ArrecadacaoCredito) n\u00e3o pode ser negativo.";
            Long codigoErro = 2109L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeArrecadacaoDeCreditoDoExercicio(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isArrecadacaoDeLancamentoDoExercicio()) {
            String message = "O c\u00f3digo do tipo de origem de receita (idTipoOrigemReceita) informado na tabela (ArrecadacaoCredito) \u00e9 = 1 - Origin\u00e1ria de Cr\u00e9dito n\u00e3o Inscrito em D\u00edvida Ativa, portanto, o valor dos campos (nrDivida e nrAnoDivida) deve ser vazio e os campos (nrCredito e nrAnoCredito) devem conter dados.";
            Long codigoErro = 2124L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeArrecadacaoDeCreditoEmDividaAtiva(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isArreacadacaoDeInscricaoEmDividaAtiva()) {
            String message = "O c\u00f3digo do tipo de origem de receita (idTipoOrigemReceita) informado na tabela (ArrecadacaoCredito) \u00e9 = 2 - Origin\u00e1ria de D\u00edvida Ativa, portanto, o valor dos campos (nrCredito e nrAnoCredito) deve ser vazio e os campos (nrDivida e nrAnoDivida) devem conter dados. ";
            Long codigoErro = 2125L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeArrecadacaoDoExercicioOuDividaAtiva(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isArrecadacaoDeLancamentoDoExercicioOuDividaAtiva()) {
            String message = "O tipo de origem de receita (idTipoOrigemReceita) informado na tabela (ArrecadacaoCredito), deve ser 1 ou 2.";
            Long codigoErro = 2126L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeArrecadacaoEstaDuplicada(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (arrecadacao.isArrecadacaoDuplicado()) {
            String message = "O registro declarado na tabela (ArrecadacaoCredito) para o conjunto (nrAnoArrecadacao, idTipoOrigemReceita, nrCredito, nrAnoCredito, nrDivida, nrAnoDivida, idTipoArrecadacao, nrMes e nrAno) n\u00e3o pode ser duplicado.";
            Long codigoErro = 2127L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeArrecadacaoDoAnoDoCredito(ArrecadacaoCreditoValidacao arrecadacao, List<ErrosImportacaoSIMAM> erros) {
        if (!arrecadacao.isArrecadacaoELancamentoDeCreditoDoAnoDeTrabalho()) {
            String message = "O registro declarado na tabela (ArrecadacaoCredito) n\u00e3o pode estar vinculado com ano de d\u00edvida (nrAnoDivida) ou ano de cr\u00e9dito (nrAnoCredito) menor que o exerc\u00edcio financeiro de 2023";
            Long codigoErro = 2253L;
            erros.add(ErrosImportacaoSIMAM.arrecadacao((ArrecadacaoCreditoValidacao)arrecadacao, (String)message, (Long)codigoErro));
        }
    }
}

