/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.ArrecadacaoTipoCreditoMaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.AtualizacaoMonetariaCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.BaseArquivoSimAmDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.DeducaoCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.NrDisponivel;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.simam.NrDividaCustomRepository;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.AtribuirNrDividaService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmFactory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class AtribuirNrDividaService {
    private static final Logger log = LoggerFactory.getLogger(AtribuirNrDividaService.class);
    private final ManutencaoArquivoSimAmFactory manutencaoArquivoSimAmFactory;
    private final NrDividaCustomRepository repository;

    public void atribuirNrDivida(BaseArquivoSimAmDTO registro) {
        this.manutencaoArquivoSimAmFactory.getService(registro.getTipoRegistroSimAm()).updateAll(List.of(this.findAndSetNrDivida(registro)));
    }

    public BaseArquivoSimAmDTO findAndSetNrDivida(BaseArquivoSimAmDTO registro) {
        try {
            switch (1.$SwitchMap$br$com$elotech$tributos$enums$TipoRegistroSimAm[registro.getTipoRegistroSimAm().ordinal()]) {
                case 1: {
                    return this.updateNrDivida((AtualizacaoMonetariaCreditoDividaAtivaMaDTO)registro);
                }
                case 2: {
                    return this.updateNrDivida((DeducaoCreditoDividaAtivaMaDTO)registro);
                }
                case 3: {
                    return this.updateNrDivida((ArrecadacaoTipoCreditoMaDTO)registro);
                }
            }
            throw new RestException(HttpStatus.NOT_IMPLEMENTED, "Tipo de registro n\u00e3o suportado para atribui\u00e7\u00e3o de NrDivida");
        }
        catch (Exception e) {
            log.error("N\u00e3o foi gerado atribui\u00e7\u00e3o para o registro {}", (Object)registro, (Object)e);
            return registro;
        }
    }

    private BaseArquivoSimAmDTO updateNrDivida(AtualizacaoMonetariaCreditoDividaAtivaMaDTO registro) {
        List existentes = this.findNrDividasExistentes(registro.getTipoRegistroSimAm(), registro.getIdTipoCredito(), registro.getDtAtualizacao());
        NrDisponivel novo = this.getNewNrDivida(registro.getTipoRegistroSimAm(), existentes, registro.getVlAtualizacao());
        registro.setNrDivida(novo.getNr());
        registro.setNrAnoDivida(novo.getNrAno());
        return registro;
    }

    private BaseArquivoSimAmDTO updateNrDivida(DeducaoCreditoDividaAtivaMaDTO registro) {
        List existentes = this.findNrDividasExistentes(registro.getTipoRegistroSimAm(), registro.getIdTipoCredito(), registro.getDtDeducao());
        NrDisponivel novo = this.getNewNrDivida(registro.getTipoRegistroSimAm(), existentes, registro.getVlDeducao());
        registro.setNrDivida(novo.getNr());
        registro.setNrAnoDivida(novo.getNrAno());
        return registro;
    }

    private BaseArquivoSimAmDTO updateNrDivida(ArrecadacaoTipoCreditoMaDTO registro) {
        LocalDate dataReferencia = LocalDate.of(registro.getNrAno().intValue(), registro.getNrMes().intValue(), 1).with(TemporalAdjusters.lastDayOfMonth());
        List existentes = this.findNrDividasExistentes(registro.getTipoRegistroSimAm(), registro.getIdTipoCredito(), dataReferencia);
        NrDisponivel novo = this.getNewNrDivida(registro.getTipoRegistroSimAm(), existentes, registro.getValorArrecadacao());
        registro.setNrDivida(novo.getNr());
        registro.setNrAnoDivida(novo.getNrAno());
        return registro;
    }

    private List<NrDisponivel> findNrDividasExistentes(TipoRegistroSimAm tipoRegistroSimAm, Long idTipoCredito, LocalDate dataReferencia) {
        return this.repository.findExistentes(tipoRegistroSimAm, idTipoCredito, dataReferencia);
    }

    private NrDisponivel getNewNrDivida(TipoRegistroSimAm tipoRegistroSimAm, List<NrDisponivel> rows, BigDecimal valor) {
        if (rows.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrado nrDivida para a opera\u00e7\u00e3o");
        }
        return rows.stream().filter(row -> !tipoRegistroSimAm.equals((Object)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA) || row.getValorSoma().compareTo(valor) > 0).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado nrDivida disponivel"));
    }

    @Generated
    public AtribuirNrDividaService(ManutencaoArquivoSimAmFactory manutencaoArquivoSimAmFactory, NrDividaCustomRepository repository) {
        this.manutencaoArquivoSimAmFactory = manutencaoArquivoSimAmFactory;
        this.repository = repository;
    }
}

