/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoDeducaoCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EstornoDeducaoCreditoDAMaService
implements ManutencaoArquivoSimAmService<EstornoDeducaoCreditoDividaAtivaMaDTO> {
    private final EntityManager entityManager;
    private final EstornoDeducaoCreditoDividaAtivaRepository estornoDeducaoCreditoDividaAtivaRepository;
    private final ContextService contextService;
    private final DeducaoCreditoDividaAtivaRepository deducaoCreditoDARepository;
    private final AtoRepository atoRepository;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA;
    }

    public Page<EstornoDeducaoCreditoDividaAtivaMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtEstorno"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.estornoDeducaoCreditoDividaAtivaRepository.findAll(specification, pageable).map(EstornoDeducaoCreditoDividaAtivaMaDTO::from);
    }

    public List<EstornoDeducaoCreditoDividaAtivaMaDTO> updateAll(List<EstornoDeducaoCreditoDividaAtivaMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(EstornoDeducaoCreditoDividaAtivaMaDTO::hasError).collect(Collectors.toList());
        }
        this.estornoDeducaoCreditoDividaAtivaRepository.saveAll((Iterable)arquivos.stream().map(EstornoDeducaoCreditoDividaAtivaMaDTO::toDeducaoCredito).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<EstornoDeducaoCreditoDividaAtivaMaDTO> estornoDeducaoCredito) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return estornoDeducaoCredito.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaNrDeducao(current);
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaNrDeducao(EstornoDeducaoCreditoDividaAtivaMaDTO estornoDeducaoCreditoDA) {
        if (!this.deducaoCreditoDARepository.existsByNrDeducaoAndNrAnoDeducao(estornoDeducaoCreditoDA.getNrDeducao(), estornoDeducaoCreditoDA.getNrAnoDeducao()).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrado registro de Dedu\u00e7\u00e3o de cr\u00e9dito em Divida Ativa com a chave NrDeducao/NrAnoDeducao com os valores %s/%s.", estornoDeducaoCreditoDA.getNrDeducao(), estornoDeducaoCreditoDA.getNrAnoDeducao()));
        }
    }

    private void validaCdControleLeiAto(EstornoDeducaoCreditoDividaAtivaMaDTO arrecadacaoTipoCredito, Long entidade) {
        Optional<Long> idAto = this.atoRepository.findByIdAto(entidade, arrecadacaoTipoCredito.getCdControleLeiAto()).map(Ato::getIdAto);
        if (idAto.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela EstornoDeducaoCreditoDA n\u00e3o est\u00e1 presente na tabela CgAto.", arrecadacaoTipoCredito.getCdControleLeiAto(), arrecadacaoTipoCredito.getId()));
        }
    }

    @Generated
    public EstornoDeducaoCreditoDAMaService(EntityManager entityManager, EstornoDeducaoCreditoDividaAtivaRepository estornoDeducaoCreditoDividaAtivaRepository, ContextService contextService, DeducaoCreditoDividaAtivaRepository deducaoCreditoDARepository, AtoRepository atoRepository) {
        this.entityManager = entityManager;
        this.estornoDeducaoCreditoDividaAtivaRepository = estornoDeducaoCreditoDividaAtivaRepository;
        this.contextService = contextService;
        this.deducaoCreditoDARepository = deducaoCreditoDARepository;
        this.atoRepository = atoRepository;
    }
}

