/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import java.time.LocalDateTime;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProcessamentoSaneparJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job processamentoSaneparJob;

    public ProcessamentoSaneparJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="processamentoSaneparBatchJob") Job processamentoSaneparJob) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.processamentoSaneparJob = processamentoSaneparJob;
    }

    public JobExecution startJob(Long idBaixaSanepar) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.validate(idBaixaSanepar);
        JobParametersBuilder parametersBuilder = new JobParametersBuilder();
        parametersBuilder.addLong("idBaixa", idBaixaSanepar);
        parametersBuilder.addString("when", LocalDateTime.now().toString());
        return this.jobLauncher.run(this.processamentoSaneparJob, parametersBuilder.toJobParameters());
    }

    private void validate(Long idBaixaSanepar) {
        this.validaSeTemVerificacaoExecutando(idBaixaSanepar);
        this.validaSeTemJobRodandoComParametro(idBaixaSanepar);
    }

    private void validaSeTemJobRodandoComParametro(Long idBaixa) {
        boolean exists = this.jobExplorer.findRunningJobExecutions(JobType.PROCESSAMENTO_ARQUIVO_BAIXA_SANEPAR.getTipo()).stream().anyMatch(jobExecution -> {
            Long idBaixaParameterRunning = jobExecution.getJobParameters().getLong("idBaixa");
            return idBaixa.equals(idBaixaParameterRunning);
        });
        if (exists) {
            throw new EloValidationException("Esse lote j\u00e1 est\u00e1 sendo processado");
        }
    }

    private void validaSeTemVerificacaoExecutando(Long idBaixa) {
        boolean exists = this.jobExplorer.findRunningJobExecutions(JobType.VERIFICACAO_ARQUIVO_BAIXA_SANEPAR.getTipo()).stream().anyMatch(jobExecution -> {
            Long idBaixaParameterRunning = jobExecution.getJobParameters().getLong("idBaixa");
            return idBaixa.equals(idBaixaParameterRunning);
        });
        if (exists) {
            throw new EloValidationException("N\u00e3o ser\u00e1 poss\u00edvel processar os itens pois est\u00e1 sendo executado a a verifica\u00e7\u00e3o dos itens importados");
        }
    }
}

