/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rocada;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.jpa.support.EloSequenceCache;
import br.com.elotech.core.jpa.support.EloSequenceGenerator;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.calculo.domain.Operador;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteFiltroDTO;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.rocada.Rocada;
import br.com.elotech.tributos.domain.rocada.RocadaCadastro;
import br.com.elotech.tributos.domain.rocada.RocadaCadastroId;
import br.com.elotech.tributos.domain.rocada.RocadaCadastroTipo;
import br.com.elotech.tributos.domain.rocada.RocadaCadastroTipoId;
import br.com.elotech.tributos.domain.rocada.RocadaId;
import br.com.elotech.tributos.domain.rocada.TipoRocada;
import br.com.elotech.tributos.domain.rocada.TipoRocadaId;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.CadastroGeralResponseDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.GerarParcelasDebitoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.comunicado.GerarComunicadoRequest;
import br.com.elotech.tributos.dto.rocada.GerarComunicadoRocadaRequestDTO;
import br.com.elotech.tributos.dto.rocada.RocadaCadastroDTO;
import br.com.elotech.tributos.dto.rocada.RocadaDTO;
import br.com.elotech.tributos.dto.rocada.RocadaResumoImobiliarioDTO;
import br.com.elotech.tributos.dto.rocada.TipoRocadaDTO;
import br.com.elotech.tributos.enums.comunicado.TipoComunicadoGeracaoManual;
import br.com.elotech.tributos.enums.rocada.TipoAtualizacaoResumoImobiliarioRocada;
import br.com.elotech.tributos.enums.rocada.TipoTerrenoRocada;
import br.com.elotech.tributos.enums.rocada.TipoUnidadeMedidaRocada;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.rocada.TipoRocadaService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RocadaService
extends CrudService<Rocada, RocadaId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocadaService.class);
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private final ContextService contextService;
    private final EloSequenceCache eloSequenceCache;
    private final TipoRocadaService tipoRocadaService;
    private final GeraDebitoService geraDebitoService;
    private final GeraBoletoService geraBoletoService;
    private final FormaCorrecaoService formaCorrecaoService;
    private final DebitoService debitoService;
    private final ModeloBoletoService modeloBoletoService;
    private final EntityManager entityManager;
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private static final Map<NotificationStatus, String> messagesNotificacao = Map.of(NotificationStatus.STARTED, "Iniciado gera\u00e7\u00e3o de d\u00e9bito da ro\u00e7ada", NotificationStatus.COMPLETED, "Conclu\u00eddo gera\u00e7\u00e3o de d\u00e9bito da ro\u00e7ada", NotificationStatus.FAILED, "Gera\u00e7\u00e3o de d\u00e9bito da ro\u00e7ada falhou");
    private static final String TABLE_ROCADA = "TRIBROCADA";
    private static final String TABLE_BLOQUETO = "TRIBBLOQUETO";

    protected void beforeSave(Rocada entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        Long entidade = Optional.ofNullable(entity.getId()).map(RocadaId::getEntidade).orElseGet(() -> ((ContextService)this.contextService).getEntidadePrincipal());
        Long exercicio = Optional.ofNullable(entity.getId()).map(RocadaId::getExercicio).orElseGet(() -> ((ContextService)this.contextService).getExercicioAtual());
        entity.setUsuario(Optional.ofNullable(entity.getUsuario()).orElseGet(SecurityUtils::getUserAise));
        entity.setDataLancamento(Optional.ofNullable(entity.getDataLancamento()).orElse(LocalDate.now()));
        this.applyIdIfNotExists(entity, entidade, exercicio);
        this.configureCadastros(entity, entidade, exercicio);
    }

    private void applyIdIfNotExists(Rocada entity, Long entidade, Long exercicio) {
        if (Optional.ofNullable(entity.getId()).map(RocadaId::getRocada).isEmpty()) {
            RocadaId rocadaId = new RocadaId();
            rocadaId.setEntidade(entidade);
            rocadaId.setExercicio(exercicio);
            entity.setId(rocadaId);
            EloSequenceGenerator.attrNextValues((Object)entity, (SessionFactory)((SessionFactory)this.getEm().getEntityManagerFactory().unwrap(SessionFactoryImplementor.class)), (EloSequenceCache)this.eloSequenceCache);
        }
    }

    private void configureCadastros(Rocada entity, Long entidade, Long exercicio) {
        entity.getCadastros().forEach(cadastro -> {
            cadastro.setRocada(Optional.ofNullable(cadastro.getRocada()).orElse(entity));
            cadastro.setId(Optional.ofNullable(cadastro.getId()).orElseGet(RocadaCadastroId::new));
            RocadaCadastroId id = cadastro.getId();
            this.configureCadastroId(id, entidade, exercicio, entity.getId().getRocada());
            this.configureTipo(cadastro, entidade, exercicio);
        });
    }

    private void configureCadastroId(RocadaCadastroId id, Long entidade, Long exercicio, Long rocada) {
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        id.setRocada(rocada);
    }

    private void configureTipo(RocadaCadastro cadastro, Long entidade, Long exercicio) {
        RocadaCadastroTipo tipo = cadastro.getTipo();
        tipo.setRocadaCadastro(cadastro);
        tipo.setId(Optional.ofNullable(tipo.getId()).orElseGet(RocadaCadastroTipoId::new));
        RocadaCadastroTipoId tipoId = tipo.getId();
        this.configureTipoId(tipoId, cadastro.getId(), entidade, exercicio);
    }

    private void configureTipoId(RocadaCadastroTipoId tipoId, RocadaCadastroId cadastroId, Long entidade, Long exercicio) {
        tipoId.setEntidade(entidade);
        tipoId.setExercicio(exercicio);
        tipoId.setRocada(cadastroId.getRocada());
        tipoId.setTipoCadastro(cadastroId.getTipoCadastro());
        tipoId.setCadastroGeral(cadastroId.getCadastroGeral());
    }

    public RocadaDTO save(RocadaDTO rocadaDTO) {
        this.applyValoresPadraoTipoRocada(rocadaDTO);
        Rocada rocada = (Rocada)this.save((EloEntity)rocadaDTO.toEntity(), null);
        return RocadaDTO.from((Rocada)rocada);
    }

    private void applyValoresPadraoTipoRocada(RocadaDTO rocadaDTO) {
        Long entidade = Optional.ofNullable(rocadaDTO.getEntidade()).orElseGet(() -> ((ContextService)this.contextService).getEntidadePrincipal());
        Long exercicio = Optional.ofNullable(rocadaDTO.getExercicio()).orElseGet(() -> ((ContextService)this.contextService).getExercicioAtual());
        TipoRocada tipoRocadaPadrao = this.tipoRocadaService.findPadraoByEntidadeAndExercicio(entidade, exercicio);
        rocadaDTO.getCadastros().forEach(cadastro -> {
            cadastro.setTipoRocada(Optional.ofNullable(cadastro.getTipoRocada()).orElse(TipoRocadaDTO.from((TipoRocada)tipoRocadaPadrao)));
            cadastro.setQuantidadeTipoRocada(Optional.ofNullable(cadastro.getQuantidadeTipoRocada()).orElse(BigDecimal.ONE));
        });
    }

    public Page<Rocada> search(String search, Pageable pageable) {
        search = String.format("id.entidade==%d %s", this.contextService.getEntidadePrincipal(), search.isEmpty() ? "" : "and " + search);
        return this.findByRsql(search, pageable);
    }

    public RocadaId buildRocadaId(Long entidade, Long exercicio, Long idRocada) {
        RocadaId rocadaId = new RocadaId();
        rocadaId.setEntidade(entidade);
        rocadaId.setExercicio(exercicio);
        rocadaId.setRocada(idRocada);
        return rocadaId;
    }

    public Optional<RocadaDTO> findById(Long entidade, Long exercicio, Long idRocada) {
        Optional<RocadaDTO> rocadaDTO = this.findById((Serializable)this.buildRocadaId(entidade, exercicio, idRocada)).map(RocadaDTO::from);
        rocadaDTO.ifPresent(dto -> dto.getCadastros().forEach(arg_0 -> this.fillDetalhesDoCadastro(arg_0)));
        return rocadaDTO;
    }

    private void fillDetalhesDoCadastro(RocadaCadastroDTO cadastroDTO) {
        CadastroImobiliario cadastroImobiliario = this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)cadastroDTO.getCadastro().getTipoCadastro()), cadastroDTO.getCadastro().getCadastroGeral());
        cadastroDTO.setDistrito(cadastroImobiliario.getDistritoLocalizacao());
        cadastroDTO.setZona(cadastroImobiliario.getSetorLocalizacao());
        cadastroDTO.setQuadra(cadastroImobiliario.getQuadraLocalizacao());
        cadastroDTO.setLote(cadastroImobiliario.getLoteLocalizacao());
        if (Objects.isNull(cadastroDTO.getValorTotal())) {
            cadastroDTO.setValorTotal(this.calculateValorReceita(cadastroDTO.getAreaRocada(), cadastroDTO.getAreaPasseio(), cadastroDTO.getTipoRocada().getValorUnitario(), cadastroDTO.getTipoRocada().getTipoUnidade(), cadastroDTO.getQuantidadeTipoRocada()));
        }
    }

    public void delete(Long entidade, Long exercicio, Long idRocada) {
        Rocada rocada = (Rocada)this.findOne((Serializable)this.buildRocadaId(entidade, exercicio, idRocada));
        this.beforeDelete(rocada);
        this.delete((EloEntity)rocada, null);
    }

    public void beforeDelete(Rocada rocada) {
        this.validateDebitoGerado(rocada, Boolean.TRUE);
    }

    @Async
    @Transactional
    public void generateDebitoAndBoletoAsync(Long entidade, Long exercicio, Long idRocada) {
        log.debug("Preparando ambiente para gera\u00e7\u00e3o de d\u00e9bitos da ro\u00e7ada {}-{}/{}", new Object[]{entidade, idRocada, exercicio});
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        TarefaAssincronaExecucao tarefaEmExecucao = this.startTarefaAssincrona(entidade, exercicio, idRocada);
        Optional idNotificacao = this.notifyInicioTarefaAssincrona(tarefaEmExecucao, user);
        try {
            log.debug("Iniciando gera\u00e7\u00e3o de d\u00e9bitos da ro\u00e7ada.");
            this.generateDebitoAndBoleto(entidade, exercicio, idRocada);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.COMPLETED, null);
            log.debug("Finalizado rotina de gera\u00e7\u00e3o de d\u00e9bitos da ro\u00e7ada.");
        }
        catch (Exception e) {
            log.error("Erro ao realizar rotina de gera\u00e7\u00e3o de d\u00e9bitos da ro\u00e7ada.", (Throwable)e);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.FAILED, e);
        }
    }

    public void generateDebitoAndBoleto(Long entidade, Long exercicio, Long idRocada) {
        Rocada rocada = (Rocada)this.findOne((Serializable)this.buildRocadaId(entidade, exercicio, idRocada));
        this.beforeGenerateDebito(rocada);
        TipoRocada tipoRocadaPadrao = this.tipoRocadaService.findPadraoByEntidadeAndExercicio(entidade, exercicio);
        LocalDate dataVencimentoBase = rocada.getDataVencimento();
        rocada.getCadastros().forEach(cadastro -> {
            if (cadastro.getDebito() == null) {
                this.createDebitoByCadastro(cadastro, tipoRocadaPadrao, dataVencimentoBase);
            }
            if (cadastro.getBoleto() == null) {
                this.createBoletoByCadastro(cadastro);
            }
        });
        rocada.setDebitoGerado(Boolean.TRUE);
        this.save((EloEntity)rocada, null);
    }

    public void createDebitoByCadastro(RocadaCadastro cadastro, TipoRocada tipoRocadaPadrao, LocalDate dataVencimentoBase) {
        TipoRocada tipoRocada = this.getTipoRocada(cadastro, tipoRocadaPadrao);
        BigDecimal valorTributo = this.calculateValorReceita(cadastro.getAreaRocada(), cadastro.getAreaPasseio(), tipoRocada.getValorUnitario(), tipoRocada.getTipoUnidade(), cadastro.getTipo().getQuantidade());
        String tributo = this.getTributo(cadastro, tipoRocada);
        Long divida = this.getDivida(cadastro, tipoRocada);
        Long prazoPagamento = tipoRocada.getPrazoPagamento();
        LocalDate dataVencimento = prazoPagamento != null && prazoPagamento > 0L ? dataVencimentoBase.plusDays(prazoPagamento) : dataVencimentoBase;
        List tributos = this.buildDebitoManualTributoDTO(tributo, valorTributo);
        List parcelas = this.geraDebitoService.gerarParcelas(this.buildGerarParcelasDebitoDTO(tributos, dataVencimento));
        DebitoManualDTO dto = this.buildDebitoManualDTO(cadastro, divida, parcelas, tributos);
        DebitoIdDTO debitoIdDTO = this.geraDebitoService.geraDebitoManual(dto);
        this.entityManager.flush();
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
        cadastro.setDebito(debito);
    }

    public void createBoletoByCadastro(RocadaCadastro cadastro) {
        ModeloBoleto modeloBoleto = this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        Debito debito = cadastro.getDebito();
        GeraBoletoDTO dto = new GeraBoletoDTO();
        dto.setTipoBoleto(TipoBloqueto.PARCELADO);
        dto.setOrigemEmissao(OrigemEmissao.AISE);
        dto.setDebitos(Collections.singletonList(DebitoParcelaDTO.fromUltimaParcelaDebito((Debito)debito)));
        dto.setDataReferencia(LocalDate.now());
        dto.setUsuario(SecurityUtils.getUserAise());
        dto.setExercicio(debito.getExercicio());
        dto.setModeloBoleto(modeloBoleto);
        dto.setObservacao(String.format("Boleto referente ao d\u00e9bito %d para o cadastro %d/%d da ro\u00e7ada %d/%d", debito.getId(), cadastro.getId().getTipoCadastro(), cadastro.getId().getCadastroGeral(), cadastro.getId().getRocada(), cadastro.getId().getExercicio()));
        dto.setUsaExercicioEspecificado(Boolean.TRUE);
        Bloqueto boleto = (Bloqueto)this.geraBoletoService.geraBoleto(dto).get(0);
        this.entityManager.flush();
        cadastro.setBoleto(boleto);
    }

    private TipoRocada getTipoRocada(RocadaCadastro cadastro, TipoRocada tipoRocadaPadrao) {
        if (cadastro.getTipo() == null) {
            return tipoRocadaPadrao;
        }
        TipoRocadaId tipoRocadaId = new TipoRocadaId();
        tipoRocadaId.setEntidade(cadastro.getId().getEntidade());
        tipoRocadaId.setExercicio(cadastro.getId().getExercicio());
        tipoRocadaId.setId(cadastro.getTipo().getId().getIdTipoRocada());
        return this.tipoRocadaService.findById((Serializable)tipoRocadaId).orElse(tipoRocadaPadrao);
    }

    private String getTributo(RocadaCadastro cadastro, TipoRocada tipoRocada) {
        return cadastro.getTipoTerreno().equals((Object)TipoTerrenoRocada.VAZIO) ? tipoRocada.getTributoTerrenoVazio().getTributo() : tipoRocada.getTributoTerrenoConstruido().getTributo();
    }

    private Long getDivida(RocadaCadastro cadastro, TipoRocada tipoRocada) {
        return cadastro.getTipoTerreno().equals((Object)TipoTerrenoRocada.VAZIO) ? tipoRocada.getDividaTerrenoVazio().getDivida() : tipoRocada.getDividaTerrenoConstruido().getDivida();
    }

    private Long getSubDivida(Long tipoCadastro, Long cadastroGeral, Long exercicio, Long dividaConfigurada) {
        NextSubdividaValueParams params = NextSubdividaValueParams.of((Long)tipoCadastro, (Long)cadastroGeral, (Long)exercicio, (Long)dividaConfigurada);
        return this.debitoService.getNextValueSubdivida(params);
    }

    private FormaCorrecao getFormaCorrecao(Long idDivida, Long entidade, Long exercicio) {
        return this.formaCorrecaoService.getFormaCorrecaoPadrao(idDivida, entidade, exercicio);
    }

    private DebitoManualDTO buildDebitoManualDTO(RocadaCadastro cadastro, Long dividaConfigurada, List<DebitoManualParcelaDTO> parcelas, List<DebitoManualTributoDTO> tributos) {
        Long entidade = cadastro.getId().getEntidade();
        Long exercicio = cadastro.getId().getExercicio();
        Long tipoCadastro = cadastro.getId().getTipoCadastro();
        Long cadastroGeral = cadastro.getId().getCadastroGeral();
        FormaCorrecao formaCorrecao = this.getFormaCorrecao(dividaConfigurada, entidade, exercicio);
        Long subDivida = this.getSubDivida(tipoCadastro, cadastroGeral, exercicio, dividaConfigurada);
        String observacao = String.format("D\u00e9bito gerado para ro\u00e7ada %d/%d", cadastro.getId().getRocada(), exercicio);
        DebitoManualDTO debito = new DebitoManualDTO();
        debito.setExercicio(exercicio);
        debito.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        debito.setCadastroGeral(cadastro.getId().getCadastroGeral());
        debito.setDivida(dividaConfigurada);
        debito.setSubDivida(subDivida);
        debito.setDataLancamento(cadastro.getDataRocada());
        debito.setDataInclusao(LocalDate.now());
        debito.setFormaCorrecao(formaCorrecao.getId());
        debito.setPrograma("BaixaRocada");
        debito.setParcelas(parcelas);
        debito.setTributos(tributos);
        debito.getObservacoes().add(DebitoManualObservacaoDTO.of((String)observacao));
        return debito;
    }

    public GerarParcelasDebitoDTO buildGerarParcelasDebitoDTO(List<DebitoManualTributoDTO> tributoDTOS, LocalDate dataVencimento) {
        GerarParcelasDebitoDTO gerarParcelasDebitoDTO = new GerarParcelasDebitoDTO();
        gerarParcelasDebitoDTO.setParcelaInicial(Long.valueOf(1L));
        gerarParcelasDebitoDTO.setQuantidadeParcelas(Long.valueOf(1L));
        gerarParcelasDebitoDTO.setDataVencimentoInicial(dataVencimento);
        gerarParcelasDebitoDTO.setTributos(tributoDTOS);
        return gerarParcelasDebitoDTO;
    }

    public List<DebitoManualTributoDTO> buildDebitoManualTributoDTO(String tributo, BigDecimal valorTributo) {
        DebitoManualTributoDTO tributoDTO = new DebitoManualTributoDTO();
        tributoDTO.setTributo(tributo);
        tributoDTO.setValorTributo(valorTributo);
        ArrayList<DebitoManualTributoDTO> tributoDTOS = new ArrayList<DebitoManualTributoDTO>();
        tributoDTOS.add(tributoDTO);
        return tributoDTOS;
    }

    public BigDecimal calculateValorReceita(BigDecimal areaRocada, BigDecimal areaPasseio, BigDecimal valorUnitario, TipoUnidadeMedidaRocada tipoUnidadeMedidaRocada, BigDecimal quantidadeCadastro) {
        BigDecimal quantidade = TipoUnidadeMedidaRocada.METROS_QUADRADOS.equals((Object)tipoUnidadeMedidaRocada) ? areaRocada.add(areaPasseio) : quantidadeCadastro;
        return quantidade.multiply(valorUnitario);
    }

    public void beforeGenerateDebito(Rocada rocada) {
        this.validateDebitoGerado(rocada, Boolean.FALSE);
    }

    public void validateDebitoGerado(Rocada rocada, Boolean isValidaCadastro) {
        if (Boolean.TRUE.equals(rocada.getDebitoGerado()) || isValidaCadastro.booleanValue() && rocada.getCadastros().stream().anyMatch(rocadaCadastro -> rocadaCadastro.getDebito() != null)) {
            throw new EloValidationException(String.format("J\u00e1 foi gerado d\u00e9bito para a ro\u00e7ada %d/%d. N\u00e3o ser\u00e1 poss\u00edvel prosseguir.", rocada.getId().getRocada(), rocada.getId().getExercicio()));
        }
    }

    public void validateDebitoGeradoParaTodosCadastros(Rocada rocada) {
        boolean debitoGeralNaoGerado = Boolean.FALSE.equals(rocada.getDebitoGerado());
        boolean algumCadastroSemDebito = rocada.getCadastros().stream().anyMatch(rocadaCadastro -> rocadaCadastro.getDebito() == null);
        if (debitoGeralNaoGerado || algumCadastroSemDebito) {
            throw new EloValidationException(String.format("Ainda n\u00e3o foi gerado o d\u00e9bito completo para a ro\u00e7ada %d/%d. N\u00e3o ser\u00e1 poss\u00edvel prosseguir.", rocada.getId().getRocada(), rocada.getId().getExercicio()));
        }
    }

    private TarefaAssincronaExecucao startTarefaAssincrona(Long entidade, Long exercicio, Long idRocada) {
        return this.tarefaAssincronaService.createTarefaAssincronaGeracaoDebitoRocada(String.format("%d/%d/%d", entidade, exercicio, idRocada));
    }

    private void stopTarefaAssincrona(TarefaAssincronaExecucao execucao, Optional<UUID> idNotificacao, UserSecurityDTO user, NotificationStatus status, Exception exception) {
        if (status.equals((Object)NotificationStatus.FAILED)) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
        } else {
            this.tarefaAssincronaService.finalizarExecucao(execucao);
        }
        this.notifyCliente(execucao, idNotificacao, user, status);
    }

    private Optional<UUID> notifyCliente(TarefaAssincronaExecucao execucao, Optional<UUID> idNotificacao, UserSecurityDTO user, NotificationStatus status) {
        String titulo = "Gera\u00e7\u00e3o de D\u00e9bito da Ro\u00e7ada";
        String message = (String)messagesNotificacao.get(status);
        TarefaAssincrona tarefa = execucao.getTarefaAssincrona();
        return this.notificacaoService.send(titulo, message, tarefa, idNotificacao, user, status);
    }

    private Optional<UUID> notifyInicioTarefaAssincrona(TarefaAssincronaExecucao execucao, UserSecurityDTO user) {
        return this.notifyCliente(execucao, Optional.empty(), user, NotificationStatus.STARTED);
    }

    public RocadaResumoImobiliarioDTO processResumoImobiliario(RocadaResumoImobiliarioDTO dto) {
        if (dto.getTipoAtualizacao() == TipoAtualizacaoResumoImobiliarioRocada.ALTERACAO_CADASTRO) {
            this.processResumoDadosImovelByCadastro(dto);
        } else if (dto.getTipoAtualizacao() == TipoAtualizacaoResumoImobiliarioRocada.ALTERACAO_LOTE) {
            this.processResumoCadastroByDadosImovel(dto);
        }
        return dto;
    }

    private void processResumoCadastroByDadosImovel(RocadaResumoImobiliarioDTO dto) {
        Optional cadastroImobiliario = this.cadastroImobiliarioService.findCadastroByLocalizacaoCompleta(dto.getDistrito().getId(), dto.getZona().getId(), dto.getQuadra().getId(), dto.getLote()).stream().findFirst();
        if (cadastroImobiliario.isPresent()) {
            CadastroGeralResponseDTO cadastro = new CadastroGeralResponseDTO();
            cadastro.setTipoCadastro(((CadastroImobiliario)cadastroImobiliario.get()).getTipoCadastro().getValue());
            cadastro.setCadastroGeral(((CadastroImobiliario)cadastroImobiliario.get()).getCadastroGeral());
            dto.setCadastro(cadastro);
            dto.setAreaLote(((CadastroImobiliario)cadastroImobiliario.get()).getAreaLote());
        }
    }

    private void processResumoDadosImovelByCadastro(RocadaResumoImobiliarioDTO dto) {
        CadastroImobiliario cadastroImobiliario = this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)dto.getCadastro().getTipoCadastro()), dto.getCadastro().getCadastroGeral());
        dto.setDistrito(cadastroImobiliario.getDistritoLocalizacao());
        dto.setZona(cadastroImobiliario.getSetorLocalizacao());
        dto.setQuadra(cadastroImobiliario.getQuadraLocalizacao());
        dto.setLote(cadastroImobiliario.getLoteLocalizacao());
        dto.setAreaLote(cadastroImobiliario.getAreaLote());
    }

    public GerarComunicadoRequest buildGerarComunicadoRequest(GerarComunicadoRocadaRequestDTO dto) {
        Rocada rocada = (Rocada)this.findOne((Serializable)this.buildRocadaId(dto.getEntidade(), dto.getExercicio(), dto.getIdRocada()));
        this.validateDebitoGeradoParaTodosCadastros(rocada);
        GerarComunicadoRequest request = new GerarComunicadoRequest();
        request.setUsuario(SecurityUtils.getUserAise());
        request.setTipoNotificacao(dto.getTipoNotificacao());
        request.setDescricao(String.format("Comunicado para a Ro\u00e7ada %d/%d. V\u00ednculo %d-%s", rocada.getId().getRocada(), rocada.getId().getExercicio(), dto.getVinculo().getId(), dto.getVinculo().getDescricao()));
        request.setTipoComunicadoGeracaoManual(TipoComunicadoGeracaoManual.ROCADA);
        request.setFiltrosCamposDinamicos(this.buildFiltrosComunicado(rocada.getId()));
        request.setVinculoProprietario(dto.getVinculo().getId());
        return request;
    }

    private List<CalculoGeracaoLoteFiltroDTO> buildFiltrosComunicado(RocadaId rocadaId) {
        return List.of(this.createFiltroComunicado(TABLE_ROCADA, "ENTIDADE", "Entidade", String.valueOf(rocadaId.getEntidade()), TipoCampo.INTEIRO, Operador.IGUAL), this.createFiltroComunicado(TABLE_ROCADA, "EXERCICIO", "Exerc\u00edcio", String.valueOf(rocadaId.getExercicio()), TipoCampo.INTEIRO, Operador.IGUAL), this.createFiltroComunicado(TABLE_ROCADA, "ROCADA", "Ro\u00e7ada", String.valueOf(rocadaId.getRocada()), TipoCampo.INTEIRO, Operador.IGUAL), this.createFiltroComunicado(TABLE_BLOQUETO, "DATAVENCIMENTO", "Data Vencimento", LocalDate.now().toString(), TipoCampo.DATA, Operador.MAIOR));
    }

    private CalculoGeracaoLoteFiltroDTO createFiltroComunicado(String tabela, String nomeCampo, String descricao, String valor, TipoCampo tipoCampo, Operador operador) {
        CampoDetalheDTO campo = new CampoDetalheDTO();
        campo.setTabela(tabela);
        campo.setNome(nomeCampo);
        campo.setDescricao(descricao);
        campo.setTipo(tipoCampo);
        CalculoGeracaoLoteFiltroDTO filtro = new CalculoGeracaoLoteFiltroDTO();
        filtro.setOperador(operador);
        filtro.setValor(valor);
        filtro.setCampo(campo);
        return filtro;
    }

    public void saveComunicado(Long entidade, Long exercicio, Long idRocada, Comunicado comunicado) {
        Rocada rocada = (Rocada)this.findOne((Serializable)this.buildRocadaId(entidade, exercicio, idRocada));
        rocada.setIdComunicado(comunicado.getId().getIdComunicado());
        rocada.setExercicioComunicado(comunicado.getId().getExercicio());
        this.save((EloEntity)rocada, null);
    }

    @Generated
    public RocadaService(TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService, ContextService contextService, EloSequenceCache eloSequenceCache, TipoRocadaService tipoRocadaService, GeraDebitoService geraDebitoService, GeraBoletoService geraBoletoService, FormaCorrecaoService formaCorrecaoService, DebitoService debitoService, ModeloBoletoService modeloBoletoService, EntityManager entityManager, CadastroImobiliarioService cadastroImobiliarioService) {
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
        this.contextService = contextService;
        this.eloSequenceCache = eloSequenceCache;
        this.tipoRocadaService = tipoRocadaService;
        this.geraDebitoService = geraDebitoService;
        this.geraBoletoService = geraBoletoService;
        this.formaCorrecaoService = formaCorrecaoService;
        this.debitoService = debitoService;
        this.modeloBoletoService = modeloBoletoService;
        this.entityManager = entityManager;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
    }
}

