/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.jpa.support.EloSequenceCache;
import br.com.elotech.core.jpa.support.EloSequenceGenerator;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.PrevisaoArrecadacao;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.PrevisaoArrecadacaoId;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.PrevisaoArrecadacaoMesId;
import br.com.elotech.tributos.repository.relatoriogerencial.PrevisaoArrecadacaoRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class PrevisaoArrecadacaoService
extends CrudService<PrevisaoArrecadacao, PrevisaoArrecadacaoId> {
    private final ContextService contextService;
    private final PrevisaoArrecadacaoRepository previsaoArrecadacaoRepository;
    private final EloSequenceCache eloSequenceCache;

    protected void beforeSave(PrevisaoArrecadacao entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        Long entidade = Objects.nonNull(entity.getId()) && Objects.nonNull(entity.getId().getEntidade()) ? entity.getId().getEntidade() : this.contextService.getEntidadePrincipal();
        Long exercicio = Objects.nonNull(entity.getId()) && Objects.nonNull(entity.getId().getExercicio()) ? entity.getId().getExercicio() : this.contextService.getExercicioAtual();
        Long id = Objects.nonNull(entity.getId()) ? entity.getId().getIdPrevisaoArrecadacao() : null;
        this.validateComConflito(id, entidade, exercicio);
        this.applyIdIfNotExists(entity, entidade, exercicio);
        entity.getPrevisaoArrecadacaoMes().forEach(item -> {
            if (Objects.isNull(item.getPrevisaoArrecadacao())) {
                item.setPrevisaoArrecadacao(entity);
                PrevisaoArrecadacaoMesId previsaoArrecadacaoMesId = new PrevisaoArrecadacaoMesId();
                previsaoArrecadacaoMesId.setEntidade(entity.getId().getEntidade());
                previsaoArrecadacaoMesId.setExercicio(entity.getId().getExercicio());
                previsaoArrecadacaoMesId.setIdPrevisaoArrecadacao(entity.getId().getIdPrevisaoArrecadacao());
                previsaoArrecadacaoMesId.setMes(item.getId().getMes());
                item.setId(previsaoArrecadacaoMesId);
            }
        });
    }

    private void validateComConflito(Long id, Long entidade, Long exercicio) {
        this.previsaoArrecadacaoRepository.findPrevisaoArrecadacaoComConflito(id, entidade, exercicio).stream().findFirst().ifPresent(conflitante -> {
            throw new EloValidationException(String.format("J\u00e1 existe um Previss\u00e3o de Arrecada\u00e7\u00e3o para este per\u00edodo Exerc\u00edcio %d.", conflitante.getId().getExercicio()));
        });
    }

    private void applyIdIfNotExists(PrevisaoArrecadacao entity, Long entidade, Long exercicio) {
        if (Objects.isNull(entity.getId()) || Objects.isNull(entity.getId().getIdPrevisaoArrecadacao())) {
            PrevisaoArrecadacaoId id = new PrevisaoArrecadacaoId();
            id.setEntidade(entidade);
            id.setExercicio(exercicio);
            entity.setId(id);
            EloSequenceGenerator.attrNextValues((Object)entity, (SessionFactory)((SessionFactory)this.getEm().getEntityManagerFactory().unwrap(SessionFactoryImplementor.class)), (EloSequenceCache)this.eloSequenceCache);
        }
    }

    @Generated
    public PrevisaoArrecadacaoService(ContextService contextService, PrevisaoArrecadacaoRepository previsaoArrecadacaoRepository, EloSequenceCache eloSequenceCache) {
        this.contextService = contextService;
        this.previsaoArrecadacaoRepository = previsaoArrecadacaoRepository;
        this.eloSequenceCache = eloSequenceCache;
    }
}

