/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.parametros;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.parametros.ParametroCotaUnicaDiferenciada;
import br.com.elotech.tributos.repository.parametros.ParametroCotaUnicaDiferenciadaRepository;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ParametroCotaUnicaDiferenciadaService
extends CrudService<ParametroCotaUnicaDiferenciada, Long> {
    private final ParametroCotaUnicaDiferenciadaRepository parametroCotaUnicaDiferenciadaRepository;

    protected void beforeSave(ParametroCotaUnicaDiferenciada entity, Authentication authentication) {
        if (Boolean.TRUE.equals(this.parametroCotaUnicaDiferenciadaRepository.existsByDividaAndFormaPagamento(entity.getDivida(), entity.getFormaPagamento()))) {
            throw new EloValidationException(String.format("J\u00e1 existe um registro para a d\u00edvida %d e forma de pagamento %s.", entity.getDivida().getDivida(), entity.getFormaPagamento().getDescricao()));
        }
        super.beforeSave((EloEntity)entity, authentication);
    }

    protected void beforeDelete(ParametroCotaUnicaDiferenciada entity, Authentication authentication) {
        this.parametroCotaUnicaDiferenciadaRepository.findById((Object)entity.getId()).ifPresent(parametro -> {
            if (Boolean.TRUE.equals(parametro.getHasCadastroVinculado())) {
                throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel remover esta Cota \u00danica Diferenciada pois existem cadastros vinculados.");
            }
        });
        super.beforeDelete((EloEntity)entity, authentication);
    }

    @Generated
    public ParametroCotaUnicaDiferenciadaService(ParametroCotaUnicaDiferenciadaRepository parametroCotaUnicaDiferenciadaRepository) {
        this.parametroCotaUnicaDiferenciadaRepository = parametroCotaUnicaDiferenciadaRepository;
    }
}

