/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.memoria;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.memoria.CadastroGeralIsencaoMemoriaId;
import br.com.elotech.tributos.domain.memoria.CadastroGeralMemoriaId;
import br.com.elotech.tributos.domain.memoria.CadastroImobiliarioMemoria;
import br.com.elotech.tributos.domain.memoria.ImobiliarioAreaVerdeMemoriaId;
import br.com.elotech.tributos.domain.memoria.ImobiliarioTestadaMemoriaId;
import br.com.elotech.tributos.dto.cadastroimobiliario.ProprietarioDTO;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import br.com.elotech.tributos.dto.memoria.CadastroGeralMemoriaDTO;
import br.com.elotech.tributos.dto.memoria.CadastroImobiliarioMemoriaDTO;
import br.com.elotech.tributos.dto.memoria.MemoriaCadastroDTO;
import br.com.elotech.tributos.repository.memoria.CadastroGeralMemoriaRepository;
import br.com.elotech.tributos.repository.memoria.CadastroImobiliarioMemoriaRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CadastroImobiliarioMemoriaService
extends CrudService<CadastroImobiliarioMemoria, CadastroGeralMemoriaId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CadastroImobiliarioMemoriaService.class);
    private final CadastroImobiliarioMemoriaRepository repository;
    private final CadastroGeralMemoriaRepository cadastroGeralMemoriaRepository;
    private final RespostaService respostaService;
    private final CadastroGeralService cadastroGeralService;

    protected void beforeSave(CadastroImobiliarioMemoria cadastro, Authentication authentication) {
        this.fillTestadas(cadastro);
        this.fillTestadasGenericas(cadastro);
        this.fillAreasVerde(cadastro);
        this.fillIsencoes(cadastro);
        this.fillRespostasTerrenoMemoria(cadastro);
        super.beforeSave((EloEntity)cadastro, authentication);
    }

    private void fillTestadas(CadastroImobiliarioMemoria cadastro) {
        cadastro.getTestadas().forEach(testada -> {
            if (testada.getId() == null) {
                testada.setId(new ImobiliarioTestadaMemoriaId());
            }
            if (this.checkIdIncompleto(testada.getId().getIdMemoriaCadastro(), testada.getId().getTipoCadastro(), testada.getId().getCadastroGeral())) {
                testada.getId().setIdMemoriaCadastro(cadastro.getId().getIdMemoriaCadastro());
                testada.getId().setTipoCadastro(cadastro.getId().getTipoCadastro());
                testada.getId().setCadastroGeral(cadastro.getId().getCadastroGeral());
            }
        });
    }

    private void fillTestadasGenericas(CadastroImobiliarioMemoria cadastro) {
        cadastro.getTestadasGenericas().forEach(testada -> {
            if (this.checkIdIncompleto(testada.getIdMemoriaCadastro(), testada.getTipoCadastro(), testada.getCadastroGeral())) {
                testada.setIdMemoriaCadastro(cadastro.getId().getIdMemoriaCadastro());
                testada.setTipoCadastro(cadastro.getId().getTipoCadastro());
                testada.setCadastroGeral(cadastro.getId().getCadastroGeral());
                testada.setCadastroImobiliarioMemoria(cadastro);
            }
        });
    }

    private void fillAreasVerde(CadastroImobiliarioMemoria cadastro) {
        cadastro.getAreasVerde().forEach(area -> {
            if (area.getId() == null) {
                area.setId(new ImobiliarioAreaVerdeMemoriaId());
            }
            if (this.checkIdIncompleto(area.getId().getIdMemoriaCadastro(), area.getId().getTipoCadastro(), area.getId().getCadastroGeral())) {
                area.getId().setIdMemoriaCadastro(cadastro.getId().getIdMemoriaCadastro());
                area.getId().setTipoCadastro(cadastro.getId().getTipoCadastro());
                area.getId().setCadastroGeral(cadastro.getId().getCadastroGeral());
            }
        });
    }

    private void fillIsencoes(CadastroImobiliarioMemoria cadastro) {
        cadastro.getIsencoes().forEach(isencao -> {
            if (isencao.getId() == null) {
                isencao.setId(new CadastroGeralIsencaoMemoriaId());
            }
            if (this.checkIdIncompleto(isencao.getId().getIdMemoriaCadastro(), isencao.getId().getTipoCadastro(), isencao.getId().getCadastroGeral())) {
                isencao.getId().setIdMemoriaCadastro(cadastro.getId().getIdMemoriaCadastro());
                isencao.getId().setTipoCadastro(cadastro.getId().getTipoCadastro());
                isencao.getId().setCadastroGeral(cadastro.getId().getCadastroGeral());
                isencao.setMemoriaCadastro(cadastro.getMemoriaCadastro());
                isencao.setCadastroGeralMemoria(cadastro.getCadastroGeralMemoria());
            }
        });
    }

    private void fillRespostasTerrenoMemoria(CadastroImobiliarioMemoria cadastro) {
        cadastro.getCadastroGeralMemoria().getRespostasTerrenoMemoria().forEach(resposta -> {
            if (resposta.getIdMemoriaCadastro() == null) {
                resposta.setIdMemoriaCadastro(cadastro.getId().getIdMemoriaCadastro());
            }
        });
    }

    private boolean checkIdIncompleto(Long idMemoriaCadastro, Long tipoCadastro, Long cadastroGeral) {
        return idMemoriaCadastro == null || tipoCadastro == null || cadastroGeral == null;
    }

    public Page<CadastroGeralMemoriaDTO> searchCadastros(Long idMemoriaCadastro, String search, Pageable pageable) {
        String queryBase = String.format("id.idMemoriaCadastro==%d", idMemoriaCadastro);
        String queryFinal = StringUtils.isBlank((CharSequence)search) ? queryBase : String.format("(%s) and (%s)", queryBase, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), (String)queryFinal);
        return this.cadastroGeralMemoriaRepository.findAll(specification, pageable).map(CadastroGeralMemoriaDTO::from);
    }

    public MemoriaCadastroDTO findByCadastroDTO(Long idMemoria, Long tipoCadastro, Long cadastroGeral) {
        CadastroGeralMemoriaId cadastroGeralMemoriaId = new CadastroGeralMemoriaId();
        cadastroGeralMemoriaId.setIdMemoriaCadastro(idMemoria);
        cadastroGeralMemoriaId.setTipoCadastro(tipoCadastro);
        cadastroGeralMemoriaId.setCadastroGeral(cadastroGeral);
        CadastroImobiliarioMemoria memoria = (CadastroImobiliarioMemoria)this.repository.findById((Object)cadastroGeralMemoriaId).orElseThrow(RestException::notFound);
        MemoriaCadastroDTO dto = MemoriaCadastroDTO.from((CadastroImobiliarioMemoria)memoria);
        this.fillProprietarios(dto);
        this.fillRespostasTerreno(dto.getImobiliario());
        this.fillRespostasSegmentos(dto.getImobiliario());
        return dto;
    }

    private void fillProprietarios(MemoriaCadastroDTO dto) {
        List proprietarios = this.getProprietarios(dto.getImobiliario().getTipoCadastro().getValue(), dto.getImobiliario().getCadastroGeral());
        dto.getImobiliario().setProprietarios(proprietarios);
    }

    private List<ProprietarioDTO> getProprietarios(Long tipoCadastro, Long cadastroGeral) {
        CadastroGeral entity = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral).orElseThrow(RestException::notFound);
        return entity.getProprietarios().stream().map(ProprietarioDTO::from).collect(Collectors.toList());
    }

    private void fillRespostasTerreno(CadastroImobiliarioMemoriaDTO dto) {
        dto.setRespostasTerreno(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.TERRENOMEMORIA, dto.getIdKey()));
    }

    private void fillRespostasSegmentos(CadastroImobiliarioMemoriaDTO dto) {
        dto.getSegmentos().forEach(segmento -> segmento.setRespostasSegmento(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.SEGMENTOMEMORIA, segmento.getIdKey())));
    }

    public CadastroImobiliarioMemoriaDTO saveDTO(CadastroImobiliarioMemoriaDTO dto) {
        CadastroImobiliarioMemoria cadastroImobiliarioToSave = dto.toEntity();
        CadastroImobiliarioMemoria prepared = this.prepareToSave(cadastroImobiliarioToSave, dto.getRespostasTerreno());
        CadastroImobiliarioMemoria saved = (CadastroImobiliarioMemoria)this.save((EloEntity)prepared, null);
        CadastroImobiliarioMemoriaDTO result = CadastroImobiliarioMemoriaDTO.from((CadastroImobiliarioMemoria)saved);
        this.fillRespostasTerreno(result);
        this.fillRespostasSegmentos(result);
        return dto;
    }

    public CadastroImobiliarioMemoria prepareToSave(CadastroImobiliarioMemoria entity, List<GrupoRespostasDTO> respostasTerreno) {
        CadastroImobiliarioMemoria cadastroImobiliarioFound = (CadastroImobiliarioMemoria)this.repository.findById((Object)entity.getId()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", entity.getId())));
        return cadastroImobiliarioFound.merge(entity, respostasTerreno);
    }

    @Generated
    public CadastroImobiliarioMemoriaService(CadastroImobiliarioMemoriaRepository repository, CadastroGeralMemoriaRepository cadastroGeralMemoriaRepository, RespostaService respostaService, CadastroGeralService cadastroGeralService) {
        this.repository = repository;
        this.cadastroGeralMemoriaRepository = cadastroGeralMemoriaRepository;
        this.respostaService = respostaService;
        this.cadastroGeralService = cadastroGeralService;
    }
}

