/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ProjetoDebitoFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ProjetoDocumentoFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ProjetoFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.ProjetoItemFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.tuple.TupleUtils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.postgresql.util.PGobject;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoProjetoFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<ProjetoFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-projeto-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal());
        String sqlFinal = sql.replace(":filtromain", sqlFiltro).replace(":filtro", sqlFiltro);
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal());
        String sqlPagination = this.getSqlPagination(pageable);
        String finalConditional = sqlFiltro + sqlPagination;
        return sql.replace(":filtromain", finalConditional).replace(":filtro", sqlFiltro);
    }

    public RowMapper<ProjetoFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> {
            ProjetoFintelSgoIntegracaoDTO projeto = this.mapperProjeto(rs);
            projeto.setItens(this.mapperItem(rs));
            projeto.setDebitos(this.mapperDebito(rs));
            projeto.setDocumentos(this.mapperDocumento(rs));
            return projeto;
        };
    }

    private ProjetoFintelSgoIntegracaoDTO mapperProjeto(ResultSet rs) throws SQLException {
        ProjetoFintelSgoIntegracaoDTO pessoa = new ProjetoFintelSgoIntegracaoDTO();
        Optional.ofNullable(rs.getString("entidade")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setEntidade(arg_0));
        Optional.ofNullable(rs.getString("exercicioProjeto")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setExercicioProjeto(arg_0));
        Optional.ofNullable(rs.getString("projeto")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setProjeto(arg_0));
        Optional.ofNullable(rs.getString("tipoCadastro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setTipoCadastro(arg_0));
        Optional.ofNullable(rs.getString("cadastroGeral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setCadastroGeral(arg_0));
        Optional.ofNullable(rs.getString("tipoProjeto")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setTipoProjeto(arg_0));
        Optional.ofNullable(rs.getString("data")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setData(arg_0));
        Optional.ofNullable(rs.getString("situacao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setSituacao(arg_0));
        Optional.ofNullable(rs.getString("aprovado")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setAprovado(arg_0));
        Optional.ofNullable(rs.getString("exercicioProtocolo")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setExercicioProtocolo(arg_0));
        Optional.ofNullable(rs.getString("idProcesso")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setIdProcesso(arg_0));
        Optional.ofNullable(rs.getString("projetoSubstituido")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setProjetoSubstituido(arg_0));
        Optional.ofNullable(rs.getString("exercicioProjetoSubstituido")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setExercicioProjetoSubstituido(arg_0));
        Optional.ofNullable(rs.getString("idProcessoIsencao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setIdProcessoIsencao(arg_0));
        Optional.ofNullable(rs.getString("exercicioProtocoloIsencao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setExercicioProtocoloIsencao(arg_0));
        Optional.ofNullable(rs.getString("isencao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setIsencao(arg_0));
        Optional.ofNullable(rs.getString("tipoPessoaConstrutor")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setTipoPessoaConstrutor(arg_0));
        Optional.ofNullable(rs.getString("construtor")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setConstrutor(arg_0));
        Optional.ofNullable(rs.getString("nomeConstrutor")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setNomeConstrutor(arg_0));
        Optional.ofNullable(rs.getString("cnpjCpf")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setCnpjCpf(arg_0));
        Optional.ofNullable(rs.getString("sigla")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setSigla(arg_0));
        Optional.ofNullable(rs.getString("descrLogradouro")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setDescrLogradouro(arg_0));
        Optional.ofNullable(rs.getString("numero")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setNumero(arg_0));
        Optional.ofNullable(rs.getString("complemento")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setComplemento(arg_0));
        Optional.ofNullable(rs.getString("bairroDescr")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setBairroDescr(arg_0));
        Optional.ofNullable(rs.getString("cep")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setCep(arg_0));
        Optional.ofNullable(rs.getString("cidade")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setCidade(arg_0));
        Optional.ofNullable(rs.getString("unidadeFederacao")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setUnidadeFederacao(arg_0));
        Optional.ofNullable(rs.getString("telefoneResidencial")).ifPresent(arg_0 -> ((ProjetoFintelSgoIntegracaoDTO)pessoa).setTelefoneResidencial(arg_0));
        return pessoa;
    }

    private List<ProjetoItemFintelSgoIntegracaoDTO> mapperItem(ResultSet rs) throws SQLException {
        Object[] itens;
        HashMap<String, ProjetoItemFintelSgoIntegracaoDTO> itemMapeado = new HashMap<String, ProjetoItemFintelSgoIntegracaoDTO>();
        Array itemArray = rs.getArray("itens");
        if (itemArray == null) {
            return Collections.emptyList();
        }
        for (Object element : itens = (Object[])itemArray.getArray()) {
            List item;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || itemMapeado.containsKey(id = String.format("%s-%s-%s-%s", (item = TupleUtils.parse((String)tuple)).get(0), item.get(1), item.get(2), item.get(3)))) continue;
            ProjetoItemFintelSgoIntegracaoDTO objectItem = new ProjetoItemFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)item.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setEntidade(arg_0));
            Optional.ofNullable((String)item.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setExercicioProjeto(arg_0));
            Optional.ofNullable((String)item.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setProjeto(arg_0));
            Optional.ofNullable((String)item.get(3)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setTipoCadastro(arg_0));
            Optional.ofNullable((String)item.get(4)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setCadastroGeral(arg_0));
            Optional.ofNullable((String)item.get(5)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setTipoProjeto(arg_0));
            Optional.ofNullable((String)item.get(6)).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setData(arg_0));
            Optional.ofNullable((String)item.get(7)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setProjetoItem(arg_0));
            Optional.ofNullable((String)item.get(8)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setItemConstrucaoCivil(arg_0));
            Optional.ofNullable((String)item.get(9)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setUtilizacao(arg_0));
            Optional.ofNullable((String)item.get(10)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setTipoConstrucao(arg_0));
            Optional.ofNullable((String)item.get(11)).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((ProjetoItemFintelSgoIntegracaoDTO)objectItem).setArea(arg_0));
            itemMapeado.put(id, objectItem);
        }
        ArrayList<ProjetoItemFintelSgoIntegracaoDTO> list = new ArrayList<ProjetoItemFintelSgoIntegracaoDTO>(itemMapeado.values());
        list.sort(Comparator.comparing(ProjetoItemFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private BigDecimal parseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private List<ProjetoDebitoFintelSgoIntegracaoDTO> mapperDebito(ResultSet rs) throws SQLException {
        Object[] debitos;
        HashMap<String, ProjetoDebitoFintelSgoIntegracaoDTO> debitoMapeado = new HashMap<String, ProjetoDebitoFintelSgoIntegracaoDTO>();
        Array debitoArray = rs.getArray("debitos");
        if (debitoArray == null) {
            return Collections.emptyList();
        }
        for (Object element : debitos = (Object[])debitoArray.getArray()) {
            List debito;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || debitoMapeado.containsKey(id = String.format("%s-%s-%s-%s-%s-%s-%s", (debito = TupleUtils.parse((String)tuple)).get(0), debito.get(1), debito.get(2), debito.get(3), debito.get(4), debito.get(5), debito.get(6)))) continue;
            ProjetoDebitoFintelSgoIntegracaoDTO objectDebito = new ProjetoDebitoFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)debito.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setEntidade(arg_0));
            Optional.ofNullable((String)debito.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setExercicioProjeto(arg_0));
            Optional.ofNullable((String)debito.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setProjeto(arg_0));
            Optional.ofNullable((String)debito.get(3)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setExercicio(arg_0));
            Optional.ofNullable((String)debito.get(4)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setGuiaRecolhimento(arg_0));
            Optional.ofNullable((String)debito.get(5)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setSubDivida(arg_0));
            Optional.ofNullable((String)debito.get(6)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setParcela(arg_0));
            Optional.ofNullable((String)debito.get(7)).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setDataVencimento(arg_0));
            Optional.ofNullable((String)debito.get(8)).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setValor(arg_0));
            Optional.ofNullable((String)debito.get(9)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setSigla(arg_0));
            Optional.ofNullable((String)debito.get(10)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setSituacaoDebito(arg_0));
            Optional.ofNullable((String)debito.get(11)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setParcelado(arg_0));
            Optional.ofNullable((String)debito.get(12)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setReparcelado(arg_0));
            Optional.ofNullable((String)debito.get(13)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setMesReferencia(arg_0));
            Optional.ofNullable((String)debito.get(14)).ifPresent(arg_0 -> ((ProjetoDebitoFintelSgoIntegracaoDTO)objectDebito).setTipo(arg_0));
            debitoMapeado.put(id, objectDebito);
        }
        ArrayList<ProjetoDebitoFintelSgoIntegracaoDTO> list = new ArrayList<ProjetoDebitoFintelSgoIntegracaoDTO>(debitoMapeado.values());
        list.sort(Comparator.comparing(ProjetoDebitoFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private List<ProjetoDocumentoFintelSgoIntegracaoDTO> mapperDocumento(ResultSet rs) throws SQLException {
        Object[] documentos;
        HashMap<String, ProjetoDocumentoFintelSgoIntegracaoDTO> documentoMapeado = new HashMap<String, ProjetoDocumentoFintelSgoIntegracaoDTO>();
        Array documentoArray = rs.getArray("documentos");
        if (documentoArray == null) {
            return Collections.emptyList();
        }
        for (Object element : documentos = (Object[])documentoArray.getArray()) {
            List documento;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || documentoMapeado.containsKey(id = String.format("%s-%s-%s-%s-%s-%s", (documento = TupleUtils.parse((String)tuple)).get(0), documento.get(1), documento.get(2), documento.get(3), documento.get(4), documento.get(5)))) continue;
            ProjetoDocumentoFintelSgoIntegracaoDTO objectDocumento = new ProjetoDocumentoFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)documento.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDocumentoFintelSgoIntegracaoDTO)objectDocumento).setEntidade(arg_0));
            Optional.ofNullable((String)documento.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDocumentoFintelSgoIntegracaoDTO)objectDocumento).setTipoDocumento(arg_0));
            Optional.ofNullable((String)documento.get(2)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDocumentoFintelSgoIntegracaoDTO)objectDocumento).setDocumento(arg_0));
            Optional.ofNullable((String)documento.get(3)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDocumentoFintelSgoIntegracaoDTO)objectDocumento).setExercicioDocumento(arg_0));
            Optional.ofNullable((String)documento.get(4)).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((ProjetoDocumentoFintelSgoIntegracaoDTO)objectDocumento).setDataEmissaoDoc(arg_0));
            Optional.ofNullable((String)documento.get(5)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDocumentoFintelSgoIntegracaoDTO)objectDocumento).setExercicioProjeto(arg_0));
            Optional.ofNullable((String)documento.get(6)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ProjetoDocumentoFintelSgoIntegracaoDTO)objectDocumento).setProjeto(arg_0));
            Optional.ofNullable((String)documento.get(7)).ifPresent(arg_0 -> ((ProjetoDocumentoFintelSgoIntegracaoDTO)objectDocumento).setCancelado(arg_0));
            documentoMapeado.put(id, objectDocumento);
        }
        ArrayList<ProjetoDocumentoFintelSgoIntegracaoDTO> list = new ArrayList<ProjetoDocumentoFintelSgoIntegracaoDTO>(documentoMapeado.values());
        list.sort(Comparator.comparing(ProjetoDocumentoFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private LocalDate parseStringToLocalDate(String data) {
        return Objects.nonNull(data) ? LocalDate.parse(data) : null;
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal) {
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            String filtro = "where ((p.data between ':dataInicial' and ':dataFinal') OR (doc.cancelado = 'N' and doc.dataemissao between ':dataInicial' and ':dataFinal'))";
            filtro = filtro.replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial));
            filtro = filtro.replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
            return filtro;
        }
        return "";
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

