/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.ContatoPessoaFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.EnderecoPessoaFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.PessoaFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.tuple.TupleUtils;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.postgresql.util.PGobject;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoPessoaFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<PessoaFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-pessoa-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal());
        String sqlFinal = String.format(sql, sqlFiltro);
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal());
        String sqlPagination = this.getSqlPagination(pageable);
        String finalConditional = sqlFiltro + sqlPagination;
        return String.format(sql, finalConditional);
    }

    public RowMapper<PessoaFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> {
            PessoaFintelSgoIntegracaoDTO pessoa = this.mapperPessoa(rs);
            pessoa.setEnderecos(this.mapperEndereco(rs));
            pessoa.setContatos(this.mapperContato(rs));
            return pessoa;
        };
    }

    private PessoaFintelSgoIntegracaoDTO mapperPessoa(ResultSet rs) throws SQLException {
        PessoaFintelSgoIntegracaoDTO pessoa = new PessoaFintelSgoIntegracaoDTO();
        Optional.ofNullable(rs.getString("Pessoa")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setPessoa(arg_0));
        Optional.ofNullable(rs.getString("Nome")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setNome(arg_0));
        Optional.ofNullable(rs.getString("NomeFantasia")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setNomeFantasia(arg_0));
        Optional.ofNullable(rs.getString("TipoPessoa")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setTipoPessoa(arg_0));
        Optional.ofNullable(rs.getString("CNPJ_CPF")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setCnpjCpf(arg_0));
        Optional.ofNullable(rs.getString("RG")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setRg(arg_0));
        Optional.ofNullable(rs.getString("OrgaoEmissor")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setOrgaoEmissor(arg_0));
        Optional.ofNullable(rs.getString("EstadoEmissor")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setEstadoEmissor(arg_0));
        Optional.ofNullable(rs.getString("DataEmissao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setDataEmissao(arg_0));
        Optional.ofNullable(rs.getString("InscricaoEstadual")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setInscricaoEstadual(arg_0));
        Optional.ofNullable(rs.getString("DataAlteracao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setDataAlteracao(arg_0));
        Optional.ofNullable(rs.getString("DataInclusao")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setDataInclusao(arg_0));
        Optional.ofNullable(rs.getString("Observacao")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setObservacao(arg_0));
        Optional.ofNullable(rs.getString("UsuarioInclusao")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setUsuarioInclusao(arg_0));
        Optional.ofNullable(rs.getString("Inativo")).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setInativo(arg_0));
        Optional.ofNullable(rs.getString("SequenciaEndereco")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setSequenciaEndereco(arg_0));
        Optional.ofNullable(rs.getString("SequenciaContato")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((PessoaFintelSgoIntegracaoDTO)pessoa).setSequenciaContato(arg_0));
        return pessoa;
    }

    private List<EnderecoPessoaFintelSgoIntegracaoDTO> mapperEndereco(ResultSet rs) throws SQLException {
        Object[] enderecos;
        HashMap<String, EnderecoPessoaFintelSgoIntegracaoDTO> enderecoMapeado = new HashMap<String, EnderecoPessoaFintelSgoIntegracaoDTO>();
        Array enderecoArray = rs.getArray("EnderecoPessoa");
        if (enderecoArray == null) {
            return Collections.emptyList();
        }
        for (Object element : enderecos = (Object[])enderecoArray.getArray()) {
            List endereco;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || enderecoMapeado.containsKey(id = String.format("%s-%s", (endereco = TupleUtils.parse((String)tuple)).get(0), endereco.get(1)))) continue;
            EnderecoPessoaFintelSgoIntegracaoDTO objectEndereco = new EnderecoPessoaFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)endereco.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setPessoa(arg_0));
            Optional.ofNullable((String)endereco.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setSequencia(arg_0));
            Optional.ofNullable((String)endereco.get(2)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setTipoEndereco(arg_0));
            Optional.ofNullable((String)endereco.get(3)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setLogradouro(arg_0));
            Optional.ofNullable((String)endereco.get(4)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setLogradouroDescr(arg_0));
            Optional.ofNullable((String)endereco.get(5)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setBairro(arg_0));
            Optional.ofNullable((String)endereco.get(6)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setBairroDescr(arg_0));
            Optional.ofNullable((String)endereco.get(7)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setCidade(arg_0));
            Optional.ofNullable((String)endereco.get(8)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setCidadeDescr(arg_0));
            Optional.ofNullable((String)endereco.get(9)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setNumero(arg_0));
            Optional.ofNullable((String)endereco.get(10)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setComplemento(arg_0));
            Optional.ofNullable((String)endereco.get(11)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setCep(arg_0));
            Optional.ofNullable((String)endereco.get(12)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setUnidadeFederacao(arg_0));
            Optional.ofNullable((String)endereco.get(13)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setTipoLogradouro(arg_0));
            Optional.ofNullable((String)endereco.get(14)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setTipoLogradouroDescr(arg_0));
            Optional.ofNullable((String)endereco.get(15)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setPrincipal(arg_0));
            Optional.ofNullable((String)endereco.get(16)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((EnderecoPessoaFintelSgoIntegracaoDTO)objectEndereco).setCodigoIbge(arg_0));
            enderecoMapeado.put(id, objectEndereco);
        }
        ArrayList<EnderecoPessoaFintelSgoIntegracaoDTO> list = new ArrayList<EnderecoPessoaFintelSgoIntegracaoDTO>(enderecoMapeado.values());
        list.sort(Comparator.comparing(EnderecoPessoaFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private List<ContatoPessoaFintelSgoIntegracaoDTO> mapperContato(ResultSet rs) throws SQLException {
        Object[] contatos;
        HashMap<String, ContatoPessoaFintelSgoIntegracaoDTO> contatoMapeado = new HashMap<String, ContatoPessoaFintelSgoIntegracaoDTO>();
        Array contatoArray = rs.getArray("ContatoPessoa");
        if (contatoArray == null) {
            return Collections.emptyList();
        }
        for (Object element : contatos = (Object[])contatoArray.getArray()) {
            List contato;
            String id;
            PGobject pgObj;
            String tuple;
            if (!(element instanceof PGobject) || (tuple = (pgObj = (PGobject)element).getValue()) == null || contatoMapeado.containsKey(id = String.format("%s-%s", (contato = TupleUtils.parse((String)tuple)).get(0), contato.get(1)))) continue;
            ContatoPessoaFintelSgoIntegracaoDTO objectContato = new ContatoPessoaFintelSgoIntegracaoDTO();
            Optional.ofNullable((String)contato.get(0)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setPessoa(arg_0));
            Optional.ofNullable((String)contato.get(1)).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setSequencia(arg_0));
            Optional.ofNullable((String)contato.get(2)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setNome(arg_0));
            Optional.ofNullable((String)contato.get(3)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setTelefoneResidencial(arg_0));
            Optional.ofNullable((String)contato.get(4)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setTelefoneComercial(arg_0));
            Optional.ofNullable((String)contato.get(5)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setTelefoneFax(arg_0));
            Optional.ofNullable((String)contato.get(6)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setTelefoneCelular(arg_0));
            Optional.ofNullable((String)contato.get(7)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setEmail(arg_0));
            Optional.ofNullable((String)contato.get(8)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setHomePage(arg_0));
            Optional.ofNullable((String)contato.get(9)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setRepresentanteLegal(arg_0));
            Optional.ofNullable((String)contato.get(10)).ifPresent(arg_0 -> ((ContatoPessoaFintelSgoIntegracaoDTO)objectContato).setPrincipal(arg_0));
            contatoMapeado.put(id, objectContato);
        }
        ArrayList<ContatoPessoaFintelSgoIntegracaoDTO> list = new ArrayList<ContatoPessoaFintelSgoIntegracaoDTO>(contatoMapeado.values());
        list.sort(Comparator.comparing(ContatoPessoaFintelSgoIntegracaoDTO::getId));
        return list;
    }

    private LocalDate parseStringToLocalDate(String data) {
        return Objects.nonNull(data) ? LocalDate.parse(data) : null;
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal) {
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            return "where ((p.dataalteracao between ':dataInicial' and ':dataFinal')  or (p.datainclusao between ':dataInicial' and ':dataFinal'))".replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial)).replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
        }
        return "";
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

